/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class ReadPropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private File[] files;
    private boolean quiet;

    public void execute() throws MojoExecutionException {
        Properties projectProperties = new Properties();
        int i = 0;
        while (i < this.files.length) {
            File file = this.files[i];
            try {
                FileInputStream stream = new FileInputStream(file);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Loading property file: " + file));
                }
                projectProperties = this.project.getProperties();
                try {
                    projectProperties.load(stream);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (this.quiet) {
                    this.getLog().warn((CharSequence)("Cannot load property file: " + file), (Throwable)e);
                }
                throw new MojoExecutionException("Error: ", (Exception)e);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error: ", e);
            }
            ++i;
        }
        boolean useEnvVariables = false;
        Enumeration<?> n = projectProperties.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            String p = (String)projectProperties.get(k);
            if (p.indexOf("${env.") == -1) continue;
            useEnvVariables = true;
            break;
        }
        Properties environment = null;
        if (useEnvVariables) {
            try {
                environment = CommandLineUtils.getSystemEnvVars();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error: ", (Exception)e);
            }
        }
        Enumeration<?> n2 = projectProperties.propertyNames();
        while (n2.hasMoreElements()) {
            String k = (String)n2.nextElement();
            projectProperties.setProperty(k, this.getPropertyValue(k, projectProperties, environment));
        }
    }

    private String getPropertyValue(String k, Properties p, Properties environment) {
        int idx;
        String v = p.getProperty(k);
        String ret = "";
        while ((idx = v.indexOf("${")) >= 0) {
            ret = String.valueOf(ret) + v.substring(0, idx);
            int idx2 = (v = v.substring(idx + 2)).indexOf("}");
            if (idx2 < 0) break;
            String nk = v.substring(0, idx2);
            v = v.substring(idx2 + 1);
            String nv = p.getProperty(nk);
            if (nv == null) {
                nv = System.getProperty(nk);
            }
            if (nv == null && nk.startsWith("env.") && environment != null) {
                nv = environment.getProperty(nk.substring(4));
            }
            if (nv == null || nv.equals(nk)) {
                ret = String.valueOf(ret) + "${" + nk + "}";
                continue;
            }
            v = String.valueOf(nv) + v;
        }
        return String.valueOf(ret) + v;
    }
}

