/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class ProjectSourceContext
implements Contextualizable {
    public static final String ROLE = ProjectSourceContext.class.getName();
    public static final String ROLE_HINT = "default";
    private static final String SOURCE_ARTIFACT_WAS_RESOLVED_KEY = "source-artifact-was-resolved";
    private static final String SOURCE_DIRECTORY_KEY = "source-directory";
    private static final String SOURCE_ORIGINAL_LOCATION_KEY = "original-source-location";
    private static final String SOURCE_ARTIFACT_GRP_KEY = "source-artifact-grp";
    private static final String SOURCE_ARTIFACT_ID_KEY = "source-artifact-id";
    private static final String SOURCE_ARTIFACT_TYPE_KEY = "source-artifact-type";
    private static final String SOURCE_ARTIFACT_VERSION_KEY = "source-artifact-version";
    private static final String SOURCE_ARTIFACT_CLASS_KEY = "source-artifact-classifier";
    private boolean sourceArtifactResolved;
    private File sourceDirectory;
    private Artifact sourceArtifact;
    private File originalSourceLocation;
    private Context context;
    private PlexusContainer container;

    public boolean hasProjectSourceDirectory() {
        return this.sourceDirectory != null;
    }

    public void setProjectSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getProjectSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceArtifactResolved(boolean sourceArtifactResolved) {
        this.sourceArtifactResolved = sourceArtifactResolved;
    }

    public boolean isSourceArtifactResolved() {
        return this.sourceArtifactResolved;
    }

    public void store(MavenSession session) throws ComponentLookupException {
        BuildAdvisor ba = (BuildAdvisor)this.container.lookup(BuildAdvisor.ROLE, ROLE_HINT);
        ba.store(session, SOURCE_ARTIFACT_WAS_RESOLVED_KEY, (Object)this.isSourceArtifactResolved());
        ba.store(session, SOURCE_DIRECTORY_KEY, (Object)this.getProjectSourceDirectory());
        ba.store(session, SOURCE_ORIGINAL_LOCATION_KEY, (Object)this.getOriginalProjectSourceLocation());
        Artifact art = this.getProjectSourceArtifact();
        if (art != null && art.getGroupId() != null && art.getArtifactId() != null && art.getVersion() != null) {
            ba.store(session, SOURCE_ARTIFACT_GRP_KEY, (Object)art.getGroupId());
            ba.store(session, SOURCE_ARTIFACT_ID_KEY, (Object)art.getArtifactId());
            ba.store(session, SOURCE_ARTIFACT_TYPE_KEY, (Object)art.getType());
            ba.store(session, SOURCE_ARTIFACT_VERSION_KEY, (Object)art.getVersion());
            ba.store(session, SOURCE_ARTIFACT_CLASS_KEY, (Object)art.getClassifier());
        } else {
            ba.store(session, SOURCE_ARTIFACT_GRP_KEY, null);
            ba.store(session, SOURCE_ARTIFACT_ID_KEY, null);
            ba.store(session, SOURCE_ARTIFACT_TYPE_KEY, null);
            ba.store(session, SOURCE_ARTIFACT_VERSION_KEY, null);
            ba.store(session, SOURCE_ARTIFACT_CLASS_KEY, null);
        }
    }

    public void read(MavenSession session) throws ComponentLookupException {
        Artifact artifact;
        BuildAdvisor ba = (BuildAdvisor)this.container.lookup(BuildAdvisor.ROLE, ROLE_HINT);
        Boolean isResolved = (Boolean)ba.retrieve(session, SOURCE_ARTIFACT_WAS_RESOLVED_KEY);
        if (isResolved != null) {
            this.setSourceArtifactResolved(isResolved);
        } else {
            this.setSourceArtifactResolved(false);
        }
        this.setProjectSourceDirectory((File)ba.retrieve(session, SOURCE_DIRECTORY_KEY));
        this.setOriginalProjectSourceLocation((File)ba.retrieve(session, SOURCE_ORIGINAL_LOCATION_KEY));
        String grp = (String)ba.retrieve(session, SOURCE_ARTIFACT_GRP_KEY);
        String id = (String)ba.retrieve(session, SOURCE_ARTIFACT_ID_KEY);
        String typ = (String)ba.retrieve(session, SOURCE_ARTIFACT_TYPE_KEY);
        String ver = (String)ba.retrieve(session, SOURCE_ARTIFACT_VERSION_KEY);
        String cls = (String)ba.retrieve(session, SOURCE_ARTIFACT_CLASS_KEY);
        try {
            ArtifactFactory artifactFactory = (ArtifactFactory)this.container.lookup(ArtifactFactory.ROLE);
            artifact = artifactFactory.createArtifactWithClassifier(grp, id, ver, typ, cls);
        }
        catch (InvalidArtifactRTException e) {
            this.setProjectSourceArtifact(null);
            return;
        }
        this.setProjectSourceArtifact(artifact);
    }

    public void setProjectSourceArtifact(Artifact sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
    }

    public Artifact getProjectSourceArtifact() {
        return this.sourceArtifact;
    }

    public void setOriginalProjectSourceLocation(File originalSourceLocation) {
        this.originalSourceLocation = originalSourceLocation;
    }

    public File getOriginalProjectSourceLocation() {
        return this.originalSourceLocation;
    }

    public void contextualize(Context mycontext) throws ContextException {
        this.context = mycontext;
        this.container = (PlexusContainer)mycontext.get((Object)"plexus");
    }
}

