/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.project.archive.AbstractProjectSourcesMojo;
import org.codehaus.mojo.project.archive.ProjectSourceContext;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DeployProjectSourcesMojo
extends AbstractProjectSourcesMojo {
    private ArtifactRepository deploymentRepository;
    private ArtifactDeployer artifactDeployer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectSourceContext context;
        try {
            context = this.loadContext();
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to read build cookies.");
        }
        if (!context.isSourceArtifactResolved()) {
            File sourceArtifactFile;
            File sshDir;
            Artifact sourceArtifact = context.getProjectSourceArtifact();
            if (sourceArtifact == null) {
                throw new MojoExecutionException("Project-sources artifact not found. \nPlease ensure the package-project-sources mojo is bound to the current lifecycle.");
            }
            String protocol = this.deploymentRepository.getProtocol();
            if (protocol.equals("scp") && !(sshDir = new File(System.getProperty("user.home"), ".ssh")).exists()) {
                sshDir.mkdirs();
            }
            if ((sourceArtifactFile = sourceArtifact.getFile()) == null) {
                throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
            }
            try {
                this.artifactDeployer.deploy(sourceArtifactFile, sourceArtifact, this.deploymentRepository, this.getLocalRepository());
            }
            catch (ArtifactDeploymentException e) {
                throw new MojoExecutionException("Failed to deploy project-sources artifact: " + sourceArtifact + " to repository with id: " + this.deploymentRepository.getId());
            }
        }
    }
}

