/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pde;

import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pde.descriptor.Descriptor;
import org.codehaus.mojo.pde.descriptor.DescriptorUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractEclipsePDEMojo
extends AbstractMojo {
    private static final int CONFIG_TUPLE = 3;
    protected MavenProject project;
    protected File pdeDirectory;
    protected String pdeProductFilename;
    protected String pdeBuildVersion;
    protected String pdeBuildConfigDirectory;
    protected File eclipseInstall;
    protected boolean antDebug;
    protected boolean antVerbose;
    protected Descriptor descriptor;
    private File startupJar;
    PropertiesConfiguration buildConfigurationProperties = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialize();
    }

    protected void initialize() throws MojoExecutionException, MojoFailureException {
        if (this.pdeDirectory == null) {
            this.pdeDirectory = new File(System.getProperty("user.dir"));
        }
        this.startupJar = new File(this.eclipseInstall, "startup.jar");
        if (!this.startupJar.exists()) {
            throw new MojoExecutionException(this.startupJar.getPath() + " not found.  Have you set up your -DeclipseInstall?");
        }
        if (this.pdeProductFilename != null) {
            if (this.pdeBuildVersion == null) {
                throw new MojoExecutionException("pdeBuildVersion must be specified for a product build.");
            }
            this.loadBuildConfigurationProperties();
        }
        this.descriptor = DescriptorUtil.getDescriptor(this.pdeDirectory, this.pdeProductFilename);
    }

    protected void executeCommandLine(Commandline cl) throws MojoExecutionException {
        int ok;
        try {
            DefaultConsumer stdout;
            DefaultConsumer stderr = stdout = new DefaultConsumer();
            this.getLog().info((CharSequence)cl.toString());
            ok = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error executing command line", (Exception)((Object)e));
        }
        if (ok != 0) {
            throw new MojoExecutionException("Error executing command line. Exit code:" + ok);
        }
    }

    protected Commandline createCommandLine(File buildFile, String targets) {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(this.pdeDirectory.getPath());
        cl.setExecutable("java");
        cl.createArgument().setValue("-classpath");
        cl.createArgument().setFile(this.startupJar);
        cl.createArgument().setValue("org.eclipse.core.launcher.Main");
        cl.createArgument().setValue("-application");
        cl.createArgument().setValue("org.eclipse.ant.core.antRunner");
        cl.createArgument().setValue("-buildfile");
        cl.createArgument().setValue(buildFile.toString());
        if (targets != null) {
            cl.createArgument().setLine(targets);
        }
        if (this.antVerbose) {
            cl.createArgument().setValue("-verbose");
        }
        if (this.antDebug) {
            cl.createArgument().setValue("-debug");
        }
        return cl;
    }

    protected Commandline createCommandLine(File buildFile) {
        return this.createCommandLine(buildFile, null);
    }

    protected File getPDEBuildDirectory() {
        return new File(this.pdeDirectory, "../..");
    }

    protected File getBaseLocation() {
        return this.eclipseInstall;
    }

    protected PropertiesConfiguration loadBuildConfigurationProperties() throws MojoExecutionException {
        if (this.buildConfigurationProperties != null) {
            return this.buildConfigurationProperties;
        }
        File buildPropertiesFile = new File(this.pdeDirectory, this.pdeBuildConfigDirectory + "/build.properties");
        try {
            this.buildConfigurationProperties = new PropertiesConfiguration();
            this.buildConfigurationProperties.setDelimiterParsingDisabled(true);
            this.buildConfigurationProperties.load(buildPropertiesFile);
            return this.buildConfigurationProperties;
        }
        catch (ConfigurationException e) {
            throw new MojoExecutionException("Failed to load pde build.properties from " + buildPropertiesFile.getPath(), (Exception)((Object)e));
        }
    }

    protected String convertPdeConfigsToFilenameSuffix(String configs) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)configs)) {
            throw new MojoExecutionException("Null pde configs can not be converted to filename suffix");
        }
        if (configs.indexOf("&") > 0) {
            throw new MojoExecutionException("Pde build only supports a build with a single config only.");
        }
        Object[] strings = StringUtils.split((String)configs, (String)",");
        if (strings.length != 3) {
            throw new MojoExecutionException("Invalid PDE Config \"" + configs + "\": must be of the form: os, ws, arch");
        }
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = ((String)strings[i]).trim();
        }
        return StringUtils.join((Object[])strings, (String)".");
    }
}

