/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.ounce.ScanMojo;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
@Execute(lifecycle="scan", phase=LifecyclePhase.INSTALL)
public class ReportMojo
extends ScanMojo
implements MavenReport {
    @Parameter(property="ounce.reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/ounce", required=true, readonly=true)
    private File reportOutputDirectory;
    @Parameter(property="ounce.existingAssessmentFile")
    String existingAssessmentFile;
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Component
    private Renderer siteRenderer;

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name");
    }

    public String getOutputName() {
        return "Ounce-Analysis/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("ounce-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"Generating...");
        if (this.existingAssessmentFile != null) {
            if (this.options == null) {
                this.options = new HashMap();
            }
            this.options.put("existingAssessmentFile", this.existingAssessmentFile);
        }
        super.execute();
    }

    public boolean canGenerateReport() {
        return true;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.getLog().warn((CharSequence)"Generating...");
        this.waitForScan = true;
        if (this.reportType == null) {
            this.reportType = "Findings";
        }
        if (this.reportOutputType == null) {
            this.reportOutputType = "html";
        }
        this.reportOutputPath = this.reportOutputDirectory + File.separator + this.getOutputName() + ".html";
        try {
            super.execute();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Execption generating report:", (Exception)((Object)e));
        }
        catch (MojoFailureException e) {
            throw new MavenReportException("Execption generating report:", (Exception)((Object)e));
        }
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.reportOutputDirectory = outputDirectory;
    }
}

