/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.ounce.AbstractOunceMojo;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.utils.Utils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Mojo(name="project-only", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public class ProjectOnlyMojo
extends AbstractOunceMojo {
    public static final String M2_REPO = "M2_REPO";
    @Parameter(property="ounce.classpathScope", defaultValue="compile")
    private String classpathScope;
    @Parameter(property="ounce.jspCompilerName", defaultValue="Tomcat 8")
    private String jspCompilerName;
    @Parameter(property="ounce.jspCompilerType", defaultValue="13")
    private String jspCompilerType;
    @Parameter(property="ounce.jdkName")
    private String jdkName;
    @Parameter(property="ounce.javaCompilerOptions")
    private String javaCompilerOptions;
    @Parameter(property="ounce.includeTestSources", defaultValue="false")
    protected boolean includeTestSources;
    @Parameter(property="ounce.webappDirectory", defaultValue="${project.build.directory}/${project.build.finalName}.war")
    private String webappDirectory;
    @Parameter(property="ounce.createVariables", defaultValue="true")
    protected boolean createVariables;
    @Parameter(property="ounce.forceWeb", defaultValue="false")
    protected boolean forceWeb;
    @Parameter(property="ounce.installDir")
    private String installDir;
    @Parameter(property="ounce.analyzeStrutsFramework", defaultValue="false")
    private boolean analyzeStrutsFramework;
    @Parameter(property="ounce.importStrutsValidation", defaultValue="false")
    private boolean importStrutsValidation;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository local;
    @Parameter(property="ounce.precompileScan", defaultValue="false")
    private boolean precompileScan;
    @Parameter(property="ounce.projectDir", defaultValue="${basedir}")
    private String projectDir;
    @Parameter(property="ounce.appDir", defaultValue="${basedir}")
    private String appDir;
    @Parameter(property="ounce.externalJars", defaultValue="${basedir}")
    private String externalJars;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging() != "pom" || !this.skipPoms) {
            try {
                if (this.createVariables) {
                    this.configureVariables();
                }
                this.getCore().createProject(this.getProjectRoot(), this.name, this.jspCompilerName, this.jspCompilerType, this.getProjectRoot(), this.getSourceRoots(), this.getWebRoot(), this.getClasspath(), this.jdkName, this.javaCompilerOptions, this.project.getPackaging(), this.getOptions(), this.forceWeb, this.analyzeStrutsFramework, this.importStrutsValidation, this.projectDir, this.getLog());
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Unable to lookup the core interface for hint: " + this.coreHint, (Exception)((Object)e));
            }
            catch (OunceCoreException e) {
                throw new MojoExecutionException("Nested Ouncecore exception: " + e.getLocalizedMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Pom project.");
        }
    }

    protected List<String> getSourceRoots() {
        List sourceRoots = this.project.getCompileSourceRoots();
        if (this.includeTestSources) {
            sourceRoots.addAll(this.project.getTestCompileSourceRoots());
        }
        return Utils.convertToRelativePaths(sourceRoots, this.projectDir);
    }

    protected Map<String, String> getOptions() {
        if (this.options == null) {
            this.options = new HashMap();
        }
        if (this.precompileScan && new File(this.project.getBuild().getOutputDirectory()).isDirectory()) {
            File classesDir = new File(this.project.getBuild().getOutputDirectory());
            if (!Utils.getFilesOfType(classesDir, ".class").isEmpty()) {
                String precompiledDir = Utils.makeRelative(classesDir.getAbsolutePath(), this.projectDir);
                this.options.put("precompiled", precompiledDir.replace('\\', '/'));
            } else {
                this.options.put("precompiled", "");
            }
        }
        return this.options;
    }

    protected String getClasspath() throws MojoExecutionException {
        List classpathElements = this.getClasspathElements();
        StringBuffer sb = new StringBuffer();
        Iterator i = classpathElements.iterator();
        if (i.hasNext()) {
            String cpe = (String)i.next();
            String converted_cpe = Utils.convertClasspathElement(cpe, this.projectDir, this.pathVariableMap);
            sb.append(converted_cpe);
            this.getLog().debug((CharSequence)("ProjectOnlyMojo|buildClasspath: " + cpe + " converted: " + converted_cpe));
            while (i.hasNext()) {
                String cpe2 = (String)i.next();
                String converted_cpe2 = Utils.convertClasspathElement(cpe2, this.projectDir, this.pathVariableMap);
                sb.append(File.pathSeparator);
                sb.append(converted_cpe2);
                this.getLog().debug((CharSequence)("ProjectOnlyMojo|buildClasspath: " + cpe2 + " converted: " + converted_cpe2));
            }
        }
        for (String jar : this.getExternalJars().split(",")) {
            sb.append(File.pathSeparator + Utils.makeRelative(jar, this.projectDir));
        }
        return sb.toString();
    }

    protected List getClasspathElements() throws MojoExecutionException {
        List classpathElements;
        block6: {
            classpathElements = null;
            try {
                if ("test".equalsIgnoreCase(this.classpathScope) || this.includeTestSources) {
                    classpathElements = this.project.getTestClasspathElements();
                    break block6;
                }
                if ("compile".equalsIgnoreCase(this.classpathScope)) {
                    classpathElements = this.project.getCompileClasspathElements();
                    break block6;
                }
                if ("runtime".equalsIgnoreCase(this.classpathScope)) {
                    classpathElements = this.project.getRuntimeClasspathElements();
                    break block6;
                }
                if ("system".equalsIgnoreCase(this.classpathScope)) {
                    classpathElements = this.project.getSystemClasspathElements();
                    break block6;
                }
                throw new MojoExecutionException("Invalid classpathScope: " + this.classpathScope + " valid values are: compile, test, runtime, system.");
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
        }
        return classpathElements;
    }

    protected String getWebRoot() {
        if (!this.project.getPackaging().equalsIgnoreCase("war")) {
            return "";
        }
        return Utils.makeRelative(this.webappDirectory, this.projectDir);
    }

    private void configureVariables() throws OunceCoreException, ComponentLookupException {
        if (this.pathVariableMap == null) {
            this.pathVariableMap = new HashMap();
        }
        this.pathVariableMap.put(M2_REPO, this.local.getBasedir());
        this.getCore().createPathVariables(this.pathVariableMap, this.installDir, this.getLog());
    }

    protected String getClasspathScope() {
        return this.classpathScope;
    }

    protected void setClasspathScope(String theClasspathScope) {
        this.classpathScope = theClasspathScope;
    }

    protected String getJdkName() {
        return this.jdkName;
    }

    protected void setJdkName(String theJdkName) {
        this.jdkName = theJdkName;
    }

    protected boolean isIncludeTestSources() {
        return this.includeTestSources;
    }

    protected void setIncludeTestSources(boolean theIncludeTestSources) {
        this.includeTestSources = theIncludeTestSources;
    }

    protected String getJavaCompilerOptions() {
        return this.javaCompilerOptions;
    }

    protected void setJavaCompilerOptions(String theJavaCompilerOptions) {
        this.javaCompilerOptions = theJavaCompilerOptions;
    }

    protected boolean getAnalyzeStrutsFramework() {
        return this.analyzeStrutsFramework;
    }

    protected void setAnalyzeStrutsFramework(boolean analyzeStrutsFramework) {
        this.analyzeStrutsFramework = analyzeStrutsFramework;
    }

    protected boolean getImportStrutsValidation() {
        return this.importStrutsValidation;
    }

    protected void setImportStrutsValidation(boolean importStrutsValidation) {
        this.importStrutsValidation = importStrutsValidation;
    }

    public ArtifactRepository getLocal() {
        return this.local;
    }

    public void setLocal(ArtifactRepository theLocal) {
        this.local = theLocal;
    }

    public boolean isPrecompileScan() {
        return this.precompileScan;
    }

    public void setPrecompileScan(boolean precompileScan) {
        this.precompileScan = precompileScan;
    }

    public String getExternalJars() {
        return this.externalJars;
    }

    public void setExternalJars(String externalJars) {
        this.externalJars = externalJars;
    }

    public boolean getPrecompileScan() {
        return this.precompileScan;
    }

    public String getProjectDir() {
        return this.projectDir;
    }
}

