/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.mrm.api.ResolverUtils;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;

public class ProxyArtifactStore
extends BaseArtifactStore {
    private final List<RemoteRepository> remoteRepositories;
    private final Log log;
    private final Map<String, Map<String, org.codehaus.mojo.mrm.api.maven.Artifact>> children = new HashMap<String, Map<String, org.codehaus.mojo.mrm.api.maven.Artifact>>();
    private final RepositorySystem repositorySystem;
    private final MavenSession session;
    private final ArchetypeManager archetypeManager;

    public ProxyArtifactStore(FactoryHelper factoryHelper, MavenSession session, Log log) {
        this.repositorySystem = Objects.requireNonNull(factoryHelper.getRepositorySystem());
        this.archetypeManager = Objects.requireNonNull(factoryHelper.getArchetypeManager());
        this.log = log;
        this.session = Objects.requireNonNull(session);
        this.remoteRepositories = Stream.concat(session.getCurrentProject().getRemoteProjectRepositories().stream(), session.getCurrentProject().getRemotePluginRepositories().stream()).distinct().collect(Collectors.toList());
    }

    private synchronized void addResolved(org.codehaus.mojo.mrm.api.maven.Artifact artifact) {
        String path = artifact.getGroupId().replace('.', '/') + '/' + artifact.getArtifactId() + "/" + artifact.getVersion();
        Map artifactMapper = this.children.computeIfAbsent(path, k -> new HashMap());
        artifactMapper.put(artifact.getName(), artifact);
        this.addResolved(path);
    }

    private synchronized void addResolved(String path) {
        int index = path.lastIndexOf(47);
        while (index > 0) {
            String name = path.substring(index + 1);
            path = path.substring(0, index);
            Map artifactMapper = this.children.computeIfAbsent(path, k -> new HashMap());
            artifactMapper.put(name, null);
            index = path.lastIndexOf(47);
        }
        if (!StringUtils.isEmpty((String)path)) {
            Map artifactMapper = this.children.computeIfAbsent("", k -> new HashMap());
            artifactMapper.put(path, null);
        }
    }

    public synchronized Set<String> getGroupIds(String parentGroupId) {
        String path = parentGroupId.replace('.', '/');
        Map<String, org.codehaus.mojo.mrm.api.maven.Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public synchronized Set<String> getArtifactIds(String groupId) {
        String path = groupId.replace('.', '/');
        Map<String, org.codehaus.mojo.mrm.api.maven.Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public synchronized Set<String> getVersions(String groupId, String artifactId) {
        String path = groupId.replace('.', '/') + '/' + artifactId;
        Map<String, org.codehaus.mojo.mrm.api.maven.Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public synchronized Set<org.codehaus.mojo.mrm.api.maven.Artifact> getArtifacts(String groupId, String artifactId, String version) {
        String path = groupId.replace('.', '/') + '/' + artifactId + "/" + version;
        Map<String, org.codehaus.mojo.mrm.api.maven.Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.values().stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private File resolveArtifactFile(org.codehaus.mojo.mrm.api.maven.Artifact artifact) throws ArtifactNotFoundException {
        try {
            File file = Optional.ofNullable(this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest(ResolverUtils.createArtifact((MavenSession)this.session, (org.codehaus.mojo.mrm.api.maven.Artifact)artifact), this.remoteRepositories, ((Object)((Object)this)).getClass().getSimpleName())).getArtifact()).map(Artifact::getFile).filter(File::isFile).map(f -> {
                try {
                    File file = f;
                    return file;
                }
                finally {
                    this.addResolved(artifact);
                }
            }).orElseThrow(() -> new ArtifactNotFoundException(artifact));
            this.log.debug((CharSequence)("resolveArtifactFile(" + artifact + ") = " + file.getAbsolutePath()));
            return file;
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactNotFoundException(artifact, (Throwable)e);
        }
    }

    public long getLastModified(org.codehaus.mojo.mrm.api.maven.Artifact artifact) throws ArtifactNotFoundException {
        return this.resolveArtifactFile(artifact).lastModified();
    }

    public long getSize(org.codehaus.mojo.mrm.api.maven.Artifact artifact) throws ArtifactNotFoundException {
        return this.resolveArtifactFile(artifact).length();
    }

    public InputStream get(org.codehaus.mojo.mrm.api.maven.Artifact artifact) throws IOException, ArtifactNotFoundException {
        return Files.newInputStream(this.resolveArtifactFile(artifact).toPath(), new OpenOption[0]);
    }

    public void set(org.codehaus.mojo.mrm.api.maven.Artifact artifact, InputStream content) {
        throw new UnsupportedOperationException();
    }

    public org.apache.maven.artifact.repository.metadata.Metadata getMetadata(String path) throws MetadataNotFoundException {
        String artifactId;
        String version;
        Metadata.Nature metadataNature;
        LinkedList<String> pathItems = new LinkedList<String>(Arrays.asList(StringUtils.strip((String)path, (String)"/").split("/")));
        if (pathItems.getLast().endsWith("-SNAPSHOT")) {
            if (pathItems.size() < 3) {
                throw new MetadataNotFoundException(path);
            }
            metadataNature = Metadata.Nature.SNAPSHOT;
            version = pathItems.pollLast();
            artifactId = pathItems.pollLast();
        } else {
            metadataNature = Metadata.Nature.RELEASE_OR_SNAPSHOT;
            version = null;
            artifactId = null;
        }
        String groupId = String.join((CharSequence)".", pathItems);
        DefaultMetadata requestedMetadata = new DefaultMetadata(groupId, artifactId, version, "maven-metadata.xml", metadataNature);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        for (RemoteRepository repo : this.remoteRepositories) {
            MetadataRequest request = new MetadataRequest();
            request.setMetadata((Metadata)requestedMetadata);
            request.setRepository(repo);
            requests.add(request);
        }
        List metadataResults = this.repositorySystem.resolveMetadata(this.session.getRepositorySession(), requests);
        org.apache.maven.artifact.repository.metadata.Metadata resultMetadata = null;
        for (MetadataResult result : metadataResults) {
            org.apache.maven.artifact.repository.metadata.Metadata metadata;
            if (!result.isResolved() || (metadata = this.readMetadata(result.getMetadata().getFile())) == null) continue;
            if (resultMetadata == null) {
                resultMetadata = metadata;
                continue;
            }
            resultMetadata.merge(metadata);
        }
        if (resultMetadata == null) {
            throw new MetadataNotFoundException(path);
        }
        this.addResolved(path);
        return resultMetadata;
    }

    private org.apache.maven.artifact.repository.metadata.Metadata readMetadata(File file) {
        org.apache.maven.artifact.repository.metadata.Metadata metadata;
        block8: {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                metadata = new MetadataXpp3Reader().read(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    this.log.warn((CharSequence)("Error reading metadata from file: " + file), e);
                    return null;
                }
            }
            in.close();
        }
        return metadata;
    }

    public long getMetadataLastModified(String path) throws MetadataNotFoundException {
        org.apache.maven.artifact.repository.metadata.Metadata metadata = this.getMetadata(path);
        if (!(metadata == null || StringUtils.isEmpty((String)metadata.getGroupId()) && StringUtils.isEmpty((String)metadata.getArtifactId()) && StringUtils.isEmpty((String)metadata.getVersion()) && (metadata.getPlugins() == null || metadata.getPlugins().isEmpty()) && (metadata.getVersioning() == null || StringUtils.isEmpty((String)metadata.getVersioning().getLastUpdated()) && StringUtils.isEmpty((String)metadata.getVersioning().getLatest()) && StringUtils.isEmpty((String)metadata.getVersioning().getRelease()) && (metadata.getVersioning().getVersions() == null || metadata.getVersioning().getVersions().isEmpty()) && metadata.getVersioning().getSnapshot() == null))) {
            return System.currentTimeMillis();
        }
        throw new MetadataNotFoundException(path);
    }

    public ArchetypeCatalog getArchetypeCatalog() {
        return this.archetypeManager.getLocalCatalog(this.session.getProjectBuildingRequest());
    }

    public long getArchetypeCatalogLastModified() throws ArchetypeCatalogNotFoundException {
        if (this.archetypeManager.getLocalCatalog(this.session.getProjectBuildingRequest()) != null) {
            return System.currentTimeMillis();
        }
        throw new ArchetypeCatalogNotFoundException();
    }
}

