/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.minijar.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.vafer.dependency.resources.ResourceHandler;
import org.vafer.dependency.resources.Version;
import org.vafer.dependency.utils.Jar;

public final class ComponentsXmlHandler
implements ResourceHandler {
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";
    private Map components;

    public void onStartProcessing(JarOutputStream pOutput) throws IOException {
        this.components = new LinkedHashMap();
    }

    public void onStartJar(Jar pJar, JarOutputStream pOutput) throws IOException {
    }

    public InputStream onResource(Jar pJar, String oldName, String newName, Version[] versions, InputStream inputStream) throws IOException {
        if (COMPONENTS_XML_PATH.equals(oldName)) {
            Xpp3Dom dom;
            File file = File.createTempFile("minijar", "tmp");
            file.deleteOnExit();
            FileOutputStream os = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
            ((OutputStream)os).close();
            try {
                dom = Xpp3DomBuilder.build((Reader)new FileReader(file));
            }
            catch (Exception e) {
                throw new IOException("Error parsing components.xml in " + pJar + " at " + oldName);
            }
            Xpp3Dom[] children = dom.getChild("components").getChildren("component");
            for (int i = 0; i < children.length; ++i) {
                Xpp3Dom component = children[i];
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                this.components.put(role + roleHint, component);
            }
            return new FileInputStream(file);
        }
        return inputStream;
    }

    public void onStopJar(Jar pJar, JarOutputStream pOutput) throws IOException {
    }

    public void onStopProcessing(JarOutputStream pOutput) throws IOException {
        if (this.components.size() == 0) {
            return;
        }
        Xpp3Dom dom = new Xpp3Dom("component-set");
        Xpp3Dom componentDom = new Xpp3Dom("components");
        dom.addChild(componentDom);
        Iterator it = this.components.values().iterator();
        while (it.hasNext()) {
            Xpp3Dom component = (Xpp3Dom)it.next();
            componentDom.addChild(component);
        }
        pOutput.putNextEntry(new JarEntry(COMPONENTS_XML_PATH));
        Xpp3DomWriter.write((Writer)new OutputStreamWriter(pOutput), (Xpp3Dom)dom);
    }
}

