/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildNumber;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.mojo.buildNumber.InfoScmResult;
import org.codehaus.mojo.buildNumber.SvnInfoConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnInfoCommand
extends AbstractCommand
implements SvnCommand {
    protected InfoScmResult executeInfoCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        Commandline cl = SvnInfoCommand.createCommandline((SvnScmProviderRepository)repo, fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        SvnInfoConsumer stdin = new SvnInfoConsumer(this.getLogger());
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        Process process = null;
        try {
            String line;
            process = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                stdin.consumeLine(line);
            }
            br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = br.readLine()) != null) {
                stderr.consumeLine(line);
            }
            process.waitFor();
        }
        catch (CommandLineException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        if (process != null && process.exitValue() != 0) {
            process.destroy();
            return new InfoScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        process.destroy();
        return new InfoScmResult(cl.toString(), stdin.getProperties(), stdin.getCommandOutput());
    }

    private static Commandline createCommandline(SvnScmProviderRepository repository, File workingDirectory) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)workingDirectory, (SvnScmProviderRepository)repository);
        cl.createArgument().setValue("info");
        return cl;
    }

    protected ScmResult executeCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, CommandParameters commandParameters) throws ScmException {
        return this.executeInfoCommand(scmProviderRepository, scmFileSet);
    }
}

