/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.make.AbstractMakeExecMojo;

public class MakeDistExecMojo
extends AbstractMakeExecMojo {
    private String distCommand;
    private String distTarget;
    private boolean skipDist;
    private List<String> distOptions;
    private MavenProjectHelper projectHelper;
    private String sourceArchivePath;
    private String sourceArchive;

    public void execute() throws MojoExecutionException {
        try {
            this.setCommand(this.distCommand);
            this.setTarget(this.distTarget);
            this.setOptions(this.distOptions);
            this.setSkipped(this.skipDist);
            this.getLog().info((CharSequence)("Creating source archive for '" + this.getProject().getId() + "'..."));
            super.execute();
            File sourceArchiveFile = new File(this.sourceArchivePath, this.sourceArchive);
            if (!sourceArchiveFile.exists()) {
                if (!this.skipDist) {
                    this.getLog().info((CharSequence)("'" + sourceArchiveFile.getAbsolutePath() + "' not found."));
                }
            } else {
                this.getLog().info((CharSequence)("'" + sourceArchiveFile.getAbsolutePath() + "' found."));
                this.projectHelper.attachArtifact(this.getProject(), "tar.gz", "sources", sourceArchiveFile);
            }
        }
        catch (MojoExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

