/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.extended.spreadsheet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Scm;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.mojo.license.download.ProjectLicense;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.extended.ExtendedInfo;
import org.codehaus.mojo.license.extended.InfoFile;
import org.codehaus.mojo.license.extended.spreadsheet.SpreadsheetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFileWriter {
    private static final BorderStyle HEADER_CELLS_BORDER_STYLE = BorderStyle.MEDIUM;
    private static final Logger LOG = LoggerFactory.getLogger(ExcelFileWriter.class);

    private ExcelFileWriter() {
    }

    public static void write(List<ProjectLicenseInfo> projectLicenseInfos, File licensesExcelOutputFile) {
        if (CollectionUtils.isEmpty(projectLicenseInfos)) {
            LOG.debug("Nothing to write to excel, no project data.");
            return;
        }
        LOG.debug("Write Microsoft Excel file {}", (Object)licensesExcelOutputFile);
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(WorkbookUtil.createSafeSheetName((String)"License information"));
        IndexedColorMap colorMap = wb.getStylesSource().getIndexedColors();
        XSSFColor alternatingRowsColor = new XSSFColor(new byte[]{(byte)SpreadsheetUtil.ALTERNATING_ROWS_COLOR[0], (byte)SpreadsheetUtil.ALTERNATING_ROWS_COLOR[1], (byte)SpreadsheetUtil.ALTERNATING_ROWS_COLOR[2]}, colorMap);
        ExcelFileWriter.createHeader(projectLicenseInfos, (Workbook)wb, (Sheet)sheet);
        ExcelFileWriter.writeData(projectLicenseInfos, wb, (Sheet)sheet, alternatingRowsColor);
        try (OutputStream fileOut = Files.newOutputStream(licensesExcelOutputFile.toPath(), new OpenOption[0]);){
            wb.write(fileOut);
            LOG.debug("Written Microsoft Excel file {}", (Object)licensesExcelOutputFile);
        }
        catch (IOException e) {
            LOG.error("Error on storing Microsoft Excel file with license and other information", (Throwable)e);
        }
    }

    private static void createHeader(List<ProjectLicenseInfo> projectLicenseInfos, Workbook wb, Sheet sheet) {
        boolean hasExtendedInfo = false;
        for (ProjectLicenseInfo projectLicenseInfo : projectLicenseInfos) {
            if (projectLicenseInfo.getExtendedInfo() == null) continue;
            hasExtendedInfo = true;
            break;
        }
        CellStyle headerCellStyle = wb.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        headerCellStyle.setFont(headerFont);
        headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
        ExcelFileWriter.setBorderStyle(headerCellStyle, HEADER_CELLS_BORDER_STYLE);
        Row mavenJarRow = sheet.createRow(0);
        ExcelFileWriter.createMergedCellsInRow(sheet, 0, 24, headerCellStyle, mavenJarRow, "Maven information", 0);
        if (hasExtendedInfo) {
            ExcelFileWriter.createMergedCellsInRow(sheet, 25, 40, headerCellStyle, mavenJarRow, "JAR Content", 0);
        }
        Row secondHeaderRow = sheet.createRow(1);
        ExcelFileWriter.createMergedCellsInRow(sheet, 0, 1, headerCellStyle, secondHeaderRow, "General", 1);
        ExcelFileWriter.createMergedCellsInRow(sheet, 2, 5, headerCellStyle, secondHeaderRow, "Plugin ID", 1);
        sheet.setColumnWidth(1, 768);
        ExcelFileWriter.createMergedCellsInRow(sheet, 6, 11, headerCellStyle, secondHeaderRow, "Licenses", 1);
        sheet.setColumnWidth(5, 768);
        ExcelFileWriter.createMergedCellsInRow(sheet, 12, 19, headerCellStyle, secondHeaderRow, "Developers", 1);
        sheet.setColumnWidth(11, 768);
        ExcelFileWriter.createMergedCellsInRow(sheet, 20, 24, headerCellStyle, secondHeaderRow, "Miscellaneous", 1);
        sheet.setColumnWidth(19, 768);
        if (hasExtendedInfo) {
            ExcelFileWriter.createMergedCellsInRow(sheet, 25, 28, headerCellStyle, secondHeaderRow, "MANIFEST.MF", 1);
            sheet.setColumnWidth(19, 768);
            ExcelFileWriter.createMergedCellsInRow(sheet, 29, 32, headerCellStyle, secondHeaderRow, "Notices text files", 1);
            sheet.setColumnWidth(28, 768);
            ExcelFileWriter.createMergedCellsInRow(sheet, 33, 36, headerCellStyle, secondHeaderRow, "License text files", 1);
            sheet.setColumnWidth(32, 768);
            ExcelFileWriter.createMergedCellsInRow(sheet, 37, 40, headerCellStyle, secondHeaderRow, "SPDX license id matched", 1);
            sheet.setColumnWidth(36, 768);
        }
        sheet.setColumnWidth(SpreadsheetUtil.getDownloadColumn(hasExtendedInfo) - 1, 768);
        Row thirdHeaderRow = sheet.createRow(2);
        ExcelFileWriter.createCellsInRow(thirdHeaderRow, 0, headerCellStyle, "Name");
        ExcelFileWriter.createCellsInRow(thirdHeaderRow, 2, headerCellStyle, "Group ID", "Artifact ID", "Version");
        ExcelFileWriter.createCellsInRow(thirdHeaderRow, 6, headerCellStyle, "Name", "URL", "Distribution", "Comments", "File");
        ExcelFileWriter.createCellsInRow(thirdHeaderRow, 12, headerCellStyle, "Id", "Email", "Name", "Organization", "Organization URL", "URL", "Timezone");
        ExcelFileWriter.createCellsInRow(thirdHeaderRow, 20, headerCellStyle, "Inception Year", "Organization", "SCM", "URL");
        int headerLineCount = 3;
        if (hasExtendedInfo) {
            ExcelFileWriter.createCellsInRow(thirdHeaderRow, 25, headerCellStyle, "Bundle license", "Bundle vendor", "Implementation vendor");
            ExcelFileWriter.createInfoFileCellsInRow(thirdHeaderRow, headerCellStyle, 29, 33, 37);
            sheet.createFreezePane(SpreadsheetUtil.getDownloadColumn(true) - 1, headerLineCount);
        } else {
            sheet.createFreezePane(SpreadsheetUtil.getDownloadColumn(false) - 1, headerLineCount);
        }
        sheet.createFreezePane(1, headerLineCount);
    }

    private static void writeData(List<ProjectLicenseInfo> projectLicenseInfos, XSSFWorkbook wb, Sheet sheet, XSSFColor alternatingRowsColor) {
        int firstRowIndex = 3;
        int currentRowIndex = 3;
        HashMap<Integer, Row> rowMap = new HashMap<Integer, Row>();
        boolean hasExtendedInfo = false;
        CellStyle hyperlinkStyleNormal = ExcelFileWriter.createHyperlinkStyle(wb, null);
        CellStyle hyperlinkStyleGray = ExcelFileWriter.createHyperlinkStyle(wb, alternatingRowsColor);
        boolean grayBackground = false;
        XSSFCellStyle styleGray = wb.createCellStyle();
        styleGray.setFillForegroundColor(alternatingRowsColor);
        styleGray.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (ProjectLicenseInfo projectInfo : projectLicenseInfos) {
            CellStyle hyperlinkStyle;
            XSSFCellStyle cellStyle;
            LOG.debug("Writing {}:{} into Microsoft Excel file", (Object)projectInfo.getGroupId(), (Object)projectInfo.getArtifactId());
            if (grayBackground) {
                cellStyle = styleGray;
                hyperlinkStyle = hyperlinkStyleGray;
            } else {
                cellStyle = null;
                hyperlinkStyle = hyperlinkStyleNormal;
            }
            grayBackground = !grayBackground;
            int extraRows = 0;
            Row currentRow = sheet.createRow(currentRowIndex);
            rowMap.put(currentRowIndex, currentRow);
            ExcelFileWriter.createDataCellsInRow(currentRow, 2, (CellStyle)cellStyle, projectInfo.getGroupId(), projectInfo.getArtifactId(), projectInfo.getVersion());
            CellListParameter cellListParameter = new CellListParameter(sheet, rowMap, (CellStyle)cellStyle);
            SpreadsheetUtil.CurrentRowData currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
            extraRows = ExcelFileWriter.addList(cellListParameter, currentRowData, 6, 5, projectInfo.getLicenses(), (arg_0, arg_1) -> ExcelFileWriter.lambda$writeData$0((CellStyle)cellStyle, wb, hyperlinkStyle, arg_0, arg_1));
            ExtendedInfo extendedInfo = projectInfo.getExtendedInfo();
            if (extendedInfo != null) {
                hasExtendedInfo = true;
                ExcelFileWriter.createDataCellsInRow(currentRow, 0, (CellStyle)cellStyle, extendedInfo.getName());
                currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                extraRows = ExcelFileWriter.addList(cellListParameter, currentRowData, 12, 7, extendedInfo.getDevelopers(), (arg_0, arg_1) -> ExcelFileWriter.lambda$writeData$1((CellStyle)cellStyle, wb, hyperlinkStyle, arg_0, arg_1));
                Cell[] miscCells = ExcelFileWriter.createDataCellsInRow(currentRow, 20, (CellStyle)cellStyle, extendedInfo.getInceptionYear(), Optional.ofNullable(extendedInfo.getOrganization()).map(Organization::getName).orElse(null), Optional.ofNullable(extendedInfo.getScm()).map(Scm::getUrl).orElse(null), extendedInfo.getUrl());
                ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, miscCells[2], hyperlinkStyle, HyperlinkType.URL);
                ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, miscCells[3], hyperlinkStyle, HyperlinkType.URL);
                ExcelFileWriter.createDataCellsInRow(currentRow, 25, (CellStyle)cellStyle, extendedInfo.getBundleLicense(), extendedInfo.getBundleVendor(), extendedInfo.getImplementationVendor());
                if (!CollectionUtils.isEmpty(extendedInfo.getInfoFiles())) {
                    ArrayList<InfoFile> notices = new ArrayList<InfoFile>();
                    ArrayList<InfoFile> licenses = new ArrayList<InfoFile>();
                    ArrayList<InfoFile> spdxs = new ArrayList<InfoFile>();
                    extendedInfo.getInfoFiles().forEach(infoFile -> {
                        switch (infoFile.getType()) {
                            case LICENSE: {
                                licenses.add((InfoFile)infoFile);
                                break;
                            }
                            case NOTICE: {
                                notices.add((InfoFile)infoFile);
                                break;
                            }
                            case SPDX_LICENSE: {
                                spdxs.add((InfoFile)infoFile);
                                break;
                            }
                        }
                    });
                    currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                    extraRows = ExcelFileWriter.addInfoFileList(cellListParameter, currentRowData, 29, 3, notices);
                    currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                    extraRows = ExcelFileWriter.addInfoFileList(cellListParameter, currentRowData, 33, 3, licenses);
                    currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                    extraRows = ExcelFileWriter.addInfoFileList(cellListParameter, currentRowData, 37, 3, spdxs);
                } else if (cellListParameter.cellStyle != null) {
                    ExcelFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, 29, 3);
                    ExcelFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, 33, 3);
                    ExcelFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, 37, 3);
                }
            }
            if (CollectionUtils.isNotEmpty(projectInfo.getDownloaderMessages())) {
                currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                int startColumn = hasExtendedInfo ? 41 : 25;
                extraRows = ExcelFileWriter.addList(cellListParameter, currentRowData, startColumn, 1, projectInfo.getDownloaderMessages(), (arg_0, arg_1) -> ExcelFileWriter.lambda$writeData$3(startColumn, (CellStyle)cellStyle, wb, hyperlinkStyle, arg_0, arg_1));
            }
            currentRowIndex += extraRows + 1;
        }
        ExcelFileWriter.autosizeColumns(sheet, hasExtendedInfo);
    }

    private static CellStyle createHyperlinkStyle(XSSFWorkbook wb, XSSFColor backgroundColor) {
        XSSFFont hyperlinkFont = wb.createFont();
        hyperlinkFont.setUnderline((byte)1);
        hyperlinkFont.setColor(IndexedColors.BLUE.getIndex());
        XSSFCellStyle hyperlinkStyle = wb.createCellStyle();
        if (backgroundColor != null) {
            hyperlinkStyle.setFillForegroundColor(backgroundColor);
            hyperlinkStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        hyperlinkStyle.setFont((Font)hyperlinkFont);
        return hyperlinkStyle;
    }

    private static void autosizeColumns(Sheet sheet, boolean hasExtendedInfo) {
        ExcelFileWriter.autosizeColumns(sheet, new Pair[]{new ImmutablePair((Object)0, (Object)1), new ImmutablePair((Object)2, (Object)5), new ImmutablePair((Object)6, (Object)11), new ImmutablePair((Object)12, (Object)18), new ImmutablePair((Object)21, (Object)24)});
        sheet.setColumnWidth(18, SpreadsheetUtil.TIMEZONE_WIDTH);
        sheet.setColumnWidth(20, SpreadsheetUtil.INCEPTION_YEAR_WIDTH);
        if (hasExtendedInfo) {
            ExcelFileWriter.autosizeColumns(sheet, new Pair[]{new ImmutablePair((Object)25, (Object)28), new ImmutablePair((Object)31, (Object)32), new ImmutablePair((Object)35, (Object)36), new ImmutablePair((Object)39, (Object)40)});
        }
        ExcelFileWriter.autosizeColumns(sheet, new Pair[]{new ImmutablePair((Object)SpreadsheetUtil.getDownloadColumn(hasExtendedInfo), (Object)(SpreadsheetUtil.getDownloadColumn(hasExtendedInfo) + 1))});
    }

    @SafeVarargs
    private static void autosizeColumns(Sheet sheet, Pair<Integer, Integer> ... ranges) {
        for (Pair<Integer, Integer> range : ranges) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    private static int addInfoFileList(CellListParameter cellListParameter, SpreadsheetUtil.CurrentRowData currentRowData, int startColumn, int columnsToFill, List<InfoFile> infoFiles) {
        return ExcelFileWriter.addList(cellListParameter, currentRowData, startColumn, columnsToFill, infoFiles, (infoFileRow, infoFile) -> {
            String copyrightLines = Optional.ofNullable(infoFile.getExtractedCopyrightLines()).map(strings -> String.join((CharSequence)"\u00a7", strings)).orElse(null);
            ExcelFileWriter.createDataCellsInRow(infoFileRow, startColumn, cellListParameter.getCellStyle(), infoFile.getContent(), copyrightLines, infoFile.getFileName());
        });
    }

    private static <T> int addList(CellListParameter cellListParameter, SpreadsheetUtil.CurrentRowData currentRowData, int startColumn, int columnsToFill, List<T> list, BiConsumer<Row, T> biConsumer) {
        if (!CollectionUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                T type = list.get(i);
                Integer index = currentRowData.getCurrentRowIndex() + i;
                Row row = cellListParameter.getRows().get(index);
                if (row == null) {
                    row = cellListParameter.getSheet().createRow(index.intValue());
                    cellListParameter.getRows().put(index, row);
                    if (cellListParameter.getCellStyle() != null) {
                        ExcelFileWriter.createAndStyleCells(row, cellListParameter.getCellStyle(), new Pair[]{new ImmutablePair((Object)0, (Object)1), new ImmutablePair((Object)2, (Object)5), new ImmutablePair((Object)6, (Object)11)});
                        if (currentRowData.isHasExtendedInfo()) {
                            ExcelFileWriter.createAndStyleCells(row, cellListParameter.getCellStyle(), new Pair[]{new ImmutablePair((Object)12, (Object)19), new ImmutablePair((Object)20, (Object)24), new ImmutablePair((Object)25, (Object)28), new ImmutablePair((Object)33, (Object)36), new ImmutablePair((Object)29, (Object)32), new ImmutablePair((Object)37, (Object)40)});
                        }
                    }
                    currentRowData.setExtraRows(currentRowData.getExtraRows() + 1);
                }
                biConsumer.accept(row, (Row)type);
            }
        } else if (cellListParameter.cellStyle != null) {
            ExcelFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, startColumn, columnsToFill);
        }
        return currentRowData.getExtraRows();
    }

    private static void setStyleOnEmptyCells(CellListParameter cellListParameter, SpreadsheetUtil.CurrentRowData currentRowData, int startColumn, int columnsToFill) {
        Row row = cellListParameter.getRows().get(currentRowData.getCurrentRowIndex());
        for (int i = 0; i < columnsToFill; ++i) {
            Cell cell = row.createCell(startColumn + i, CellType.STRING);
            cell.setCellStyle(cellListParameter.getCellStyle());
        }
    }

    @SafeVarargs
    private static void createAndStyleCells(Row row, CellStyle cellStyle, Pair<Integer, Integer> ... ranges) {
        for (Pair<Integer, Integer> range : ranges) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                Cell cell = row.createCell(i, CellType.STRING);
                cell.setCellStyle(cellStyle);
            }
        }
    }

    private static void addHyperlinkIfExists(Workbook workbook, Cell cell, CellStyle hyperlinkStyle, HyperlinkType hyperlinkType) {
        String link = cell.getStringCellValue();
        if (!StringUtils.isEmpty((CharSequence)link)) {
            Hyperlink hyperlink = workbook.getCreationHelper().createHyperlink(hyperlinkType);
            String modifiedLink = ExcelFileWriter.prefixedHyperlink(hyperlinkType, link);
            try {
                hyperlink.setAddress(modifiedLink);
                cell.setHyperlink(hyperlink);
                cell.setCellStyle(hyperlinkStyle);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Can't set Hyperlink for cell value " + link + " (" + modifiedLink + ") it gets rejected as URI", (Throwable)e);
            }
        }
    }

    private static String prefixedHyperlink(HyperlinkType hyperlinkType, String link) {
        link = link.trim().replace(" dot ", ".");
        String modifiedLink = hyperlinkType == HyperlinkType.EMAIL ? ((link = link.replace(" at ", "@")).contains("@") && link.matches(".*\\s[a-zA-Z]{2,3}$") ? link.replace(" ", ".") : link) : (!link.startsWith("http://") && !link.startsWith("https://") ? "https://" + link : link);
        return modifiedLink;
    }

    private static Cell[] createDataCellsInRow(Row row, int startColumn, CellStyle cellStyle, String ... names) {
        Cell[] result = new Cell[names.length];
        for (int i = 0; i < names.length; ++i) {
            Cell cell = row.createCell(startColumn + i, CellType.STRING);
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            if (!StringUtils.isEmpty((CharSequence)names[i])) {
                int maxCellStringLength = Short.MAX_VALUE;
                String value = names[i].length() > Short.MAX_VALUE ? names[i].substring(0, 32764) + "..." : names[i];
                cell.setCellValue(value);
            }
            result[i] = cell;
        }
        return result;
    }

    private static void createInfoFileCellsInRow(Row row, CellStyle cellStyle, int ... startPositions) {
        for (int startPosition : startPositions) {
            ExcelFileWriter.createCellsInRow(row, startPosition, cellStyle, "Content", "Extracted copyright lines", "File");
        }
    }

    private static void createCellsInRow(Row row, int startColumn, CellStyle cellStyle, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            Cell cell = row.createCell(startColumn + i, CellType.STRING);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(names[i]);
        }
    }

    private static void createMergedCellsInRow(Sheet sheet, int startColumn, int endColumn, CellStyle cellStyle, Row row, String cellValue, int rowIndex) {
        Cell cell = ExcelFileWriter.createCellsInRow(startColumn, endColumn, row);
        if (cell == null) {
            return;
        }
        boolean merge = endColumn - 1 > startColumn;
        CellRangeAddress mergeAddress = null;
        if (merge) {
            mergeAddress = new CellRangeAddress(rowIndex, rowIndex, startColumn, endColumn - 1);
            sheet.addMergedRegion(mergeAddress);
        }
        cell.setCellValue(cellValue);
        cell.setCellStyle(cellStyle);
        if (merge) {
            ExcelFileWriter.setBorderAroundRegion(sheet, mergeAddress, HEADER_CELLS_BORDER_STYLE);
            sheet.groupColumn(startColumn, endColumn - 1);
        }
    }

    private static void setBorderAroundRegion(Sheet sheet, CellRangeAddress licensesHeaderAddress, BorderStyle borderStyle) {
        RegionUtil.setBorderLeft((BorderStyle)borderStyle, (CellRangeAddress)licensesHeaderAddress, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)borderStyle, (CellRangeAddress)licensesHeaderAddress, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)borderStyle, (CellRangeAddress)licensesHeaderAddress, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)borderStyle, (CellRangeAddress)licensesHeaderAddress, (Sheet)sheet);
    }

    private static Cell createCellsInRow(int startColumn, int exclusiveEndColumn, Row inRow) {
        Cell firstCell = null;
        for (int i = startColumn; i < exclusiveEndColumn; ++i) {
            Cell cell = inRow.createCell(i);
            if (i != startColumn) continue;
            firstCell = cell;
        }
        return firstCell;
    }

    private static void setBorderStyle(CellStyle cellStyle, BorderStyle borderStyle) {
        cellStyle.setBorderLeft(borderStyle);
        cellStyle.setBorderTop(borderStyle);
        cellStyle.setBorderRight(borderStyle);
        cellStyle.setBorderBottom(borderStyle);
    }

    private static /* synthetic */ void lambda$writeData$3(int startColumn, CellStyle cellStyle, XSSFWorkbook wb, CellStyle hyperlinkStyle, Row licenseRow, String message) {
        Cell[] licenses = ExcelFileWriter.createDataCellsInRow(licenseRow, startColumn, cellStyle, message);
        if (message.matches("\\bhttps?://\\S+")) {
            ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, licenses[0], hyperlinkStyle, HyperlinkType.URL);
        }
    }

    private static /* synthetic */ void lambda$writeData$1(CellStyle cellStyle, XSSFWorkbook wb, CellStyle hyperlinkStyle, Row developerRow, Developer developer) {
        Cell[] licenses = ExcelFileWriter.createDataCellsInRow(developerRow, 12, cellStyle, developer.getId(), developer.getEmail(), developer.getName(), developer.getOrganization(), developer.getOrganizationUrl(), developer.getUrl(), developer.getTimezone());
        ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, licenses[1], hyperlinkStyle, HyperlinkType.EMAIL);
        ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, licenses[4], hyperlinkStyle, HyperlinkType.URL);
        ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, licenses[5], hyperlinkStyle, HyperlinkType.URL);
    }

    private static /* synthetic */ void lambda$writeData$0(CellStyle cellStyle, XSSFWorkbook wb, CellStyle hyperlinkStyle, Row licenseRow, ProjectLicense license) {
        Cell[] licenses = ExcelFileWriter.createDataCellsInRow(licenseRow, 6, cellStyle, license.getName(), license.getUrl(), license.getDistribution(), license.getComments(), license.getFile());
        ExcelFileWriter.addHyperlinkIfExists((Workbook)wb, licenses[1], hyperlinkStyle, HyperlinkType.URL);
    }

    private static class CellListParameter {
        private final Sheet sheet;
        private final Map<Integer, Row> rows;
        private final CellStyle cellStyle;

        private CellListParameter(Sheet sheet, Map<Integer, Row> rows, CellStyle cellStyle) {
            this.sheet = sheet;
            this.rows = rows;
            this.cellStyle = cellStyle;
        }

        Sheet getSheet() {
            return this.sheet;
        }

        Map<Integer, Row> getRows() {
            return this.rows;
        }

        CellStyle getCellStyle() {
            return this.cellStyle;
        }
    }
}

