/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.LicenseMojoUtils;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.codehaus.mojo.license.utils.StringToList;
import org.codehaus.mojo.license.utils.UrlRequester;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAddThirdPartyMojo
extends AbstractLicenseMojo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAddThirdPartyMojo.class);
    @Parameter(property="license.outputDirectory", defaultValue="${project.build.directory}/generated-sources/license", required=true)
    protected File outputDirectory;
    @Parameter(property="license.deployMissingFile", defaultValue="true")
    protected boolean deployMissingFile;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    protected boolean useRepositoryMissingFiles;
    @Parameter(property="license.acceptPomPackaging", defaultValue="false")
    protected boolean acceptPomPackaging;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    protected String excludedScopes;
    @Parameter(property="license.includedScopes")
    protected String includedScopes;
    @Parameter(property="license.excludedTypes")
    protected String excludedTypes;
    @Parameter(property="license.includedTypes")
    protected String includedTypes;
    @Parameter(property="license.excludedGroups")
    protected String excludedGroups;
    @Parameter(property="license.includedGroups")
    protected String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    protected String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    protected String includedArtifacts;
    @Parameter(property="license.includeTransitiveDependencies", defaultValue="true")
    boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    boolean excludeTransitiveDependencies;
    @Parameter(property="license.includeOptional", defaultValue="true")
    boolean includeOptional;
    @Parameter(property="license.thirdPartyFilename", defaultValue="THIRD-PARTY.txt", required=true)
    protected String thirdPartyFilename;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    protected boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    protected File missingFile;
    @Parameter(property="license.missingFileUrl")
    protected String missingFileUrl;
    @Parameter(property="license.missingLicensesFileArtifact")
    protected String missingLicensesFileArtifact;
    @Deprecated
    @Parameter(property="license.overrideFile")
    private File overrideFile;
    @Parameter(property="license.overrideUrl")
    private String overrideUrl;
    protected String resolvedOverrideUrl;
    @Parameter
    protected List<String> licenseMerges;
    @Deprecated
    @Parameter(property="license.licenseMergesFile")
    protected String licenseMergesFile;
    @Parameter(property="license.licenseMergesUrl")
    protected String licenseMergesUrl;
    @Parameter(property="license.includedLicenses")
    protected IncludedLicenses includedLicenses;
    @Parameter(property="license.excludedLicenses")
    protected ExcludedLicenses excludedLicenses;
    @Parameter(property="license.bundleThirdPartyPath", defaultValue="META-INF/${project.artifactId}-THIRD-PARTY.txt")
    protected String bundleThirdPartyPath;
    @Parameter(property="license.generateBundle", defaultValue="false")
    protected boolean generateBundle;
    @Parameter(property="license.force", defaultValue="false")
    protected boolean force;
    @Deprecated
    @Parameter(property="license.failIfWarning", defaultValue="false")
    protected boolean failIfWarning;
    @Parameter(property="license.failOnMissing", defaultValue="false")
    protected boolean failOnMissing;
    @Parameter(property="license.failOnBlacklist", defaultValue="false")
    protected boolean failOnBlacklist;
    @Parameter(property="license.sortArtifactByName", defaultValue="false")
    protected boolean sortArtifactByName;
    @Parameter(property="license.fileTemplate", defaultValue="/org/codehaus/mojo/license/third-party-file.ftl")
    protected String fileTemplate;
    @Parameter(property="project.artifacts", required=true, readonly=true)
    protected Set<Artifact> dependencies;
    @Component
    private ThirdPartyTool thirdPartyTool;
    @Component
    protected DependenciesTool dependenciesTool;
    private ThirdPartyHelper helper;
    protected SortedMap<String, MavenProject> projectDependencies;
    protected LicenseMap licenseMap;
    protected SortedSet<MavenProject> unsafeDependencies;
    private File thirdPartyFile;
    protected SortedProperties unsafeMappings;
    protected boolean doGenerate;
    protected boolean doGenerateBundle;
    private Map<String, String> globalKnownLicenses;
    @Parameter(property="license.artifactFiltersUrl")
    protected String artifactFiltersUrl;

    protected abstract SortedMap<String, MavenProject> loadDependencies() throws DependenciesToolException;

    protected abstract SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException, MojoExecutionException, DependenciesToolException;

    @Override
    protected void init() throws Exception {
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.thirdPartyFile = new File(this.outputDirectory, this.thirdPartyFilename);
        File projectFile = this.project.getFile() != null ? this.project.getFile() : new File("");
        LOG.debug("project file: {} last modified: {}", (Object)projectFile, (Object)projectFile.lastModified());
        LOG.debug("third-party file: {} last modified: {}", (Object)this.thirdPartyFile, (Object)this.thirdPartyFile.lastModified());
        boolean bl = this.doGenerate = this.force || !this.thirdPartyFile.exists() || projectFile.lastModified() > this.thirdPartyFile.lastModified();
        if (this.generateBundle) {
            File bundleFile = new File(this.outputDirectory, this.bundleThirdPartyPath);
            LOG.debug("bundle third-party file: {} last modified: {}", (Object)bundleFile, (Object)bundleFile.lastModified());
            this.doGenerateBundle = this.force || !bundleFile.exists() || projectFile.lastModified() > bundleFile.lastModified();
        } else {
            this.doGenerateBundle = false;
        }
        if (this.shouldSkip()) {
            return;
        }
        this.projectDependencies = this.loadDependencies();
        this.licenseMap = this.getHelper().createLicenseMap(this.projectDependencies);
        if (this.licenseMergesFile != null) {
            if (this.licenseMergesUrl != null) {
                throw new MojoExecutionException("You can't use both licenseMergesFile and licenseMergesUrl");
            }
            LOG.warn("");
            LOG.warn("!!! licenseMergesFile is deprecated, use now licenseMergesUrl !!!");
            LOG.warn("");
            LOG.warn("licenseMerges will be overridden by licenseMergesFile.");
            LOG.warn("");
            this.licenseMerges = FileUtils.readLines((File)new File(this.licenseMergesFile), (String)"utf-8");
        } else if (this.licenseMergesUrl != null) {
            if (this.licenseMerges != null) {
                LOG.warn("");
                LOG.warn("licenseMerges will be overridden by licenseMergesUrl.");
                LOG.warn("");
            }
            if (UrlRequester.isStringUrl(this.licenseMergesUrl)) {
                this.licenseMerges = Arrays.asList(UrlRequester.getFromUrl(this.licenseMergesUrl).split("[\n\r]+"));
            }
        }
        this.resolvedOverrideUrl = LicenseMojoUtils.prepareThirdPartyOverrideUrl(this.resolvedOverrideUrl, this.overrideFile, this.overrideUrl, this.project.getBasedir());
    }

    void consolidate() throws IOException, ArtifactNotFoundException, ArtifactResolutionException, MojoFailureException, ProjectBuildingException, ThirdPartyToolException, MojoExecutionException, DependenciesToolException {
        this.unsafeDependencies = this.getHelper().getProjectsWithNoLicense(this.licenseMap);
        if (!CollectionUtils.isEmpty(this.unsafeDependencies) && this.useMissingFile && this.doGenerate) {
            this.unsafeMappings = this.createUnsafeMapping();
        }
        this.getHelper().mergeLicenses(this.licenseMerges, this.licenseMap);
        if (CollectionUtils.isNotEmpty(this.unsafeDependencies)) {
            this.resolveUnsafeDependenciesFromFile(this.missingFile);
        }
        if (!StringUtils.isBlank((CharSequence)this.missingLicensesFileArtifact) && CollectionUtils.isNotEmpty(this.unsafeDependencies)) {
            String[] tokens = StringUtils.split((String)this.missingLicensesFileArtifact, (String)":");
            if (tokens.length != 3) {
                throw new MojoFailureException("Invalid missing licenses artifact, you must specify groupId:artifactId:version " + this.missingLicensesFileArtifact);
            }
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            this.resolveUnsafeDependenciesFromArtifact(groupId, artifactId, version);
        }
        this.overrideLicenses();
    }

    private List<String> getExcludedLicenses() {
        return this.excludedLicenses.getData();
    }

    private List<String> getIncludedLicenses() {
        return this.includedLicenses.getData();
    }

    public void setIncludedLicenses(String includedLicenses) throws MojoExecutionException {
        this.includedLicenses = new IncludedLicenses(includedLicenses);
    }

    public void setExcludedLicenses(String excludedLicenses) throws MojoExecutionException {
        this.excludedLicenses = new ExcludedLicenses(excludedLicenses);
    }

    protected ThirdPartyHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DefaultThirdPartyHelper(this.getProject(), this.getEncoding(), this.isVerbose(), this.dependenciesTool, this.thirdPartyTool, this.getProject().getRemoteArtifactRepositories(), this.getProject().getRemoteProjectRepositories());
        }
        return this.helper;
    }

    void resolveUnsafeDependenciesFromArtifact(String groupId, String artifactId, String version) throws ArtifactNotFoundException, IOException, ArtifactResolutionException, MojoExecutionException {
        File missingLicensesFromArtifact = this.thirdPartyTool.resolveMissingLicensesDescriptor(groupId, artifactId, version, this.getProject().getRemoteProjectRepositories());
        this.resolveUnsafeDependenciesFromFile(missingLicensesFromArtifact);
    }

    void resolveUnsafeDependenciesFromFile(File missingLicenses) throws IOException, MojoExecutionException {
        if (missingLicenses == null) {
            return;
        }
        SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
        if (missingLicenses.exists() && missingLicenses.length() > 0L) {
            unsafeMappings.load(missingLicenses);
        }
        if (this.useMissingFile && UrlRequester.isStringUrl(this.missingFileUrl)) {
            String httpRequestResult = UrlRequester.getFromUrl(this.missingFileUrl);
            unsafeMappings.load(new ByteArrayInputStream(httpRequestResult.getBytes()));
        }
        if (!unsafeMappings.isEmpty()) {
            HashSet<MavenProject> resolvedDependencies = new HashSet<MavenProject>();
            for (MavenProject unsafeDependency : this.unsafeDependencies) {
                String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
                if (!unsafeMappings.containsKey(id) || !StringUtils.isNotBlank((CharSequence)unsafeMappings.getProperty(id))) continue;
                this.thirdPartyTool.addLicense(this.licenseMap, unsafeDependency, unsafeMappings.getProperty(id));
                resolvedDependencies.add(unsafeDependency);
            }
            this.unsafeDependencies.removeAll(resolvedDependencies);
        }
    }

    void checkUnsafeDependencies() {
        if (CollectionUtils.isNotEmpty(this.unsafeDependencies) && LOG.isWarnEnabled()) {
            boolean plural = this.unsafeDependencies.size() > 1;
            String message = String.format("There %s %d %s with no license :", plural ? "are" : "is", this.unsafeDependencies.size(), plural ? "dependencies" : "dependency");
            LOG.warn(message);
            for (MavenProject dep : this.unsafeDependencies) {
                LOG.warn(" - {}", (Object)MojoHelper.getArtifactId(dep.getArtifact()));
            }
        }
    }

    boolean checkForbiddenLicenses() {
        boolean safe;
        List<String> whiteLicenses = this.getIncludedLicenses();
        List<String> blackLicenses = this.getExcludedLicenses();
        HashSet<String> unsafeLicenses = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(blackLicenses)) {
            Set licenses = this.licenseMap.keySet();
            LOG.info("Excluded licenses (blacklist): {}", blackLicenses);
            for (String excludeLicense : blackLicenses) {
                if (!licenses.contains(excludeLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.licenseMap.get(excludeLicense)))) continue;
                unsafeLicenses.add(excludeLicense);
            }
        }
        if (CollectionUtils.isNotEmpty(whiteLicenses)) {
            Set dependencyLicenses = this.licenseMap.keySet();
            LOG.info("Included licenses (whitelist): {}", whiteLicenses);
            block1: for (String dependencyLicense : dependencyLicenses) {
                LOG.debug("Testing license '{}'", (Object)dependencyLicense);
                if (whiteLicenses.contains(dependencyLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.licenseMap.get(dependencyLicense)))) continue;
                LOG.debug("Testing dependency license '{}' against all other licenses", (Object)dependencyLicense);
                for (MavenProject dependency : (SortedSet)this.licenseMap.get(dependencyLicense)) {
                    LOG.debug("- testing dependency {}" + dependency);
                    boolean forbiddenLicenseUsed = true;
                    for (String otherLicense : dependencyLicenses) {
                        if (otherLicense.equals(dependencyLicense) || ((SortedSet)this.licenseMap.get(dependencyLicense)).isEmpty() || !whiteLicenses.contains(otherLicense) || !((SortedSet)this.licenseMap.get(otherLicense)).contains(dependency)) continue;
                        LOG.info("License: '{}' for '{}' is OK since it is also licensed under '{}'", new Object[]{dependencyLicense, dependency, otherLicense});
                        forbiddenLicenseUsed = false;
                        break;
                    }
                    if (!forbiddenLicenseUsed) continue;
                    unsafeLicenses.add(dependencyLicense);
                    continue block1;
                }
            }
        }
        if (!(safe = CollectionUtils.isEmpty(unsafeLicenses))) {
            LOG.warn("There are {} forbidden licenses used:", (Object)unsafeLicenses.size());
            for (String unsafeLicense : unsafeLicenses) {
                SortedSet deps = (SortedSet)this.licenseMap.get(unsafeLicense);
                if (deps.isEmpty()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("License: '").append(unsafeLicense).append("' used by ").append(deps.size()).append(" dependencies:");
                for (MavenProject dep : deps) {
                    sb.append("\n -").append(MojoHelper.getArtifactName(dep));
                }
                LOG.warn("{}", (Object)sb);
            }
        }
        return safe;
    }

    void writeThirdPartyFile() throws IOException {
        if (this.doGenerate) {
            LicenseMap licenseMap1 = this.licenseMap;
            if (this.sortArtifactByName) {
                licenseMap1 = this.licenseMap.toLicenseMapOrderByName();
            }
            this.thirdPartyTool.writeThirdPartyFile(licenseMap1, this.thirdPartyFile, this.isVerbose(), this.getEncoding(), this.fileTemplate);
        }
        if (this.doGenerateBundle) {
            this.thirdPartyTool.writeBundleThirdPartyFile(this.thirdPartyFile, this.outputDirectory, this.bundleThirdPartyPath);
        }
    }

    void overrideLicenses() throws IOException {
        this.thirdPartyTool.overrideLicenses(this.licenseMap, this.projectDependencies, this.getEncoding(), this.resolvedOverrideUrl);
    }

    private boolean isFailOnMissing() {
        return this.failOnMissing;
    }

    private boolean isFailOnBlacklist() {
        return this.failOnBlacklist;
    }

    void checkMissing(boolean unsafe) throws MojoFailureException {
        if (unsafe && (this.isFailOnMissing() || this.failIfWarning)) {
            throw new MojoFailureException("There are some dependencies with no license, please fill the file " + this.missingFile);
        }
    }

    void checkBlacklist(boolean safeLicense) throws MojoFailureException {
        if (!safeLicense && (this.isFailOnBlacklist() || this.failIfWarning)) {
            throw new MojoFailureException("There are some forbidden licenses used, please check your dependencies.");
        }
    }

    public static class ExcludedLicenses
    extends StringToList {
        public ExcludedLicenses() {
        }

        ExcludedLicenses(String data) throws MojoExecutionException {
            super(data);
        }

        public void setExcludedLicense(String excludeLicense) {
            this.addEntryToList(excludeLicense);
        }
    }

    public static class IncludedLicenses
    extends StringToList {
        public IncludedLicenses() {
        }

        IncludedLicenses(String data) throws MojoExecutionException {
            super(data);
        }

        public void setIncludedLicense(String includeLicense) {
            this.addEntryToList(includeLicense);
        }
    }
}

