/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.mojo.license.AbstractLicensesXmlMojo;
import org.codehaus.mojo.license.LicenseContentSanitizer;
import org.codehaus.mojo.license.LicenseUrlReplacement;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.download.Cache;
import org.codehaus.mojo.license.download.FileNameEntry;
import org.codehaus.mojo.license.download.License;
import org.codehaus.mojo.license.download.LicenseDownloader;
import org.codehaus.mojo.license.download.LicenseMatchers;
import org.codehaus.mojo.license.download.LicenseSummaryReader;
import org.codehaus.mojo.license.download.LicensedArtifact;
import org.codehaus.mojo.license.download.PreferredFileNames;
import org.codehaus.mojo.license.download.ProjectLicense;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.download.UrlReplacements;
import org.codehaus.mojo.license.spdx.SpdxLicenseList;
import org.codehaus.mojo.license.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDownloadLicensesMojo
extends AbstractLicensesXmlMojo
implements MavenProjectDependenciesConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDownloadLicensesMojo.class);
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(property="licensesConfigFile", defaultValue="${project.basedir}/src/license/licenses.xml")
    protected File licensesConfigFile;
    @Parameter(property="licensesOutputDirectory", defaultValue="${project.build.directory}/generated-resources/licenses")
    protected File licensesOutputDirectory;
    @Parameter(property="license.cleanLicensesOutputDirectory", defaultValue="false")
    private boolean cleanLicensesOutputDirectory;
    @Parameter(property="license.removeOrphanLicenseFiles", defaultValue="true")
    private boolean removeOrphanLicenseFiles;
    @Parameter(property="license.licensesErrorsFile", defaultValue="${project.build.directory}/generated-resources/licenses-errors.xml")
    private File licensesErrorsFile;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes")
    private String includedScopes;
    @Parameter(property="license.excludedTypes")
    private String excludedTypes;
    @Parameter(property="license.includedTypes")
    private String includedTypes;
    @Parameter(property="license.artifactFiltersUrl")
    private String artifactFiltersUrl;
    @Parameter(defaultValue="${settings.offline}")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(property="license.errorRemedy", defaultValue="warn")
    protected ErrorRemedy errorRemedy;
    @Parameter(property="license.forceDownload", defaultValue="false")
    private boolean forceDownload;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    private boolean excludeTransitiveDependencies;
    @Parameter(property="license.includeOptional", defaultValue="true")
    boolean includeOptional;
    @Parameter(defaultValue="${settings.proxies}", readonly=true)
    private List<Proxy> proxies;
    @Parameter(property="license.organizeLicensesByDependencies", defaultValue="false")
    protected boolean organizeLicensesByDependencies;
    @Parameter(property="license.sortByGroupIdAndArtifactId", defaultValue="false")
    private boolean sortByGroupIdAndArtifactId;
    @Parameter(property="license.excludedGroups")
    private String excludedGroups;
    @Parameter(property="license.includedGroups")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    private String includedArtifacts;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    protected List<LicenseUrlReplacement> licenseUrlReplacements;
    @Parameter(property="license.useDefaultUrlReplacements", defaultValue="false")
    protected boolean useDefaultUrlReplacements;
    @Parameter
    protected Map<String, String> licenseUrlFileNames;
    @Parameter
    protected List<LicenseUrlReplacement> licenseUrlFileNameSanitizers;
    @Parameter(property="license.writeVersions", defaultValue="true")
    private boolean writeVersions;
    @Parameter(property="license.connectTimeout", defaultValue="5000")
    private int connectTimeout;
    @Parameter(property="license.socketTimeout", defaultValue="5000")
    private int socketTimeout;
    @Parameter(property="license.connectionRequestTimeout", defaultValue="5000")
    private int connectionRequestTimeout;
    @Parameter(property="license.licenseContentSanitizers")
    private List<LicenseContentSanitizer> licenseContentSanitizers;
    @Parameter(property="license.useDefaultContentSanitizers", defaultValue="false")
    private boolean useDefaultContentSanitizers;
    private PreferredFileNames preferredFileNames;
    private Cache cache;
    private int downloadErrorCount = 0;
    private ArtifactFilters artifactFilters;
    private final Set<String> orphanFileNames = new HashSet<String>();
    private UrlReplacements urlReplacements;

    protected abstract boolean isSkip();

    protected MavenProject getProject() {
        return this.project;
    }

    protected abstract Map<String, LicensedArtifact> getDependencies();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            LOG.info("skip flag is on, will skip goal.");
            return;
        }
        this.errorRemedy = AbstractDownloadLicensesMojo.getEffectiveErrorRemedy(this.quiet, this.errorRemedy);
        this.preferredFileNames = PreferredFileNames.build(this.licensesOutputDirectory, this.licenseUrlFileNames);
        this.cache = new Cache(this.licenseUrlFileNames != null && !this.licenseUrlFileNames.isEmpty());
        this.urlReplacements = this.urlReplacements();
        this.initDirectories();
        LicenseMatchers matchers = LicenseMatchers.load(this.licensesConfigFile);
        if (!this.forceDownload) {
            try {
                List<ProjectLicenseInfo> projectLicenseInfos = LicenseSummaryReader.parseLicenseSummary(this.licensesOutputFile);
                for (ProjectLicenseInfo dep : projectLicenseInfos) {
                    for (ProjectLicense lic : dep.getLicenses()) {
                        File file;
                        String fileName = lic.getFile();
                        if (fileName == null) continue;
                        this.orphanFileNames.add(fileName);
                        String url = lic.getUrl();
                        if (url == null || !(file = new File(this.licensesOutputDirectory, fileName)).exists()) continue;
                        LicenseDownloader.LicenseDownloadResult entry = LicenseDownloader.LicenseDownloadResult.success(file, FileUtil.sha1(file.toPath()), false);
                        this.cache.put(url, entry);
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to process license summary file: " + this.licensesOutputFile, e);
            }
        }
        Map<String, LicensedArtifact> dependencies = this.getDependencies();
        ArrayList<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
        try (LicenseDownloader licenseDownloader = new LicenseDownloader(this.findActiveProxy(), this.connectTimeout, this.socketTimeout, this.connectionRequestTimeout, this.contentSanitizers(), this.getCharset());){
            for (LicensedArtifact artifact : dependencies.values()) {
                LOG.debug("Checking licenses for project " + artifact);
                ProjectLicenseInfo depProject = this.createDependencyProject(artifact);
                matchers.replaceMatches(depProject);
                ArrayList<String> msgs = new ArrayList<String>(depProject.getDownloaderMessages());
                depProject.getDownloaderMessages().clear();
                for (String msg : msgs) {
                    this.handleError(depProject, msg);
                }
                depProjectLicenses.add(depProject);
            }
            if (!this.offline) {
                for (ProjectLicenseInfo depProject : depProjectLicenses) {
                    this.downloadLicenses(licenseDownloader, depProject, true);
                }
                LOG.debug("Finished populating cache");
                for (ProjectLicenseInfo depProject : depProjectLicenses) {
                    this.downloadLicenses(licenseDownloader, depProject, false);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.sortByGroupIdAndArtifactId) {
                this.sortByGroupIdAndArtifactId(depProjectLicenses);
            }
            List<ProjectLicenseInfo> depProjectLicensesWithErrors = this.filterErrors(depProjectLicenses);
            this.writeLicenseSummary(depProjectLicenses, this.licensesOutputFile, this.writeVersions);
            if (depProjectLicensesWithErrors != null && !depProjectLicensesWithErrors.isEmpty()) {
                this.writeLicenseSummary(depProjectLicensesWithErrors, this.licensesErrorsFile, this.writeVersions);
            }
            this.removeOrphanFiles(depProjectLicenses);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
        }
        switch (this.errorRemedy) {
            case ignore: 
            case failFast: {
                break;
            }
            case warn: {
                LOG.warn("There were {} download errors - check the warnings above", (Object)this.downloadErrorCount);
                break;
            }
            case xmlOutput: {
                if (this.downloadErrorCount <= 0) break;
                throw new MojoFailureException("There were " + this.downloadErrorCount + " download errors - check " + this.licensesErrorsFile.getAbsolutePath());
            }
            default: {
                throw new IllegalStateException("Unexpected value of " + ErrorRemedy.class.getName() + ": " + (Object)((Object)this.errorRemedy));
            }
        }
    }

    private UrlReplacements urlReplacements() {
        UrlReplacements.Builder b = UrlReplacements.builder().useDefaults(this.useDefaultUrlReplacements);
        if (this.licenseUrlReplacements != null) {
            for (LicenseUrlReplacement r : this.licenseUrlReplacements) {
                b.replacement(r.getId(), r.getRegexp(), r.getReplacement());
            }
        }
        return b.build();
    }

    private Map<String, SpdxLicenseList.Attachments.ContentSanitizer> contentSanitizers() {
        TreeMap<String, SpdxLicenseList.Attachments.ContentSanitizer> result = new TreeMap<String, SpdxLicenseList.Attachments.ContentSanitizer>();
        if (this.useDefaultContentSanitizers) {
            Map<String, SpdxLicenseList.Attachments.ContentSanitizer> defaultSanitizers = SpdxLicenseList.getLatest().getAttachments().getContentSanitizers();
            result.putAll(defaultSanitizers);
            if (LOG.isDebugEnabled() && !defaultSanitizers.isEmpty()) {
                StringBuilder sb = new StringBuilder().append("Applied ").append(defaultSanitizers.size()).append(" licenseContentSanitizers:\n<licenseContentSanitizers>\n");
                for (SpdxLicenseList.Attachments.ContentSanitizer sanitizer : defaultSanitizers.values()) {
                    sb.append("  <licenseContentSanitizer>\n").append("    <id>").append(sanitizer.getId()).append("</id>\n").append("    <urlRegexp>").append(StringEscapeUtils.escapeJava((String)sanitizer.getUrlPattern().pattern())).append("</urlRegexp>\n").append("    <contentRegexp>").append(StringEscapeUtils.escapeJava((String)sanitizer.getContentPattern().pattern())).append("</contentRegexp>\n").append("    <contentReplacement>").append(StringEscapeUtils.escapeJava((String)sanitizer.getContentReplacement())).append("</contentReplacement>\n").append("  </licenseContentSanitizer>\n");
                }
                sb.append("</licenseContentSanitizers>");
                LOG.debug(sb.toString());
            }
        }
        if (this.licenseContentSanitizers != null) {
            for (LicenseContentSanitizer s : this.licenseContentSanitizers) {
                result.put(s.getId(), SpdxLicenseList.Attachments.ContentSanitizer.compile(s.getId(), s.getUrlRegexp(), s.getContentRegexp(), s.getContentReplacement()));
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private void removeOrphanFiles(List<ProjectLicenseInfo> deps) {
        if (this.removeOrphanLicenseFiles) {
            for (ProjectLicenseInfo dep : deps) {
                for (ProjectLicense lic : dep.getLicenses()) {
                    this.orphanFileNames.remove(lic.getFile());
                }
            }
            for (String fileName : this.orphanFileNames) {
                File file = new File(this.licensesOutputDirectory, fileName);
                if (!file.exists()) continue;
                LOG.info("Removing orphan license file \"{}\"", (Object)file);
                file.delete();
            }
        }
    }

    private List<ProjectLicenseInfo> filterErrors(List<ProjectLicenseInfo> depProjectLicenses) {
        ArrayList<ProjectLicenseInfo> result = new ArrayList<ProjectLicenseInfo>();
        Iterator<ProjectLicenseInfo> it = depProjectLicenses.iterator();
        while (it.hasNext()) {
            ProjectLicenseInfo dep = it.next();
            List<String> messages = dep.getDownloaderMessages();
            if (messages == null || messages.isEmpty()) continue;
            it.remove();
            result.add(dep);
        }
        return result;
    }

    private static ErrorRemedy getEffectiveErrorRemedy(boolean quiet, ErrorRemedy errorRemedy) {
        switch (errorRemedy) {
            case warn: {
                return quiet ? ErrorRemedy.ignore : ErrorRemedy.warn;
            }
        }
        return errorRemedy;
    }

    private void sortByGroupIdAndArtifactId(List<ProjectLicenseInfo> depProjectLicenses) {
        Comparator<ProjectLicenseInfo> comparator = new Comparator<ProjectLicenseInfo>(){

            @Override
            public int compare(ProjectLicenseInfo info1, ProjectLicenseInfo info2) {
                return (info1.getGroupId() + "+" + info1.getArtifactId()).compareTo(info2.getGroupId() + "+" + info2.getArtifactId());
            }
        };
        Collections.sort(depProjectLicenses, comparator);
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public ArtifactFilters getArtifactFilters() {
        if (this.artifactFilters == null) {
            this.artifactFilters = ArtifactFilters.of(this.includedGroups, this.excludedGroups, this.includedArtifacts, this.excludedArtifacts, this.includedScopes, this.excludedScopes, this.includedTypes, this.excludedTypes, this.includeOptional, this.artifactFiltersUrl, this.getEncoding());
        }
        return this.artifactFilters;
    }

    @Override
    public boolean isVerbose() {
        return this.getLog().isDebugEnabled();
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            if (this.licensesOutputDirectory.exists()) {
                if (this.cleanLicensesOutputDirectory) {
                    LOG.info("Cleaning licensesOutputDirectory '{}'", (Object)this.licensesOutputDirectory);
                    FileUtils.cleanDirectory((File)this.licensesOutputDirectory);
                }
            } else {
                FileUtil.createDirectoryIfNecessary(this.licensesOutputDirectory);
            }
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
            FileUtil.createDirectoryIfNecessary(this.licensesErrorsFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    @Override
    protected Path[] getAutodetectEolFiles() {
        return new Path[]{this.licensesConfigFile.toPath(), this.project.getBasedir().toPath().resolve("pom.xml")};
    }

    private Proxy findActiveProxy() throws MojoExecutionException {
        for (Proxy proxy : this.proxies) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            return proxy;
        }
        return null;
    }

    private ProjectLicenseInfo createDependencyProject(LicensedArtifact depMavenProject) throws MojoFailureException {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List<License> licenses = depMavenProject.getLicenses();
        for (License license : licenses) {
            dependencyProject.addLicense(new ProjectLicense(license.getName(), license.getUrl(), license.getDistribution(), license.getComments(), null));
        }
        List<String> msgs = depMavenProject.getErrorMessages();
        for (String msg : msgs) {
            dependencyProject.addDownloaderMessage(msg);
        }
        return dependencyProject;
    }

    private FileNameEntry getLicenseFileName(ProjectLicenseInfo depProject, String url, String licenseName, String licenseFileName) throws URISyntaxException {
        URI licenseUrl = new URI(url);
        File licenseUrlFile = new File(licenseUrl.getPath());
        if (this.organizeLicensesByDependencies) {
            if (licenseFileName != null && !licenseFileName.isEmpty()) {
                return new FileNameEntry(new File(this.licensesOutputDirectory, new File(licenseFileName).getName()), false, null);
            }
            licenseFileName = String.format("%s.%s%s.txt", depProject.getGroupId(), depProject.getArtifactId(), licenseName != null ? "_" + licenseName : "").replaceAll("\\s+", "_");
        } else {
            FileNameEntry preferredFileNameEntry = this.preferredFileNames.getEntryByUrl(url);
            if (preferredFileNameEntry != null) {
                return preferredFileNameEntry;
            }
            if (licenseFileName != null && !licenseFileName.isEmpty()) {
                return new FileNameEntry(new File(this.licensesOutputDirectory, new File(licenseFileName).getName()), false, null);
            }
            licenseFileName = licenseUrlFile.getName();
            if (licenseName != null) {
                licenseFileName = licenseName + " - " + licenseUrlFile.getName();
            }
            licenseFileName = licenseFileName.replaceAll("\\s+", " ");
        }
        licenseFileName = licenseFileName.toLowerCase(Locale.US).replaceAll("[\\\\/]+", "_");
        licenseFileName = this.sanitize(licenseFileName);
        return new FileNameEntry(new File(this.licensesOutputDirectory, licenseFileName), false, null);
    }

    private String sanitize(String licenseFileName) {
        if (this.licenseUrlFileNameSanitizers != null) {
            for (LicenseUrlReplacement sanitizer : this.licenseUrlFileNameSanitizers) {
                String replacement;
                Pattern regexp = sanitizer.getPattern();
                String string = replacement = sanitizer.getReplacement() == null ? "" : sanitizer.getReplacement();
                if (regexp == null) continue;
                licenseFileName = regexp.matcher(licenseFileName).replaceAll(replacement);
            }
        }
        return licenseFileName;
    }

    private void downloadLicenses(LicenseDownloader licenseDownloader, ProjectLicenseInfo depProject, boolean matchingUrlsOnly) throws MojoFailureException {
        LOG.debug("Downloading license(s) for project {}", (Object)depProject);
        List<ProjectLicense> licenses = depProject.getLicenses();
        if (matchingUrlsOnly && (depProject.getLicenses() == null || depProject.getLicenses().isEmpty())) {
            this.handleError(depProject, "No license information available for: " + depProject.toGavString());
            return;
        }
        int licenseIndex = 0;
        for (ProjectLicense license : licenses) {
            if (matchingUrlsOnly && license.getUrl() == null) {
                this.handleError(depProject, "No URL for license at index " + licenseIndex + " in dependency " + depProject.toGavString());
            } else if (license.getUrl() != null) {
                String msg;
                String licenseUrl = this.urlReplacements.rewriteIfNecessary(license.getUrl());
                LicenseDownloader.LicenseDownloadResult cachedResult = this.cache.get(licenseUrl);
                try {
                    FileNameEntry fileNameEntry;
                    if (cachedResult != null) {
                        if (cachedResult.isPreferredFileName() == matchingUrlsOnly) {
                            if (this.organizeLicensesByDependencies) {
                                LicenseDownloader.LicenseDownloadResult byDepsResult;
                                fileNameEntry = this.getLicenseFileName(depProject, licenseUrl, license.getName(), license.getFile());
                                File cachedFile = cachedResult.getFile();
                                File byDepsFile = fileNameEntry.getFile();
                                if (cachedResult.isSuccess() && !cachedFile.equals(byDepsFile)) {
                                    if (!byDepsFile.exists()) {
                                        Files.copy(cachedFile.toPath(), byDepsFile.toPath(), new CopyOption[0]);
                                    }
                                    byDepsResult = cachedResult.withFile(byDepsFile);
                                } else {
                                    byDepsResult = cachedResult;
                                }
                                this.handleResult(licenseUrl, byDepsResult, depProject, license);
                            } else {
                                this.handleResult(licenseUrl, cachedResult, depProject, license);
                            }
                        }
                    } else {
                        fileNameEntry = this.getLicenseFileName(depProject, licenseUrl, license.getName(), license.getFile());
                        File licenseOutputFile = fileNameEntry.getFile();
                        if (matchingUrlsOnly == fileNameEntry.isPreferred()) {
                            LicenseDownloader.LicenseDownloadResult result;
                            if (!licenseOutputFile.exists() || this.forceDownload) {
                                File oldFile;
                                String name;
                                result = licenseDownloader.downloadLicense(licenseUrl, fileNameEntry);
                                if (!this.organizeLicensesByDependencies && result.isSuccess() && (name = this.preferredFileNames.getFileNameBySha1(result.getSha1())) != null && !(oldFile = result.getFile()).getName().equals(name)) {
                                    LOG.debug("Found preferred name '{}' by SHA1 after downloading '{}'; renaming from '{}'", new Object[]{name, licenseUrl, oldFile.getName()});
                                    File newFile = new File(this.licensesOutputDirectory, name);
                                    if (newFile.exists()) {
                                        oldFile.delete();
                                    } else {
                                        oldFile.renameTo(newFile);
                                    }
                                    result = result.withFile(newFile);
                                }
                                this.handleResult(licenseUrl, result, depProject, license);
                                this.cache.put(licenseUrl, result);
                            } else if (licenseOutputFile.exists()) {
                                result = LicenseDownloader.LicenseDownloadResult.success(licenseOutputFile, FileUtil.sha1(licenseOutputFile.toPath()), fileNameEntry.isPreferred());
                                this.handleResult(licenseUrl, result, depProject, license);
                                this.cache.put(licenseUrl, result);
                            }
                        }
                    }
                }
                catch (URISyntaxException e) {
                    msg = "POM for dependency " + depProject.toGavString() + " has an invalid license URL: " + licenseUrl;
                    this.handleError(depProject, msg);
                    LOG.debug(msg, (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    msg = "POM for dependency " + depProject.toGavString() + " has a license URL that returns file not found: " + licenseUrl;
                    this.handleError(depProject, msg);
                    LOG.debug(msg, (Throwable)e);
                }
                catch (IOException e) {
                    msg = "Unable to retrieve license from URL '" + licenseUrl + "' for dependency '" + depProject.toGavString() + "': " + e.getMessage();
                    this.handleError(depProject, msg);
                    LOG.debug(msg, (Throwable)e);
                }
            }
            ++licenseIndex;
        }
    }

    private void handleResult(String licenseUrl, LicenseDownloader.LicenseDownloadResult result, ProjectLicenseInfo depProject, ProjectLicense license) throws MojoFailureException {
        if (result.isSuccess()) {
            license.setFile(result.getFile().getName());
        } else {
            this.handleError(depProject, result.getErrorMessage());
        }
    }

    private void handleError(ProjectLicenseInfo depProject, String msg) throws MojoFailureException {
        if (depProject.isApproved()) {
            LOG.debug("Supressing manually approved license issue: {}", (Object)msg);
        } else {
            switch (this.errorRemedy) {
                case ignore: {
                    break;
                }
                case warn: {
                    LOG.warn(msg);
                    break;
                }
                case failFast: {
                    throw new MojoFailureException(msg);
                }
                case xmlOutput: {
                    LOG.error(msg);
                    depProject.addDownloaderMessage(msg);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value of " + ErrorRemedy.class.getName() + ": " + (Object)((Object)this.errorRemedy));
                }
            }
            ++this.downloadErrorCount;
        }
    }

    public static enum ErrorRemedy {
        ignore,
        warn,
        failFast,
        xmlOutput;

    }
}

