/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.FileState;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="remove-file-header", threadSafe=true)
public class RemoveFileHeaderMojo
extends AbstractLicenseNameMojo {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveFileHeaderMojo.class);
    @Parameter(property="license.skipRemoveLicense", defaultValue="false")
    private boolean skipRemoveLicense;
    @Parameter(property="dryRun", defaultValue="false")
    private boolean dryRun;
    @Parameter(property="license.ignoreNoFileToScan", defaultValue="false")
    private boolean ignoreNoFileToScan;
    @Parameter(property="license.roots")
    private String[] roots;
    @Parameter(property="license.includes")
    private String[] includes;
    @Parameter(property="license.excludes")
    private String[] excludes;
    @Parameter
    private Map<String, String> extraExtensions;
    @Parameter
    private Map<String, String> extraFiles;
    @Parameter(property="license.ignoreTag")
    private String ignoreTag;
    @Component(role=FileHeaderTransformer.class)
    private Map<String, FileHeaderTransformer> transformers;
    private long timestamp;
    private Template descriptionTemplate0;
    private Set<File> processedFiles;
    private EnumMap<FileState, Set<File>> result;
    private Map<String, List<File>> filesToTreatByCommentStyle;

    @Override
    public boolean isSkip() {
        return this.skipRemoveLicense;
    }

    @Override
    public void init() throws Exception {
        FileHeaderTransformer aTransformer;
        if (StringUtils.isEmpty((CharSequence)this.ignoreTag)) {
            this.ignoreTag = "%%Ignore-License";
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String commentFormat = "\n  * %1$s (%2$s)";
            for (String transformerName : this.transformers.keySet()) {
                aTransformer = this.getTransformer(this.transformers, transformerName);
                String str = String.format(commentFormat, aTransformer.getName(), aTransformer.getDescription());
                buffer.append(str);
            }
            LOG.info("{}", (Object)buffer);
        }
        this.timestamp = System.nanoTime();
        super.init();
        if (this.roots == null || this.roots.length == 0) {
            this.roots = DEFAULT_ROOTS;
            if (this.isVerbose()) {
                LOG.info("Will use default roots {}", (Object)this.roots);
            }
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
            if (this.isVerbose()) {
                LOG.info("Will use default includes {}", (Object)this.includes);
            }
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            if (this.isVerbose()) {
                LOG.info("Will use default excludes {}", (Object)this.excludes);
            }
        }
        TreeMap<String, String> extensionToCommentStyle = new TreeMap<String, String>();
        for (Map.Entry<String, FileHeaderTransformer> entry : this.transformers.entrySet()) {
            String[] extensions;
            String commentStyle = entry.getKey();
            aTransformer = entry.getValue();
            for (String extension : extensions = aTransformer.getDefaultAcceptedExtensions()) {
                if (this.isVerbose()) {
                    LOG.info("Associate extension '{}' to comment style '{}'", (Object)extension, (Object)commentStyle);
                }
                extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraExtensions != null) {
            for (Map.Entry<String, Object> entry : this.extraExtensions.entrySet()) {
                String extension = entry.getKey();
                if (extensionToCommentStyle.containsKey(extension)) {
                    LOG.warn("The extension '{}' is already accepted for comment style '{}'", (Object)extension, extensionToCommentStyle.get(extension));
                }
                String commentStyle = (String)entry.getValue();
                this.getTransformer(this.transformers, commentStyle);
                if (this.isVerbose()) {
                    LOG.info("Associate extension '{}' to comment style '{}'", (Object)extension, (Object)commentStyle);
                }
                extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraFiles == null) {
            this.extraFiles = Collections.emptyMap();
        }
        this.filesToTreatByCommentStyle = this.obtainFilesToProcessByCommentStyle(this.extraFiles, this.roots, this.includes, this.excludes, extensionToCommentStyle, this.transformers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        long t0 = System.nanoTime();
        this.processedFiles = new HashSet<File>();
        this.result = new EnumMap(FileState.class);
        try {
            for (Map.Entry<String, List<File>> commentStyleFiles : this.filesToTreatByCommentStyle.entrySet()) {
                String commentStyle = commentStyleFiles.getKey();
                List<File> files = commentStyleFiles.getValue();
                this.processCommentStyle(commentStyle, files);
            }
        }
        finally {
            int nbFiles = this.processedFiles.size();
            if (nbFiles == 0 && !this.ignoreNoFileToScan) {
                LOG.warn("No file to scan.");
            } else {
                String delay = MojoHelper.convertTime(System.nanoTime() - t0);
                LOG.info("Scanned {} file headers in {}.", (Object)nbFiles, (Object)delay);
            }
            Set<FileState> states = this.result.keySet();
            if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
                LOG.info("All files are up-to-date.");
            } else {
                StringBuilder buffer = new StringBuilder();
                for (FileState state : FileState.values()) {
                    this.reportType(this.result, state, buffer);
                }
                LOG.info("{}", (Object)buffer);
            }
        }
    }

    private boolean isDryRun() {
        return this.dryRun;
    }

    private void processCommentStyle(String commentStyle, List<File> filesToTreat) throws IOException {
        License license = this.getLicense(this.getLicenseName(), true);
        if (this.isVerbose()) {
            LOG.info("Process header '{}'", (Object)commentStyle);
            LOG.info(" - using {}", (Object)license.getDescription());
        }
        FileHeaderTransformer transformer = this.getTransformer(this.transformers, commentStyle);
        for (File file : filesToTreat) {
            this.processFile(transformer, file);
        }
        filesToTreat.clear();
    }

    private boolean processFile(FileHeaderTransformer transformer, File file, File processFile) throws IOException {
        String content;
        try {
            content = FileUtil.readAsString(file, this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.ignoreTag)) {
            LOG.info(" - ignore file (detected {}) {}", (Object)this.ignoreTag, (Object)file);
            FileState.ignore.addFile(file, this.result);
            return false;
        }
        String commentStartTag = transformer.getCommentStartTag();
        int firstIndex = content.indexOf(commentStartTag);
        if (firstIndex == -1) {
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        int lastchar = 32;
        while (lastchar != 10 && firstIndex > 0) {
            lastchar = content.charAt(--firstIndex);
        }
        String commentEndTag = transformer.getCommentEndTag();
        int lastIndex = content.indexOf(commentEndTag);
        if (lastIndex == -1) {
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        lastchar = 32;
        while (lastchar != 10) {
            lastchar = content.charAt(++lastIndex);
        }
        if (this.isVerbose()) {
            LOG.info(" - header was removed for {}", (Object)file);
        }
        String contentWithoutHeader = content.substring(0, firstIndex) + content.substring(lastIndex + 1);
        FileUtils.fileWrite((File)processFile, (String)contentWithoutHeader);
        FileState.remove.addFile(file, this.result);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(FileHeaderTransformer transformer, File file) throws IOException {
        if (this.processedFiles.contains(file)) {
            LOG.info(" - skip already processed file {}", (Object)file);
            return;
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
        boolean doFinalize = false;
        try {
            doFinalize = this.processFile(transformer, file, processFile);
        }
        catch (Exception e) {
            LOG.warn("skip failed file: {}{}", new Object[]{e.getMessage(), e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage(), e});
            FileState.fail.addFile(file, this.result);
            doFinalize = false;
        }
        finally {
            this.processedFiles.add(file);
            if (doFinalize) {
                this.finalizeFile(file, processFile);
            } else {
                FileUtil.deleteFile(processFile);
            }
        }
    }

    private void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.isDryRun()) {
            File backupFile = FileUtil.getBackupFile(file);
            if (backupFile.exists()) {
                FileUtil.deleteFile(backupFile);
            }
            LOG.debug(" - backup original file {}", (Object)file);
            FileUtil.renameFile(file, backupFile);
        }
        if (this.isDryRun()) {
            FileUtil.deleteFile(processFile);
        } else {
            try {
                FileUtil.renameFile(processFile, file);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

