/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractLicenseReportMojo
extends AbstractMavenReport {
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="license.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    private List remoteRepositories;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private Renderer siteRenderer;
    @Component
    private I18N i18n;
    @Component
    private DependenciesTool dependenciesTool;
    @Component
    private ThirdPartyTool thirdPartyTool;
    private ThirdPartyHelper helper;

    public abstract boolean isSkip();

    protected abstract void doGenerateReport(Locale var1, Sink var2) throws MavenReportException, MojoExecutionException, MojoFailureException;

    protected ThirdPartyHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DefaultThirdPartyHelper(this.project, this.encoding, this.verbose, this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.remoteRepositories, this.getLog());
        }
        return this.helper;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        boolean mustSkip = this.isSkip();
        if (mustSkip) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return;
        }
        try {
            this.doGenerateReport(locale, this.getSink());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MojoFailureException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getText(locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.getText(locale, "report.title");
    }

    public String getText(Locale locale, String key) {
        return this.i18n.getString(this.getOutputName(), locale, key);
    }

    public I18N getI18n() {
        return this.i18n;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public final String getEncoding() {
        return this.encoding;
    }
}

