/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.lesscss;

import com.googlecode.lesscss4j.LessCompiler;
import com.googlecode.lesscss4j.LessException;
import com.googlecode.lesscss4j.LessSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.lesscss.AbstractLessCssMojo;

public class CompileMojo
extends AbstractLessCssMojo {
    private File outputDirectory;
    private boolean compress;
    private String encoding;
    private boolean force;
    private File lessJs;

    public void execute() throws MojoExecutionException {
        Object[] files;
        long start = System.currentTimeMillis();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("sourceDirectory = " + this.sourceDirectory));
            this.getLog().debug((CharSequence)("outputDirectory = " + this.outputDirectory));
            this.getLog().debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
            this.getLog().debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
            this.getLog().debug((CharSequence)("force = " + this.force));
            this.getLog().debug((CharSequence)("lessJs = " + this.lessJs));
        }
        if ((files = this.getIncludedFiles()) == null || files.length < 1) {
            this.getLog().info((CharSequence)"Nothing to compile - no LESS sources found");
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("included files = " + Arrays.toString(files)));
            }
            LessCompiler lessCompiler = new LessCompiler();
            lessCompiler.setCompress(this.compress);
            lessCompiler.setEncoding(this.encoding);
            if (this.lessJs != null) {
                try {
                    lessCompiler.setLessJs(this.lessJs.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Error while loading LESS JavaScript: " + this.lessJs.getAbsolutePath(), (Exception)e);
                }
            }
            for (Object file : files) {
                File input = new File(this.sourceDirectory, (String)file);
                this.buildContext.removeMessages(input);
                File output = new File(this.outputDirectory, ((String)file).replace(".less", ".css"));
                if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                    throw new MojoExecutionException("Cannot create output directory " + output.getParentFile());
                }
                try {
                    LessSource lessSource = new LessSource(input);
                    if (output.lastModified() < lessSource.getLastModifiedIncludingImports()) {
                        this.getLog().info((CharSequence)("Compiling LESS source: " + (String)file + "..."));
                        lessCompiler.compile(lessSource, output, this.force);
                        this.buildContext.refresh(output);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Bypassing LESS source: " + (String)file + " (not modified)"));
                }
                catch (IOException e) {
                    this.buildContext.addMessage(input, 0, 0, "Error compiling LESS source", 2, (Throwable)e);
                    throw new MojoExecutionException("Error while compiling LESS source: " + (String)file, (Exception)e);
                }
                catch (LessException e) {
                    String message = e.getMessage();
                    if (StringUtils.isEmpty((CharSequence)message)) {
                        message = "Error compiling LESS source";
                    }
                    this.buildContext.addMessage(input, 0, 0, "Error compiling LESS source", 2, (Throwable)e);
                    throw new MojoExecutionException("Error while compiling LESS source: " + (String)file, (Exception)((Object)e));
                }
            }
            this.getLog().info((CharSequence)("Compilation finished in " + (System.currentTimeMillis() - start) + " ms"));
        }
    }
}

