/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jslint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:jslint-maven-plugin:1.0.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "JSLint Maven Plugin", 0);
        this.append(sb, "Provides JSLint capabilities.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jslint:help", 0);
            this.append(sb, "Display help information on jslint-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jslint:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jslint".equals(this.goal)) {
            this.append(sb, "jslint:jslint", 0);
            this.append(sb, "Goal which reports on the source files using JSLint.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adsafe (Default: false)", 2);
                this.append(sb, "true if ADsafe rules should be enforced. @see http://www.ADsafe.org/.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "allowOneVarStatementPerFunction (Default: true)", 2);
                this.append(sb, "true if only one var statement per function should be allowed. @see http://www.jslint.com/lint.html#scope", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeABrowser (Default: true)", 2);
                this.append(sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeAYahooWidget (Default: false)", 2);
                this.append(sb, "true if the Yahoo Widgets globals should be predefined. @see http://www.jslint.com/lint.html#widget", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeConsoleAlertEtc (Default: false)", 2);
                this.append(sb, "true if browser globals that are useful in development should be predefined. @see morehttp://www.jslint.com/lint.html#devel", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeRhino (Default: false)", 2);
                this.append(sb, "true if the Rhino environment globals should be predefined. @see http://www.jslint.com/lint.html#rhino", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeWindows (Default: false)", 2);
                this.append(sb, "true if the Windows globals should be predefined. @see http://www.jslint.com/lint.html#windows", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowBitwiseOperators (Default: true)", 2);
                this.append(sb, "true if bitwise operators should not be allowed. @see http://www.jslint.com/lint.html#bitwise", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowDanglingUnderbarInIdentifiers (Default: false)", 2);
                this.append(sb, "true if names should be checked for initial or trailing underbars.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowIncrAndDecr (Default: false)", 2);
                this.append(sb, "true if ++ and -- should not be allowed. @see http://www.jslint.com/lint.html#inc", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowInsecureCharsInRegExp (Default: true)", 2);
                this.append(sb, "true if . and [^...] should not be allowed in RegExp literals. These forms should not be used when validating in secure applications.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowUndefinedVariables (Default: true)", 2);
                this.append(sb, "true if variables must be declared before used. @see http://www.jslint.com/lint.html#undefined", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use for the JS files.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Files to exclude. Nothing is excluded by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnIssues (Default: true)", 2);
                this.append(sb, "Stop the build if things go wrong according to JSLint.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Files to include. Defaults to '**\\/*.js'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maximumLengthOfLine", 2);
                this.append(sb, "The maximum length of a source line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maximumNumberOfErrors (Default: 50)", 2);
                this.append(sb, "The maximum number of warnings reported.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "predefinedVars (Default: false)", 2);
                this.append(sb, "An array of strings, the names of predefined global variables. predef is used with the option object, but not with the jslint comment. Use the var statement to declare global variables in a script file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "requireInitialCapsForConstructors (Default: true)", 2);
                this.append(sb, "true if Initial Caps must be used with constructor functions. @see http://www.jslint.com/lint.html#new", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "requireUseStrict (Default: false)", 2);
                this.append(sb, "true if the ES5 'use strict'; pragma is required. Do not use this option carelessly.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "safeSubset (Default: false)", 2);
                this.append(sb, "true if the safe subset rules are enforced. These rules are used by ADsafe. It enforces the safe subset rules but not the widget structure rules.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceJsFolder (Default: ${basedir}/src/main/js)", 2);
                this.append(sb, "The source JavaScript folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopOnFirstError (Default: false)", 2);
                this.append(sb, "true if the scan should stop on first error.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "strictWhiteSpace (Default: false)", 2);
                this.append(sb, "true if the ES5 'use strict'; pragma is required. Do not use this option carelessly.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "strictWhiteSpaceIndentation (Default: 4)", 2);
                this.append(sb, "The number of spaces used for indentation.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateContinuation (Default: false)", 2);
                this.append(sb, "true if the continuation statement should be tolerated.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateCSSWorkarounds (Default: false)", 2);
                this.append(sb, "true if CSS workarounds should be tolerated. @see http://www.jslint.com/lint.html#css", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateDebuggerStatements (Default: false)", 2);
                this.append(sb, "true if debugger statements should be allowed. Set this option to false before going into production.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateES5Syntax (Default: false)", 2);
                this.append(sb, "true if ES5 syntax should be allowed.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateEval (Default: false)", 2);
                this.append(sb, "true if eval should be allowed. @see http://www.jslint.com/lint.html#evil", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateHTMLCase (Default: false)", 2);
                this.append(sb, "true if upper case HTML should be allowed.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateHTMLEventHandlers (Default: false)", 2);
                this.append(sb, "true if HTML event handlers should be allowed. @see http://www.jslint.com/lint.html#html", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateHTMLFragments (Default: false)", 2);
                this.append(sb, "true if HTML fragments should be allowed. @see http://www.jslint.com/lint.html#html", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateInefficientSubscripting (Default: false)", 2);
                this.append(sb, "true if subscript notation may be used for expressions better expressed in dot notation.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateUnfilteredForIn (Default: true)", 2);
                this.append(sb, "true if unfiltered for in statements should be allowed. @see http://www.jslint.com/lint.html#forin", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "workFolder (Default: ${project.build.directory}/JSLintMojo/main)", 2);
                this.append(sb, "The folder where files are created that assist with multiple invocations e.g. incremental builds.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-jslint".equals(this.goal)) {
            this.append(sb, "jslint:test-jslint", 0);
            this.append(sb, "Goal which reports on the test source files using JSLint.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adsafe (Default: false)", 2);
                this.append(sb, "true if ADsafe rules should be enforced. @see http://www.ADsafe.org/.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "allowOneVarStatementPerFunction (Default: true)", 2);
                this.append(sb, "true if only one var statement per function should be allowed. @see http://www.jslint.com/lint.html#scope", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeABrowser (Default: true)", 2);
                this.append(sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeAYahooWidget (Default: false)", 2);
                this.append(sb, "true if the Yahoo Widgets globals should be predefined. @see http://www.jslint.com/lint.html#widget", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeConsoleAlertEtc (Default: false)", 2);
                this.append(sb, "true if browser globals that are useful in development should be predefined. @see morehttp://www.jslint.com/lint.html#devel", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeRhino (Default: false)", 2);
                this.append(sb, "true if the Rhino environment globals should be predefined. @see http://www.jslint.com/lint.html#rhino", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "assumeWindows (Default: false)", 2);
                this.append(sb, "true if the Windows globals should be predefined. @see http://www.jslint.com/lint.html#windows", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowBitwiseOperators (Default: true)", 2);
                this.append(sb, "true if bitwise operators should not be allowed. @see http://www.jslint.com/lint.html#bitwise", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowDanglingUnderbarInIdentifiers (Default: false)", 2);
                this.append(sb, "true if names should be checked for initial or trailing underbars.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowIncrAndDecr (Default: false)", 2);
                this.append(sb, "true if ++ and -- should not be allowed. @see http://www.jslint.com/lint.html#inc", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowInsecureCharsInRegExp (Default: true)", 2);
                this.append(sb, "true if . and [^...] should not be allowed in RegExp literals. These forms should not be used when validating in secure applications.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "disallowUndefinedVariables (Default: true)", 2);
                this.append(sb, "true if variables must be declared before used. @see http://www.jslint.com/lint.html#undefined", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use for the JS files.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Files to exclude. Nothing is excluded by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnIssues (Default: true)", 2);
                this.append(sb, "Stop the build if things go wrong according to JSLint.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Files to include. Defaults to '**\\/*.js'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maximumLengthOfLine", 2);
                this.append(sb, "The maximum length of a source line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maximumNumberOfErrors (Default: 50)", 2);
                this.append(sb, "The maximum number of warnings reported.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "predefinedVars (Default: false)", 2);
                this.append(sb, "An array of strings, the names of predefined global variables. predef is used with the option object, but not with the jslint comment. Use the var statement to declare global variables in a script file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "requireInitialCapsForConstructors (Default: true)", 2);
                this.append(sb, "true if Initial Caps must be used with constructor functions. @see http://www.jslint.com/lint.html#new", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "requireUseStrict (Default: false)", 2);
                this.append(sb, "true if the ES5 'use strict'; pragma is required. Do not use this option carelessly.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "safeSubset (Default: false)", 2);
                this.append(sb, "true if the safe subset rules are enforced. These rules are used by ADsafe. It enforces the safe subset rules but not the widget structure rules.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceJsFolder (Default: ${basedir}/src/test/js)", 2);
                this.append(sb, "The JavaScript test source folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopOnFirstError (Default: false)", 2);
                this.append(sb, "true if the scan should stop on first error.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "strictWhiteSpace (Default: false)", 2);
                this.append(sb, "true if the ES5 'use strict'; pragma is required. Do not use this option carelessly.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "strictWhiteSpaceIndentation (Default: 4)", 2);
                this.append(sb, "The number of spaces used for indentation.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateContinuation (Default: false)", 2);
                this.append(sb, "true if the continuation statement should be tolerated.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateCSSWorkarounds (Default: false)", 2);
                this.append(sb, "true if CSS workarounds should be tolerated. @see http://www.jslint.com/lint.html#css", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateDebuggerStatements (Default: false)", 2);
                this.append(sb, "true if debugger statements should be allowed. Set this option to false before going into production.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateES5Syntax (Default: false)", 2);
                this.append(sb, "true if ES5 syntax should be allowed.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateEval (Default: false)", 2);
                this.append(sb, "true if eval should be allowed. @see http://www.jslint.com/lint.html#evil", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateHTMLCase (Default: false)", 2);
                this.append(sb, "true if upper case HTML should be allowed.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateHTMLEventHandlers (Default: false)", 2);
                this.append(sb, "true if HTML event handlers should be allowed. @see http://www.jslint.com/lint.html#html", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateHTMLFragments (Default: false)", 2);
                this.append(sb, "true if HTML fragments should be allowed. @see http://www.jslint.com/lint.html#html", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateInefficientSubscripting (Default: false)", 2);
                this.append(sb, "true if subscript notation may be used for expressions better expressed in dot notation.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerateUnfilteredForIn (Default: true)", 2);
                this.append(sb, "true if unfiltered for in statements should be allowed. @see http://www.jslint.com/lint.html#forin", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "workFolder (Default: ${project.build.directory}/JSLintMojo/test)", 2);
                this.append(sb, "The folder where files are created that assist with multiple invocations e.g. incremental builds.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

