/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.mojo.jboss.AbstractJBossServerMojo;
import org.codehaus.plexus.util.FileUtils;

public class ConfigureJBossMojo
extends AbstractJBossServerMojo {
    private static final String SERVER_DIR_NAME = "server";
    private File confDir;
    private File libDir;
    private File deployDir;
    protected File outputDirectory;
    protected String javaOpts;
    protected String options;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfig();
        this.checkJBossHome();
        File serverDir = new File(this.outputDirectory.getAbsolutePath() + File.separator + this.serverName);
        this.checkOutputDirectory(serverDir);
        this.copyBaseConfDir(serverDir);
        this.copyBaseDeployDir(serverDir);
        this.copyBaseLibDir(serverDir);
        this.overlayConfDir(serverDir);
        this.overlayDeployDir(serverDir);
        this.overlayLibDir(serverDir);
        this.buildBinDir(serverDir);
    }

    private void checkJBossHome() throws MojoFailureException {
        if (!this.jbossHome.exists()) {
            throw new MojoFailureException("The jbossHome specifed does not exist.");
        }
        File serverParentDir = new File(this.jbossHome.getAbsolutePath() + File.separator + SERVER_DIR_NAME);
        if (!serverParentDir.exists()) {
            throw new MojoFailureException(this.jbossHome.getAbsolutePath() + " does not appear to be a valid jboss home");
        }
        File serverDir = new File(serverParentDir.getAbsolutePath() + File.separator + this.serverName);
        if (!serverDir.exists()) {
            throw new MojoFailureException(this.serverName + " is not a valid server in " + serverParentDir.getAbsolutePath());
        }
    }

    private void checkOutputDirectory(File serverDir) throws MojoFailureException {
        if (this.outputDirectory == null) {
            throw new MojoFailureException("I don't know how you did it, but the outputDirectory is null");
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (!serverDir.exists()) {
            serverDir.mkdir();
        }
    }

    private void copyBaseConfDir(File serverDir) throws MojoExecutionException {
        this.copyBaseDir(serverDir, "conf");
    }

    private void copyBaseLibDir(File serverDir) throws MojoExecutionException {
        this.copyBaseDir(serverDir, "lib");
    }

    private void copyBaseDeployDir(File serverDir) throws MojoExecutionException {
        this.copyBaseDir(serverDir, "deploy");
    }

    private void copyBaseDir(File serverDir, String dirName) throws MojoExecutionException {
        File baseDir = new File(this.jbossHome + File.separator + SERVER_DIR_NAME + File.separator + this.serverName + File.separator + dirName);
        File dir = new File(serverDir.getAbsolutePath() + File.separator + dirName);
        try {
            FileUtils.copyDirectoryStructure((File)baseDir, (File)dir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could Not Copy " + dirName + " Dir", (Exception)e);
        }
    }

    private void overlayConfDir(File serverDir) throws MojoExecutionException {
        this.overLayDir(serverDir, this.confDir, "conf");
    }

    private void overlayDeployDir(File serverDir) throws MojoExecutionException {
        this.overLayDir(serverDir, this.deployDir, "deploy");
    }

    private void overlayLibDir(File serverDir) throws MojoExecutionException {
        this.overLayDir(serverDir, this.libDir, "lib");
    }

    private void overLayDir(File serverDir, File overLayDir, String dirName) throws MojoExecutionException {
        File baseDir = new File(serverDir + File.separator + dirName);
        if (overLayDir.exists()) {
            try {
                FileUtils.copyDirectoryStructure((File)overLayDir, (File)baseDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not overlay " + dirName + "Dir", (Exception)e);
            }
        }
    }

    private void buildBinDir(File serverDir) throws MojoExecutionException {
        File binDir = new File(this.outputDirectory.getAbsolutePath() + File.separator + "bin");
        if (!binDir.exists()) {
            binDir.mkdirs();
        }
        VelocityEngine engine = new VelocityEngine();
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        try {
            engine.init(p);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem creating initting velcoity engine", e);
        }
        VelocityContext context = new VelocityContext();
        context.put("jbossServerHome", (Object)serverDir.getAbsolutePath());
        context.put("jbossHome", (Object)this.jbossHome.getAbsolutePath());
        context.put("serverName", (Object)this.serverName);
        context.put("options", (Object)(this.options == null ? "" : this.options));
        context.put("javaOpts", (Object)(this.javaOpts == null ? "" : this.javaOpts));
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.buildWindowsScripts(binDir, engine, context);
        } else {
            this.buildUnixScipts(binDir, engine, context);
        }
    }

    private void buildUnixScipts(File binDir, VelocityEngine engine, VelocityContext context) throws MojoExecutionException {
        File runScript = new File(binDir + File.separator + "run.sh");
        File shutdownScript = new File(binDir + File.separator + "shutdown.sh");
        try {
            Runtime runtime = Runtime.getRuntime();
            Template runTemplate = engine.getTemplate("run.sh.vm");
            FileWriter fileWriter = new FileWriter(runScript);
            runTemplate.merge((Context)context, (Writer)fileWriter);
            fileWriter.flush();
            String command = "chmod 755 " + runScript.getAbsolutePath();
            Process process = runtime.exec(command);
            Template shutdownTemplate = engine.getTemplate("shutdown.sh.vm");
            fileWriter = new FileWriter(shutdownScript);
            shutdownTemplate.merge((Context)context, (Writer)fileWriter);
            fileWriter.flush();
            command = "chmod 755 " + shutdownScript.getAbsolutePath();
            process = runtime.exec(command);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem generating scripts", e);
        }
    }

    private void buildWindowsScripts(File binDir, VelocityEngine engine, VelocityContext context) throws MojoExecutionException {
        File runScript = new File(binDir + File.separator + "run.bat");
        File shutdownScript = new File(binDir + File.separator + "shutdown.bat");
        try {
            Template runTemplate = engine.getTemplate("run.bat.vm");
            FileWriter fileWriter = new FileWriter(runScript);
            runTemplate.merge((Context)context, (Writer)fileWriter);
            fileWriter.flush();
            Template shutdownTemplate = engine.getTemplate("shutdown.bat.vm");
            fileWriter = new FileWriter(shutdownScript);
            shutdownTemplate.merge((Context)context, (Writer)fileWriter);
            fileWriter.flush();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem generating scripts", e);
        }
    }
}

