/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.codehaus.mojo.jaxb2.schemageneration.XsdGeneratorHelper;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.NodeProcessor;
import org.codehaus.plexus.util.IOUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleNamespaceResolver
implements NamespaceContext {
    private static final String DEFAULT_NS = "DEFAULT";
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private static final String SCHEMA = "schema";
    private String sourceFilename;
    private String localNamespaceURI;
    private Map<String, String> prefix2Uri = new HashMap<String, String>();
    private Map<String, String> uri2Prefix = new HashMap<String, String>();

    public SimpleNamespaceResolver(File xmlFile) {
        this.sourceFilename = xmlFile.getName();
        FileReader reader = null;
        try {
            reader = new FileReader(xmlFile);
            this.initialize(reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException("File [" + String.valueOf(xmlFile) + "] could not be found.");
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot handle null prefix argument.");
        }
        return this.prefix2Uri.get("".equals(prefix) ? DEFAULT_NS : prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot acquire prefix for null namespaceURI.");
        }
        return this.uri2Prefix.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot acquire prefixes for null namespaceURI.");
        }
        return Collections.singletonList(this.uri2Prefix.get(namespaceURI)).iterator();
    }

    public Map<String, String> getNamespaceURI2PrefixMap() {
        return Collections.unmodifiableMap(this.uri2Prefix);
    }

    public String getLocalNamespaceURI() {
        return this.localNamespaceURI;
    }

    public String getSourceFilename() {
        return this.sourceFilename;
    }

    private void initialize(Reader xmlFileStream) {
        Document parsedDocument = XsdGeneratorHelper.parseXmlStream(xmlFileStream);
        XsdGeneratorHelper.process(parsedDocument.getFirstChild(), true, new NamespaceAttributeNodeProcessor());
    }

    private class NamespaceAttributeNodeProcessor
    implements NodeProcessor {
        private NamespaceAttributeNodeProcessor() {
        }

        @Override
        public boolean accept(Node aNode) {
            Attr attribute;
            Element parent;
            if (aNode.getNamespaceURI() != null && "http://www.w3.org/2000/xmlns/".equals(aNode.getNamespaceURI())) {
                return true;
            }
            if (aNode instanceof Attr && "http://www.w3.org/2001/XMLSchema".equals((parent = (attribute = (Attr)aNode).getOwnerElement()).getNamespaceURI()) && SimpleNamespaceResolver.SCHEMA.equalsIgnoreCase(parent.getLocalName()) && SimpleNamespaceResolver.TARGET_NAMESPACE.equals(attribute.getLocalName())) {
                SimpleNamespaceResolver.this.localNamespaceURI = attribute.getNodeValue();
            }
            return false;
        }

        @Override
        public void process(Node aNode) {
            String cacheKey = "xmlns".equals(aNode.getNodeName()) ? SimpleNamespaceResolver.DEFAULT_NS : aNode.getLocalName();
            String nodeValue = aNode.getNodeValue();
            String oldUriValue = SimpleNamespaceResolver.this.prefix2Uri.put(cacheKey, nodeValue);
            String oldPrefixValue = SimpleNamespaceResolver.this.uri2Prefix.put(nodeValue, cacheKey);
            if (oldUriValue != null) {
                throw new IllegalStateException("Replaced URI [" + oldUriValue + "] with [" + aNode.getNodeValue() + "] for prefix [" + cacheKey + "]");
            }
            if (oldPrefixValue != null && !oldPrefixValue.equals(cacheKey) && !cacheKey.equals("tns")) {
                throw new IllegalStateException("Replaced prefix [" + oldPrefixValue + "] with [" + cacheKey + "] for URI [" + aNode.getNodeValue() + "]");
            }
        }
    }
}

