/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location;

import com.thoughtworks.qdox.model.JavaParameter;
import java.util.List;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.FieldLocation;
import org.codehaus.mojo.jaxb2.shared.Validate;

public class MethodLocation
extends FieldLocation {
    public static final String NO_PARAMETERS = "()";
    public static final String PARAMETER_SEPARATOR = ",";
    private String parameters = "()";

    public MethodLocation(String packageName, String className, String classXmlName, String memberName, String memberXmlName, List<JavaParameter> parameters) {
        super(packageName, className, classXmlName, memberName, memberXmlName);
        Validate.notNull(parameters, "parameters");
        if (parameters.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (JavaParameter current : parameters) {
                builder.append(current.getType().getFullyQualifiedName()).append(PARAMETER_SEPARATOR);
            }
            this.parameters = "(" + builder.substring(0, builder.lastIndexOf(PARAMETER_SEPARATOR)) + ")";
        }
    }

    @Override
    public String getPath() {
        return super.getPath() + this.parameters;
    }

    @Override
    public String toString() {
        return super.toString() + this.parameters;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getParametersAsString() {
        return this.parameters;
    }

    public boolean hasNoParameters() {
        return NO_PARAMETERS.equals(this.parameters);
    }
}

