/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocData;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.ClassLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.FieldLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.MethodLocation;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DomHelper {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    public static final String ANNOTATION_ELEMENT_NAME = "annotation";
    public static final String DOCUMENTATION_ELEMENT_NAME = "documentation";
    public static final String XSD_SCHEMA_NAMESPACE_PREFIX = "xs";
    public static final List<String> CLASS_FIELD_METHOD_ELEMENT_NAMES = Arrays.asList("element", "attribute");
    public static final List<String> ENUMERATION_FIELD_METHOD_ELEMENT_NAMES = Collections.singletonList("enumeration");

    private DomHelper() {
    }

    public static String getNameAttribute(Node aNode) {
        return DomHelper.getNamedAttribute(aNode, NAME_ATTRIBUTE);
    }

    public static String getValueAttribute(Node aNode) {
        return DomHelper.getNamedAttribute(aNode, VALUE_ATTRIBUTE);
    }

    public static boolean isNamedElement(Node aNode) {
        boolean isElementNode = aNode != null && aNode.getNodeType() == 1;
        return isElementNode && DomHelper.getNamedAttribute(aNode, NAME_ATTRIBUTE) != null && !DomHelper.getNamedAttribute(aNode, NAME_ATTRIBUTE).isEmpty();
    }

    public static String getElementTagName(Node aNode) {
        if (aNode != null && aNode.getNodeType() == 1) {
            Element theElement = (Element)aNode;
            return theElement.getTagName();
        }
        return null;
    }

    public static void addXmlDocumentAnnotationTo(Node aNode, String formattedDocumentation) {
        if (aNode != null && formattedDocumentation != null && !formattedDocumentation.isEmpty()) {
            Document doc = aNode.getOwnerDocument();
            Element annotation = doc.createElementNS("http://www.w3.org/2001/XMLSchema", ANNOTATION_ELEMENT_NAME);
            Element docElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", DOCUMENTATION_ELEMENT_NAME);
            CDATASection xsdDocumentation = doc.createCDATASection(formattedDocumentation);
            annotation.setPrefix(XSD_SCHEMA_NAMESPACE_PREFIX);
            docElement.setPrefix(XSD_SCHEMA_NAMESPACE_PREFIX);
            annotation.appendChild(docElement);
            Node firstChildOfCurrentNode = aNode.getFirstChild();
            if (firstChildOfCurrentNode == null) {
                aNode.appendChild(annotation);
            } else {
                aNode.insertBefore(annotation, firstChildOfCurrentNode);
            }
            docElement.appendChild(xsdDocumentation);
        }
    }

    public static String getXPathFor(Node aNode) {
        ArrayList<String> nodeNameList = new ArrayList<String>();
        for (Node current = aNode; current != null; current = current.getParentNode()) {
            String currentNodeName = current.getNodeName();
            String nameAttribute = DomHelper.getNameAttribute(current);
            if (currentNodeName.toLowerCase().endsWith("enumeration")) {
                nodeNameList.add(currentNodeName + "[@value='" + DomHelper.getValueAttribute(current) + "']");
                continue;
            }
            if (nameAttribute == null) {
                nodeNameList.add(current.getNodeName());
                continue;
            }
            nodeNameList.add(current.getNodeName() + "[@name='" + nameAttribute + "']");
        }
        StringBuilder builder = new StringBuilder();
        ListIterator it = nodeNameList.listIterator(nodeNameList.size());
        while (it.hasPrevious()) {
            builder.append((String)it.previous());
            if (!it.hasPrevious()) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    public static ClassLocation getClassLocation(Node aNode, Set<ClassLocation> classLocations) {
        if (aNode != null) {
            boolean acceptableType;
            String nodeLocalName = aNode.getLocalName();
            boolean bl = acceptableType = "complexType".equalsIgnoreCase(nodeLocalName) || "simpleType".equalsIgnoreCase(nodeLocalName);
            if (acceptableType) {
                String nodeClassName = DomHelper.getNameAttribute(aNode);
                for (ClassLocation current : classLocations) {
                    String effectiveClassName = current.getAnnotationRenamedTo() == null ? current.getClassName() : current.getAnnotationRenamedTo();
                    if (!effectiveClassName.equalsIgnoreCase(nodeClassName)) continue;
                    return current;
                }
            }
        }
        return null;
    }

    public static MethodLocation getMethodLocation(Node aNode, Set<MethodLocation> methodLocations) {
        MethodLocation validLocation;
        MethodLocation toReturn = null;
        if (aNode != null && CLASS_FIELD_METHOD_ELEMENT_NAMES.contains(aNode.getLocalName().toLowerCase()) && (validLocation = (MethodLocation)DomHelper.getFieldOrMethodLocationIfValid(aNode, DomHelper.getContainingClassOrNull(aNode), methodLocations)) != null && "()".equalsIgnoreCase(validLocation.getParametersAsString())) {
            toReturn = validLocation;
        }
        return toReturn;
    }

    public static FieldLocation getFieldLocation(Node aNode, Set<FieldLocation> fieldLocations) {
        FieldLocation toReturn = null;
        if (aNode != null) {
            if (CLASS_FIELD_METHOD_ELEMENT_NAMES.contains(aNode.getLocalName().toLowerCase())) {
                toReturn = (FieldLocation)DomHelper.getFieldOrMethodLocationIfValid(aNode, DomHelper.getContainingClassOrNull(aNode), fieldLocations);
            } else if (ENUMERATION_FIELD_METHOD_ELEMENT_NAMES.contains(aNode.getLocalName().toLowerCase())) {
                toReturn = (FieldLocation)DomHelper.getFieldOrMethodLocationIfValid(aNode, DomHelper.getContainingClassOrNull(aNode), fieldLocations);
            }
        }
        return toReturn;
    }

    public static <T extends FieldLocation> T getFieldOrMethodLocationIfValid(Node aNode, Node containingClassNode, Set<? extends FieldLocation> locations) {
        FieldLocation toReturn = null;
        if (containingClassNode != null) {
            for (FieldLocation fieldLocation : locations) {
                String fieldName = fieldLocation.getAnnotationRenamedTo() == null ? fieldLocation.getMemberName() : fieldLocation.getAnnotationRenamedTo();
                String className = fieldLocation.getClassName();
                try {
                    String attributeValue = DomHelper.getNameAttribute(aNode) == null ? DomHelper.getValueAttribute(aNode) : DomHelper.getNameAttribute(aNode);
                    if (!fieldName.equalsIgnoreCase(attributeValue) || !className.equalsIgnoreCase(DomHelper.getNameAttribute(containingClassNode))) continue;
                    toReturn = fieldLocation;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not acquire FieldLocation for fieldName [" + fieldName + "] and className [" + className + "]", e);
                }
            }
        }
        return (T)toReturn;
    }

    public static void insertXmlDocumentationAnnotationsFor(Node aNode, SortedMap<ClassLocation, JavaDocData> classJavaDocs, SortedMap<FieldLocation, JavaDocData> fieldJavaDocs, SortedMap<MethodLocation, JavaDocData> methodJavaDocs, JavaDocRenderer renderer) {
        JavaDocData javaDocData = null;
        ClassLocation location = null;
        ClassLocation classLocation = DomHelper.getClassLocation(aNode, classJavaDocs.keySet());
        if (classLocation != null) {
            javaDocData = (JavaDocData)classJavaDocs.get(classLocation);
            location = classLocation;
        } else {
            FieldLocation fieldLocation = DomHelper.getFieldLocation(aNode, fieldJavaDocs.keySet());
            if (fieldLocation != null) {
                javaDocData = (JavaDocData)fieldJavaDocs.get(fieldLocation);
                location = fieldLocation;
            } else {
                MethodLocation methodLocation = DomHelper.getMethodLocation(aNode, methodJavaDocs.keySet());
                if (methodLocation != null) {
                    javaDocData = (JavaDocData)methodJavaDocs.get(methodLocation);
                    location = methodLocation;
                }
            }
        }
        if (javaDocData == null) {
            String nodeName = aNode.getNodeName();
            String humanReadableName = DomHelper.getNameAttribute(aNode);
            if (humanReadableName == null && nodeName.toLowerCase().endsWith("enumeration")) {
                humanReadableName = "enumeration#" + DomHelper.getValueAttribute(aNode);
            }
            throw new IllegalStateException("Could not find JavaDocData for XSD node [" + humanReadableName + "] with XPath [" + DomHelper.getXPathFor(aNode) + "]");
        }
        String processedJavaDoc = renderer.render(javaDocData, location).trim();
        DomHelper.addXmlDocumentAnnotationTo(aNode, processedJavaDoc);
    }

    private static Node getContainingClassOrNull(Node aNode) {
        for (Node current = aNode.getParentNode(); current != null; current = current.getParentNode()) {
            boolean foundClassMatch;
            String localName = current.getLocalName();
            boolean bl = foundClassMatch = "complexType".equalsIgnoreCase(localName) || "simpleType".equalsIgnoreCase(localName);
            if (!foundClassMatch) continue;
            return current;
        }
        return null;
    }

    private static String getNamedAttribute(Node aNode, String attributeName) {
        Node nameNode;
        if (aNode == null) {
            return null;
        }
        NamedNodeMap attributes = aNode.getAttributes();
        if (attributes != null && (nameNode = attributes.getNamedItem(attributeName)) != null) {
            return nameNode.getNodeValue().trim();
        }
        return null;
    }
}

