/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.helpers;

import java.util.Map;
import org.codehaus.mojo.jaxb2.helpers.NodeProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFilenameProcessor
implements NodeProcessor {
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String IMPORT = "import";
    private static final String NAMESPACE = "namespace";
    private Map<String, String> namespaceUriToNewFilenameMap;

    public ChangeFilenameProcessor(Map<String, String> namespaceUriToNewFilenameMap) {
        this.namespaceUriToNewFilenameMap = namespaceUriToNewFilenameMap;
    }

    @Override
    public boolean accept(Node aNode) {
        return aNode instanceof Attr && this.isSchemaLocationAttributeForKnownNamespaceUri((Attr)aNode);
    }

    @Override
    public void process(Node aNode) {
        Attr attribute = (Attr)aNode;
        String newFilename = this.namespaceUriToNewFilenameMap.get(this.getNamespace(attribute));
        attribute.setValue(newFilename);
    }

    private boolean isSchemaLocationAttributeForKnownNamespaceUri(Attr attribute) {
        Element parent = attribute.getOwnerElement();
        return "http://www.w3.org/2001/XMLSchema".equals(parent.getNamespaceURI()) && IMPORT.equalsIgnoreCase(parent.getLocalName()) && this.namespaceUriToNewFilenameMap.containsKey(this.getNamespace(attribute)) && SCHEMA_LOCATION.equals(attribute.getName());
    }

    private String getNamespace(Attr attribute) {
        Element parent = attribute.getOwnerElement();
        return parent.getAttribute(NAMESPACE);
    }
}

