/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2;

import com.sun.tools.jxc.SchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jaxb2.TransformSchema;
import org.codehaus.mojo.jaxb2.helpers.SchemagenHelper;
import org.codehaus.mojo.jaxb2.helpers.SimpleNamespaceResolver;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemagenMojo
extends AbstractMojo {
    private static final String SCHEMAGEN_EMITTED_FILENAME = "schema1.xsd";
    private MavenProject project;
    private List<TransformSchema> transformSchemas;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private int staleMillis;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.includes.isEmpty()) {
            throw new MojoExecutionException("At least one file has to be included");
        }
        StaleSourceScanner staleSourceScanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
        SingleTargetSourceMapping mapping = new SingleTargetSourceMapping(".java", SCHEMAGEN_EMITTED_FILENAME);
        staleSourceScanner.addSourceMapping((SourceMapping)mapping);
        HashSet staleSources = new HashSet();
        for (String path : this.getCompileSourceRoots()) {
            File sourceDir = new File(path);
            try {
                staleSources.addAll(staleSourceScanner.getIncludedSources(sourceDir, this.getOutputDirectory()));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        if (!staleSources.isEmpty()) {
            String includePaths = StringUtils.join((Object[])this.includes.toArray(), (String)",");
            String excludePaths = StringUtils.join((Object[])this.excludes.toArray(), (String)",");
            HashSet includedSources = new HashSet();
            SimpleSourceInclusionScanner sourceScanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
            sourceScanner.addSourceMapping((SourceMapping)mapping);
            for (String path : this.getCompileSourceRoots()) {
                File sourceDir = new File(path);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("sourceDir: " + sourceDir.getAbsolutePath()));
                }
                try {
                    includedSources.addAll(FileUtils.getFileNames((File)sourceDir, (String)includePaths, (String)excludePaths, (boolean)true));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error retrieving files in: '" + sourceDir + "' ", (Exception)e);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            StringBuilder classPath = new StringBuilder();
            try {
                List<String> classpathFiles = this.getClasspathElements(this.project);
                classPath = new StringBuilder();
                for (String classpathFile : classpathFiles) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)classpathFile);
                    }
                    classPath.append(classpathFile);
                    classPath.append(File.pathSeparatorChar);
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (!this.getOutputDirectory().exists() && !this.getOutputDirectory().mkdirs()) {
                throw new MojoExecutionException("Could not create directory " + this.getOutputDirectory().getAbsolutePath());
            }
            try {
                args.add("-d");
                args.add(this.getOutputDirectory().getAbsolutePath());
                args.add("-classpath");
                args.add(classPath.toString());
                args.addAll(includedSources);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("args for SchemaGenerator " + args));
                }
                SchemaGenerator.run((String[])args.toArray(new String[0]));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to generate schema", e);
            }
            if (this.transformSchemas != null) {
                SchemagenHelper.validateSchemasInPluginConfiguration(this.transformSchemas);
                if (this.hasRenamingSchemas()) {
                    try {
                        FileUtils.copyDirectory((File)this.getOutputDirectory(), (File)this.getWorkDirectory());
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage());
                    }
                }
                Map<String, SimpleNamespaceResolver> resolverMap = SchemagenHelper.getFileNameToResolverMap(this.getOutputDirectory());
                SchemagenHelper.replaceNamespacePrefixes(resolverMap, this.transformSchemas, this.getLog(), this.getOutputDirectory());
                SchemagenHelper.renameGeneratedSchemaFiles(resolverMap, this.transformSchemas, this.getLog(), this.getOutputDirectory());
            }
        } else {
            this.getLog().info((CharSequence)"No sources found. Skipping schema generation.");
        }
    }

    private boolean hasRenamingSchemas() {
        if (this.transformSchemas != null) {
            for (TransformSchema schema : this.transformSchemas) {
                if (schema.getToFile() == null) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract File getOutputDirectory();

    protected abstract File getWorkDirectory();

    protected abstract List<String> getCompileSourceRoots();

    protected abstract List<String> getClasspathElements(MavenProject var1) throws DependencyResolutionRequiredException;
}

