/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.javancss.NcssExecuter;

public abstract class AbstractNcssReportGenerator {
    private ResourceBundle bundle;
    private Sink sink;
    private Log log;

    protected AbstractNcssReportGenerator(Sink sink, ResourceBundle bundle, Log log) {
        this.bundle = bundle;
        this.sink = sink;
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public Sink getSink() {
        return this.sink;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    protected void codeItemListHelper(String text) {
        this.sink.listItem();
        this.sink.monospaced();
        this.sink.text(text);
        this.sink.monospaced_();
        this.sink.listItem_();
    }

    protected void paragraphHelper(String text) {
        this.sink.paragraph();
        this.sink.text(text);
        this.sink.paragraph_();
    }

    protected void subtitleHelper(String text) {
        this.sink.paragraph();
        this.sink.bold();
        this.sink.text(text);
        this.sink.bold_();
        this.sink.paragraph_();
    }

    protected void codeCellHelper(String text) {
        this.sink.tableCell();
        this.sink.monospaced();
        this.sink.text(text);
        this.sink.monospaced_();
        this.sink.tableCell_();
    }

    protected void headerCellHelper(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void tableCellHelper(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void startSection(String link, String title) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString(title));
        this.sink.sectionTitle1_();
        this.sink.anchor(this.bundle.getString(link));
        this.sink.text(this.bundle.getString(title));
        this.sink.anchor_();
    }

    protected void endSection() {
        this.sink.section1_();
    }

    protected String getString(String key) {
        return this.bundle.getString(key);
    }

    protected void doIntro(boolean withNavigationBar) {
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.getString("report.javancss.main.title"));
        this.getSink().sectionTitle1_();
        if (withNavigationBar) {
            this.navigationBar();
        }
        this.getSink().paragraph();
        String version = NcssExecuter.getJavaNCSSVersion();
        this.getSink().text(MessageFormat.format(this.getString("report.javancss.main.text"), version));
        this.getSink().lineBreak();
        this.getSink().link("http://javancss.codehaus.org/");
        this.getSink().text("JavaNCSS web site.");
        this.getSink().link_();
        this.getSink().paragraph_();
        this.getSink().section1_();
    }

    protected void navigationBar() {
        this.getSink().paragraph();
        this.getSink().text("[ ");
        this.getSink().link("#" + this.getString("report.javancss.package.link"));
        this.getSink().text(this.getString("report.javancss.package.link"));
        this.getSink().link_();
        this.getSink().text(" ] [ ");
        this.getSink().link("#" + this.getString("report.javancss.object.link"));
        this.getSink().text(this.getString("report.javancss.object.link"));
        this.getSink().link_();
        this.getSink().text(" ] [ ");
        this.getSink().link("#" + this.getString("report.javancss.function.link"));
        this.getSink().text(this.getString("report.javancss.function.link"));
        this.getSink().link_();
        this.getSink().text(" ] [ ");
        this.getSink().link("#" + this.getString("report.javancss.explanation.link"));
        this.getSink().text(this.getString("report.javancss.explanation.link"));
        this.getSink().link_();
        this.getSink().text(" ]");
        this.getSink().paragraph_();
    }
}

