/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

class UrlUtils {
    private static final String JAR = "jar:";
    private static final String FILE = "file:";
    private static final String JAR_FILE = "jar:file:";

    UrlUtils() {
    }

    public static File getResourceRoot(URL url, String resource) {
        String path = null;
        if (url != null) {
            String spec = url.toExternalForm();
            if (JAR_FILE.regionMatches(true, 0, spec, 0, JAR_FILE.length())) {
                URL jar;
                try {
                    jar = new URL(spec.substring(JAR.length(), spec.lastIndexOf("!/")));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid JAR URL: " + url + ", " + e.getMessage());
                }
                path = UrlUtils.decodeUrl(jar.getPath());
            } else if (FILE.regionMatches(true, 0, spec, 0, FILE.length())) {
                path = UrlUtils.decodeUrl(url.getPath());
                path = path.substring(0, path.length() - resource.length());
            } else {
                throw new IllegalArgumentException("Invalid class path URL: " + url);
            }
        }
        return path != null ? new File(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeUrl(String url) {
        String decoded = url;
        if (url != null && url.indexOf(37) >= 0) {
            int n = url.length();
            StringBuilder buffer = new StringBuilder();
            ByteBuffer bytes = ByteBuffer.allocate(n);
            int i = 0;
            while (i < n) {
                if (url.charAt(i) == '%') {
                    try {
                        do {
                            byte octet = (byte)Integer.parseInt(url.substring(i + 1, i + 3), 16);
                            bytes.put(octet);
                        } while ((i += 3) < n && url.charAt(i) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (bytes.position() <= 0) continue;
                        bytes.flip();
                        buffer.append(StandardCharsets.UTF_8.decode(bytes));
                        bytes.clear();
                        continue;
                    }
                }
                buffer.append(url.charAt(i++));
            }
            decoded = buffer.toString();
        }
        return decoded;
    }
}

