/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJTree;
import org.codehaus.mojo.javacc.JavaCC;

@Mojo(name="jjtree-javacc", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JJTreeJavaCCMojo
extends AbstractJavaCCMojo {
    @Parameter(property="javacc.buildNodeFiles")
    private Boolean buildNodeFiles;
    @Parameter(property="javacc.multi")
    private Boolean multi;
    @Parameter(property="javacc.nodeDefaultVoid")
    private Boolean nodeDefaultVoid;
    @Parameter(property="javacc.nodeClass")
    private String nodeClass;
    @Parameter(property="javacc.nodeFactory")
    private String nodeFactory;
    @Parameter(property="javacc.nodePackage")
    private String nodePackage;
    @Parameter(property="javacc.nodePrefix")
    private String nodePrefix;
    @Parameter(property="javacc.nodeScopeHook")
    private Boolean nodeScopeHook;
    @Parameter(property="javacc.nodeUsesParser")
    private Boolean nodeUsesParser;
    @Parameter(property="javacc.trackTokens")
    private Boolean trackTokens;
    @Parameter(property="javacc.visitor")
    private Boolean visitor;
    @Parameter(property="javacc.visitorDataType")
    private String visitorDataType;
    @Parameter(property="javacc.visitorReturnType")
    private String visitorReturnType;
    @Parameter(property="javacc.visitorException")
    private String visitorException;
    @Parameter(property="javacc.sourceDirectory", defaultValue="${basedir}/src/main/jjtree")
    private File sourceDirectory;
    @Parameter(property="javacc.interimDirectory", defaultValue="${project.build.directory}/generated-sources/jjtree")
    private File interimDirectory;
    @Parameter(property="javacc.outputDirectory", defaultValue="${project.build.directory}/generated-sources/javacc")
    private File outputDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="javacc.lastModGranularityMs", defaultValue="0")
    private int staleMillis;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jjt", "**/*.JJT"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    @Override
    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory(), this.getInterimDirectory()};
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjtFile = grammarInfo.getGrammarFile();
        File jjtDirectory = jjtFile.getParentFile();
        File tempDirectory = this.getTempDirectory();
        File jjDirectory = new File(tempDirectory, "node");
        File parserDirectory = new File(tempDirectory, "parser");
        String nodePackageName = grammarInfo.resolvePackageName(this.nodePackage);
        JJTree jjtree = this.newJJTree();
        jjtree.setInputFile(jjtFile);
        jjtree.setOutputDirectory(jjDirectory);
        jjtree.setNodePackage(nodePackageName);
        jjtree.run();
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jjtree.getOutputFile());
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
        this.copyGrammarOutput(this.getInterimDirectory(), nodePackageName != null ? nodePackageName : grammarInfo.getParserPackage(), jjDirectory, grammarInfo.getParserName() + "TreeConstants*");
        this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), parserDirectory, grammarInfo.getParserName() + "*");
        if (!this.isSourceRoot(grammarInfo.getSourceDirectory())) {
            this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), jjtDirectory, "*");
        }
        this.deleteTempDirectory(tempDirectory);
    }

    protected JJTree newJJTree() {
        JJTree jjtree = new JJTree();
        jjtree.setLog(this.getLog());
        jjtree.setGrammarEncoding(this.getGrammarEncoding());
        jjtree.setJdkVersion(this.getJdkVersion());
        jjtree.setStatic(this.getIsStatic());
        jjtree.setBuildNodeFiles(this.buildNodeFiles);
        jjtree.setMulti(this.multi);
        jjtree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jjtree.setNodeClass(this.nodeClass);
        jjtree.setNodeFactory(this.nodeFactory);
        jjtree.setNodePrefix(this.nodePrefix);
        jjtree.setNodeScopeHook(this.nodeScopeHook);
        jjtree.setNodeUsesParser(this.nodeUsesParser);
        jjtree.setTrackTokens(this.trackTokens);
        jjtree.setVisitor(this.visitor);
        jjtree.setVisitorDataType(this.visitorDataType);
        jjtree.setVisitorReturnType(this.visitorReturnType);
        jjtree.setVisitorException(this.visitorException);
        return jjtree;
    }
}

