/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JTB;
import org.codehaus.mojo.javacc.JavaCC;
import org.codehaus.plexus.util.FileUtils;

public class JTBJavaCCMojo
extends AbstractJavaCCMojo {
    private String packageName;
    private String nodePackageName;
    private String visitorPackageName;
    private Boolean supressErrorChecking;
    private Boolean javadocFriendlyComments;
    private Boolean descriptiveFieldNames;
    private String nodeParentClass;
    private Boolean parentPointers;
    private Boolean specialTokens;
    private Boolean scheme;
    private Boolean printer;
    private File sourceDirectory;
    private File interimDirectory;
    private File outputDirectory;
    private String[] includes;
    private String[] excludes;
    private int staleMillis;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jtb", "**/*.JTB"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jtbFile = grammarInfo.getGrammarFile();
        File jtbDirectory = jtbFile.getParentFile();
        File jjDirectory = new File(this.getInterimDirectory(), grammarInfo.getParserDirectory());
        String nodePackage = grammarInfo.resolvePackageName(this.getNodePackageName());
        File nodeDirectory = new File(this.getInterimDirectory(), nodePackage.replace('.', File.separatorChar));
        String visitorPackage = grammarInfo.resolvePackageName(this.getVisitorPackageName());
        File visitorDirectory = new File(this.getInterimDirectory(), visitorPackage.replace('.', File.separatorChar));
        File parserDirectory = new File(this.getOutputDirectory(), grammarInfo.getParserDirectory());
        JTB jtb = this.newJTB();
        jtb.setInputFile(jtbFile);
        jtb.setOutputDirectory(jjDirectory);
        jtb.setNodeDirectory(nodeDirectory);
        jtb.setVisitorDirectory(visitorDirectory);
        jtb.setNodePackageName(nodePackage);
        jtb.setVisitorPackageName(visitorPackage);
        jtb.run();
        File nodeDir = new File(this.getOutputDirectory(), nodePackage.replace('.', File.separatorChar));
        try {
            this.getLog().debug((CharSequence)("Copying tree nodes files: " + nodeDirectory + " -> " + nodeDir));
            FileUtils.copyDirectory((File)nodeDirectory, (File)nodeDir, (String)"*.java", (String)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to copy tree nodes files to output directory: " + nodeDirectory + " -> " + nodeDir, e);
        }
        File visitorDir = new File(this.getOutputDirectory(), visitorPackage.replace('.', File.separatorChar));
        try {
            this.getLog().debug((CharSequence)("Copying visitor files: " + visitorDirectory + " -> " + visitorDir));
            FileUtils.copyDirectory((File)visitorDirectory, (File)visitorDir, (String)"*.java", (String)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to copy visitor files to output directory: " + visitorDirectory + " -> " + visitorDir, e);
        }
        try {
            this.getLog().debug((CharSequence)("Copying custom source files: " + jtbDirectory + " -> " + parserDirectory));
            FileUtils.copyDirectory((File)jtbDirectory, (File)parserDirectory, (String)"*.java", (String)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to copy custom source files to output directory:" + jtbDirectory + " -> " + parserDirectory, e);
        }
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jtb.getOutputFile());
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
    }

    private String getNodePackageName() {
        if (this.packageName != null) {
            return this.packageName + ".syntaxtree";
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return "*.syntaxtree";
    }

    private String getVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName + ".visitor";
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return "*.visitor";
    }

    private JTB newJTB() {
        JTB jtb = new JTB();
        jtb.setLog(this.getLog());
        jtb.setDescriptiveFieldNames(this.descriptiveFieldNames);
        jtb.setJavadocFriendlyComments(this.javadocFriendlyComments);
        jtb.setNodeParentClass(this.nodeParentClass);
        jtb.setParentPointers(this.parentPointers);
        jtb.setPrinter(this.printer);
        jtb.setScheme(this.scheme);
        jtb.setSpecialTokens(this.specialTokens);
        jtb.setSupressErrorChecking(this.supressErrorChecking);
        return jtb;
    }
}

