/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fit;

import fit.Fixture;
import fit.Parse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.mojo.fit.ClassLoaderFixture;
import org.codehaus.mojo.fit.FixtureClassLoader;

public class FitRunnerMojo
extends AbstractMojo {
    private static final String COMMA = ",";
    private static final String WIKI_TAG = "wiki";
    private static final String EXECUTION_PARAMETERS = "sourceDirectory={0}, caseSensitive={1}, sourceIncludes={2}, sourceExcludes={3}, parseTags={4}, outputDirectory={5}, ignoreFailures={6}";
    List classpathElements;
    String sourceDirectory;
    boolean caseSensitive;
    String sourceIncludes;
    String sourceExcludes;
    String[] parseTags = new String[]{"table", "tr", "td"};
    String outputDirectory;
    boolean ignoreFailures;
    private DirectoryScanner scanner = new DirectoryScanner();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String executionParameters = MessageFormat.format(EXECUTION_PARAMETERS, this.sourceDirectory, this.caseSensitive, this.sourceIncludes, this.sourceExcludes, Arrays.asList(this.parseTags), this.outputDirectory, this.ignoreFailures);
        this.getLog().debug((CharSequence)("Executing FitRunner with parameters " + executionParameters));
        try {
            this.run(this.sourceDirectory, this.caseSensitive, this.sourceIncludes, this.sourceExcludes, this.outputDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute FitRunner with parameters " + executionParameters, e);
        }
    }

    protected Fixture createFixture() throws MalformedURLException {
        ClassLoaderFixture fixture = new ClassLoaderFixture(new FixtureClassLoader(this.classpathElements));
        this.getLog().debug((CharSequence)("Created " + ClassLoaderFixture.class.getName() + " with classpathElements " + this.classpathElements));
        return fixture;
    }

    protected String toPath(String directory, String name) {
        return new File(directory, name).getPath();
    }

    protected String[] listFiles(String sourceDirectory, boolean caseSensitive, String sourceIncludes, String sourceExcludes) {
        this.scanner.setBasedir(new File(sourceDirectory));
        this.getLog().debug((CharSequence)("Listing files from directory " + sourceDirectory));
        this.getLog().debug((CharSequence)("Setting case sensitive " + caseSensitive));
        this.scanner.setCaseSensitive(caseSensitive);
        if (sourceIncludes != null) {
            this.getLog().debug((CharSequence)("Setting includes " + sourceIncludes));
            this.scanner.setIncludes(sourceIncludes.split(COMMA));
        }
        if (sourceExcludes != null) {
            this.getLog().debug((CharSequence)("Setting excludes " + sourceExcludes));
            this.scanner.setExcludes(sourceExcludes.split(COMMA));
        }
        this.scanner.scan();
        String[] files = this.scanner.getIncludedFiles();
        this.getLog().debug((CharSequence)("Files listed " + Arrays.asList(files)));
        return files;
    }

    protected void ensureDirectoryExists(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            this.getLog().debug((CharSequence)("Creating directory " + file));
            file.mkdirs();
        }
    }

    protected void run(String sourceDirectory, boolean caseSensitive, String sourceIncludes, String sourceExcludes, String outputDirectory) throws Exception {
        this.ensureDirectoryExists(outputDirectory);
        String[] files = this.listFiles(sourceDirectory, caseSensitive, sourceIncludes, sourceExcludes);
        for (int i = 0; i < files.length; ++i) {
            String inputPath = this.toPath(sourceDirectory, files[i]);
            String outputPath = this.toPath(outputDirectory, files[i]);
            this.run(inputPath, outputPath);
        }
    }

    protected void run(String in, String out) throws IOException, ParseException {
        this.run(new File(in), new File(out));
    }

    protected void run(File in, File out) throws IOException, ParseException {
        this.getLog().info((CharSequence)("Running Fixture with input file " + in.getPath() + " and output file " + out.getPath()));
        this.run(new FileReader(in), new FileWriter(out));
    }

    protected void run(Reader reader, Writer writer) throws IOException, ParseException {
        String input = this.read(reader);
        Parse tables = this.parse(input, this.parseTags);
        Fixture fixture = this.createFixture();
        fixture.doTables(tables);
        PrintWriter output = new PrintWriter(writer);
        tables.print(output);
        output.flush();
        if (this.failed(fixture)) {
            String message = "Fixture failed with counts: " + fixture.counts();
            if (this.ignoreFailures) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new IllegalStateException(message);
            }
        }
    }

    protected boolean failed(Fixture fixture) {
        return fixture.counts.wrong > 0 || fixture.counts.exceptions > 0;
    }

    private Parse parse(String input, String[] parseTags) throws ParseException {
        Parse tables = new Parse(input, parseTags);
        if (parseTags.length > 0 && WIKI_TAG.equals(parseTags[0])) {
            this.getLog().debug((CharSequence)"Found parse tag wiki.  Processing contained tags.");
            return tables.parts;
        }
        return tables;
    }

    protected String read(Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        StringBuffer sb = new StringBuffer();
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            line = br.readLine();
        }
        in.close();
        return sb.toString();
    }
}

