/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Consumer;

class LineRedirectOutputStream
extends OutputStream {
    private final Consumer<String> linePrinter;
    private final Charset charset;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public LineRedirectOutputStream(Consumer<String> linePrinter) {
        this(linePrinter, Charset.defaultCharset());
    }

    public LineRedirectOutputStream(Consumer<String> linePrinter, Charset charset) {
        this.linePrinter = Objects.requireNonNull(linePrinter);
        this.charset = Objects.requireNonNull(charset);
    }

    @Override
    public void write(int b) {
        if ((char)b == '\n') {
            this.printAndReset();
            return;
        }
        this.buffer.write(b);
    }

    @Override
    public void flush() {
        if (this.buffer.size() > 0) {
            this.printAndReset();
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    private void printAndReset() {
        this.linePrinter.accept(new String(this.buffer.toByteArray(), this.charset));
        this.buffer = new ByteArrayOutputStream();
    }
}

