/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.mojo.exec.ExecMojo;

class PathsToolchain
implements ToolchainPrivate {
    private final ToolchainModel model;
    private List<String> paths;

    public PathsToolchain(ToolchainModel model) {
        this.model = model;
    }

    public ToolchainModel getModel() {
        return this.model;
    }

    public String getType() {
        return this.model.getType();
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    private List<String> getPaths() {
        return this.paths != null ? this.paths : Collections.emptyList();
    }

    public String findTool(String toolName) {
        return ExecMojo.findExecutable(toolName, this.getPaths());
    }

    public boolean matchesRequirements(Map<String, String> requirements) {
        return requirements.entrySet().stream().anyMatch(entry -> Objects.equals(this.model.getProvides().get(entry.getKey()), entry.getValue()));
    }

    public String toString() {
        return "Paths" + this.getPaths();
    }
}

