/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractExecMojo
extends AbstractMojo {
    protected MavenProject project;
    private File sourceRoot;
    private File testSourceRoot;
    private String commandlineArgs;
    protected String classpathScope;
    private static final char PARAMETER_DELIMITER = ' ';
    private static final char STRING_WRAPPER = '\"';
    private static final char ESCAPE_CHAR = '\\';

    protected void collectProjectArtifactsAndClasspath(List artifacts, List theClasspathFiles) {
        if ("compile".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getCompileArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("test".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getTestArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getTestOutputDirectory()));
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("runtime".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getRuntimeArtifacts());
        } else if ("system".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getSystemArtifacts());
        } else {
            throw new IllegalStateException("Invalid classpath scope: " + this.classpathScope);
        }
        this.getLog().debug((CharSequence)("Collected project artifacts " + artifacts));
        this.getLog().debug((CharSequence)("Collected project classpath " + theClasspathFiles));
    }

    protected String[] parseCommandlineArgs() throws MojoExecutionException {
        if (this.commandlineArgs == null) {
            return null;
        }
        boolean inString = false;
        String arguments = this.commandlineArgs.trim();
        LinkedList<String> argumentList = new LinkedList<String>();
        StringBuffer arg = new StringBuffer();
        for (int chr = 0; chr < arguments.length(); ++chr) {
            char curChar = arguments.charAt(chr);
            if (curChar == '\\') {
                if (arguments.length() == chr + 1) {
                    this.getLog().warn((CharSequence)"\\ was the last character in your command line arguments. Verify your parameters.");
                    continue;
                }
                if (!inString || arguments.charAt(chr + 1) == '\"') {
                    ++chr;
                }
                arg.append(arguments.charAt(chr));
                continue;
            }
            if (curChar == ' ' && !inString) {
                argumentList.add(arg.toString());
                arg.delete(0, arg.length());
                continue;
            }
            if (curChar == '\"') {
                inString = !inString;
                continue;
            }
            arg.append(curChar);
        }
        if (inString) {
            throw new MojoExecutionException("args contains not properly formatted string");
        }
        argumentList.add(arg.toString());
        ListIterator it = argumentList.listIterator();
        String[] result = new String[argumentList.size()];
        int index = 0;
        while (it.hasNext()) {
            result[index] = (String)it.next();
            ++index;
        }
        this.getLog().debug((CharSequence)"Args:");
        it = argumentList.listIterator();
        while (it.hasNext()) {
            this.getLog().debug((CharSequence)(" <" + (String)it.next() + ">"));
        }
        this.getLog().debug((CharSequence)(" parsed from <" + this.commandlineArgs + ">"));
        return result;
    }

    protected boolean hasCommandlineArgs() {
        return this.commandlineArgs != null;
    }

    protected void registerSourceRoots() {
        if (this.sourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile source root " + this.sourceRoot));
            this.project.addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile test source root " + this.testSourceRoot));
            this.project.addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }
}

