/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.docbook;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.docbook.OLinkDBUpdater;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class DocumentTransformer {
    protected Log log;
    protected File sourceDirectory;
    protected File resourceDirectory;
    protected File databaseDirectory;
    protected File outputDirectory;
    protected URI stylesheetLocation;

    public DocumentTransformer(Log log, File sourceDirectory, File resourceDirectory, File databaseDirectory, File outputDirectory, URI stylesheetLocation) {
        this.log = log;
        this.sourceDirectory = sourceDirectory;
        this.resourceDirectory = resourceDirectory;
        this.databaseDirectory = databaseDirectory;
        this.outputDirectory = outputDirectory;
        this.stylesheetLocation = stylesheetLocation;
    }

    public void transform() throws TransformerFactoryConfigurationError, TransformerException, IOException, URISyntaxException, InclusionScanException {
        StaleSourceScanner scanner = new StaleSourceScanner(0L, Collections.singleton("**/*.xml"), Collections.EMPTY_SET);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".xml", ".html"));
        Set staleDocbookFiles = scanner.getIncludedSources(this.sourceDirectory, this.outputDirectory);
        if (staleDocbookFiles.size() > 0) {
            DirectoryScanner docbookScanner = new DirectoryScanner();
            docbookScanner.setBasedir(this.sourceDirectory);
            docbookScanner.setFollowSymlinks(true);
            docbookScanner.setIncludes(new String[]{"**/*.xml"});
            docbookScanner.scan();
            String[] docbookFiles = docbookScanner.getIncludedFiles();
            this.prepareFileSystem(docbookFiles);
            this.transformDocuments(staleDocbookFiles);
        } else {
            this.log.info((CharSequence)"Generated docbook files up to date");
        }
        FileUtils.copyDirectoryStructure((File)this.resourceDirectory, (File)this.outputDirectory);
    }

    protected void prepareFileSystem(String[] docbookFiles) {
        this.log.debug((CharSequence)("Creating output directories for the following files - " + Arrays.asList(docbookFiles).toString()));
        for (int fileIndex = 0; fileIndex < docbookFiles.length; ++fileIndex) {
            String docbookFile = docbookFiles[fileIndex];
            int lastFileSeparator = docbookFile.lastIndexOf(File.separator);
            if (lastFileSeparator <= 0) continue;
            File directory = new File(this.outputDirectory, docbookFile.substring(0, lastFileSeparator));
            directory.mkdirs();
        }
    }

    protected void transformDocuments(Set docbookFiles) throws TransformerException, URISyntaxException {
        this.log.info((CharSequence)("Transforming " + docbookFiles.size() + " Docbook stale file(s)"));
        StreamSource docbookStyleSheetSource = new StreamSource(this.stylesheetLocation.resolve("xhtml/docbook.xsl").toString());
        Transformer documentTransformer = TransformerFactory.newInstance().newTransformer(docbookStyleSheetSource);
        URI olinkDBURI = new File(this.databaseDirectory + File.separator + "olinkdb.xml").toURI();
        documentTransformer.setParameter("target.database.document", olinkDBURI.toString());
        documentTransformer.setParameter("generate.toc", "");
        this.log.debug((CharSequence)"Style sheet loaded.");
        Iterator filesIterator = docbookFiles.iterator();
        while (filesIterator.hasNext()) {
            File docbookFile = (File)filesIterator.next();
            this.log.debug((CharSequence)("Processing " + this.sourceDirectory + File.separator + docbookFile));
            StreamSource source = new StreamSource(docbookFile);
            String relativePath = docbookFile.getAbsolutePath().substring(this.sourceDirectory.getAbsolutePath().length());
            File resultFile = new File(this.outputDirectory, relativePath.substring(0, relativePath.lastIndexOf(46)) + ".html");
            StreamResult result = new StreamResult(resultFile.getAbsolutePath());
            documentTransformer.setParameter("current.docid", OLinkDBUpdater.computeFileID(relativePath));
            documentTransformer.setParameter("html.stylesheet", this.pathToResources(relativePath) + "css/xhtml.css");
            documentTransformer.transform(source, result);
            this.log.debug((CharSequence)("Generated " + this.databaseDirectory + File.separator + docbookFile));
        }
    }

    protected String pathToResources(String relativePath) {
        StringBuffer pathToResources = new StringBuffer();
        int separatorIndex = relativePath.indexOf(File.separator, 1);
        while (separatorIndex != -1) {
            pathToResources.append("../");
            separatorIndex = relativePath.indexOf(File.separator, separatorIndex + 1);
        }
        return pathToResources.toString();
    }
}

