/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReportException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleError;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CloverReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CoberturaReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CpdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject;
import org.codehaus.mojo.dashboard.report.plugin.beans.FindBugsReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.JDependReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.PmdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.SurefireReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.TagListReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.XRefPackageBean;
import org.codehaus.mojo.jdepend.JDependXMLReportParser;
import org.codehaus.mojo.jdepend.objects.JDPackage;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DashBoardUtils {
    private Log log;
    private static DashBoardUtils dashBoardUtils = null;
    private final String cloverDataFile = "site/clover/clover.xml";
    private final String coberturaDataFile = "cobertura.ser";
    private final String pmdDataFile = "pmd.xml";
    private final String cpdDataFile = "cpd.xml";
    private final String checkstyleDataFile = "checkstyle-result.xml";
    private final String jDependDataFile = "jdepend-report.xml";
    private final String findBugsDataFile = "findbugs.xml";
    private static String taglistDataFile = "taglist/taglist.xml";
    private ArtifactRepository localRepo;
    private MavenProjectBuilder projectBuilder;
    private final HashMap projectMap = new HashMap();
    private boolean dbPersist = false;

    public static DashBoardUtils getInstance(Log log, MavenProjectBuilder mavenProjectBuilder, ArtifactRepository localRepository, boolean dbPersist) {
        if (dashBoardUtils == null) {
            dashBoardUtils = new DashBoardUtils(log, mavenProjectBuilder, localRepository, dbPersist);
        } else {
            DashBoardUtils.dashBoardUtils.log = log;
            DashBoardUtils.dashBoardUtils.projectBuilder = mavenProjectBuilder;
            DashBoardUtils.dashBoardUtils.localRepo = localRepository;
            DashBoardUtils.dashBoardUtils.dbPersist = dbPersist;
        }
        return dashBoardUtils;
    }

    private DashBoardUtils(Log log, MavenProjectBuilder mavenProjectBuilder, ArtifactRepository localRepository, boolean dbPersist) {
        this.log = log;
        this.projectBuilder = mavenProjectBuilder;
        this.localRepo = localRepository;
        this.dbPersist = dbPersist;
    }

    public DashBoardMavenProject getDashBoardMavenProject(MavenProject project, String dashboardDataFile, Date generatedDate) {
        DashBoardMavenProject mavenProject;
        String projectName = project.getName();
        this.fillProjectMap(project);
        if (project.getModules().size() > 0) {
            mavenProject = new DashBoardMavenProject(project.getArtifactId(), project.getGroupId(), projectName, project.getVersion());
            for (int i = 0; i < project.getModules().size(); ++i) {
                String modulename = (String)project.getModules().get(i);
                MavenProject proj = this.getModuleMavenProject(project, modulename);
                String key = proj.getGroupId() + "." + proj.getArtifactId();
                if (!this.projectMap.containsKey(key)) continue;
                MavenProject realproj = (MavenProject)this.projectMap.get(key);
                DashBoardMavenProject subMavenProject = dashBoardUtils.getDashBoardMavenProject(realproj, dashboardDataFile, generatedDate);
                mavenProject.addModule(subMavenProject);
            }
        } else {
            mavenProject = new DashBoardMavenProject(project.getArtifactId(), project.getGroupId(), projectName, project.getVersion());
            Iterator reports = project.getReportPlugins().iterator();
            while (reports.hasNext()) {
                ReportPlugin report = (ReportPlugin)reports.next();
                String artifactId = report.getArtifactId();
                AbstractReportBean dashBoardReport = null;
                if ("maven-checkstyle-plugin".equals(artifactId) || "checkstyle-maven-plugin".equals(artifactId)) {
                    dashBoardReport = this.getCheckstyleReport(project, generatedDate);
                } else if ("maven-clover-plugin".equals(artifactId)) {
                    dashBoardReport = this.getCloverReport(project, generatedDate);
                } else if ("maven-surefire-report-plugin".equals(artifactId) || "surefire-report-maven-plugin".equals(artifactId)) {
                    dashBoardReport = this.getSurefireReport(project, generatedDate);
                } else if ("cobertura-maven-plugin".equals(artifactId) || "maven-cobertura-plugin".equals(artifactId)) {
                    dashBoardReport = this.getCoberturaReport(project, generatedDate);
                } else if ("maven-pmd-plugin".equals(artifactId) || "pmd-maven-plugin".equals(artifactId)) {
                    dashBoardReport = this.getCpdReport(project, generatedDate);
                    if (dashBoardReport != null) {
                        mavenProject.addReport(dashBoardReport);
                    }
                    dashBoardReport = this.getPmdReport(project, generatedDate);
                } else if ("maven-findbugs-plugin".equals(artifactId) || "findbugs-maven-plugin".equals(artifactId)) {
                    dashBoardReport = this.getFindBugsReport(project, generatedDate);
                } else if ("maven-jdepend-plugin".equals(artifactId) || "jdepend-maven-plugin".equals(artifactId)) {
                    if (!this.dbPersist) {
                        dashBoardReport = this.getJDependReport(project, generatedDate);
                    }
                } else if ("maven-taglist-plugin".equals(artifactId) || "taglist-maven-plugin".equals(artifactId)) {
                    dashBoardReport = this.getTaglistReport(project, generatedDate);
                }
                if (dashBoardReport == null) continue;
                mavenProject.addReport(dashBoardReport);
            }
        }
        return mavenProject;
    }

    private void fillProjectMap(MavenProject project) {
        if (project.getModules().size() > 0) {
            Iterator iter = project.getCollectedProjects().iterator();
            while (iter.hasNext()) {
                MavenProject proj = (MavenProject)iter.next();
                String key = proj.getGroupId() + "." + proj.getArtifactId();
                if (this.projectMap.containsKey(key)) continue;
                this.projectMap.put(key, proj);
            }
        } else {
            String key = project.getGroupId() + "." + project.getArtifactId();
            if (!this.projectMap.containsKey(key)) {
                this.projectMap.put(key, project);
            }
        }
    }

    private MavenProject getModuleMavenProject(MavenProject project, String module) {
        MavenProject projectModule = null;
        File f = new File(project.getBasedir(), module + "/pom.xml");
        if (f.exists()) {
            try {
                projectModule = this.projectBuilder.build(f, this.localRepo, null);
            }
            catch (ProjectBuildingException e) {
                this.log.error((CharSequence)("Unable to read local module-POM \"" + module + "\"."), (Throwable)e);
            }
        }
        return projectModule;
    }

    protected CoberturaReportBean getCoberturaReport(MavenProject project, Date generatedDate) {
        CoberturaReportBean coberturaReport = new CoberturaReportBean(generatedDate);
        File coberturaFile = this.getCoberturaDataFile(project);
        if (coberturaFile != null && coberturaFile.exists() && coberturaFile.isFile()) {
            this.log.debug((CharSequence)("getCoberturaReport = " + coberturaFile.toString()));
            ProjectData projectData = CoverageDataFileHandler.loadCoverageData((File)coberturaFile);
            if (projectData != null) {
                coberturaReport.setNbClasses(projectData.getNumberOfClasses());
                double lineCoverage = -1.0;
                double branchCoverage = -1.0;
                if (projectData.getNumberOfValidLines() > 0) {
                    lineCoverage = projectData.getLineCoverageRate();
                }
                if (projectData.getNumberOfValidBranches() > 0) {
                    branchCoverage = projectData.getBranchCoverageRate();
                }
                coberturaReport.setLineCoverRate(lineCoverage);
                coberturaReport.setBranchCoverRate(branchCoverage);
                coberturaReport.setNumberOfCoveredBranches(projectData.getNumberOfCoveredBranches());
                coberturaReport.setNumberOfValidBranches(projectData.getNumberOfValidBranches());
                coberturaReport.setNumberOfCoveredLines(projectData.getNumberOfCoveredLines());
                coberturaReport.setNumberOfValidLines(projectData.getNumberOfValidLines());
            } else {
                coberturaReport = null;
            }
        } else {
            coberturaReport = null;
        }
        return coberturaReport;
    }

    protected CheckstyleReportBean getCheckstyleReport(MavenProject project, Date generatedDate) {
        CheckstyleReportBean checkstyleReport = new CheckstyleReportBean(generatedDate);
        File checkstyleFile = new File(project.getBuild().getDirectory(), this.checkstyleDataFile);
        if (checkstyleFile.exists() && checkstyleFile.isFile()) {
            Document doc = this.getDocument(checkstyleFile);
            if (doc != null) {
                Element cpd = doc.getDocumentElement();
                NodeList files = cpd.getElementsByTagName("file");
                NodeList total = cpd.getElementsByTagName("error");
                int nbInfos = 0;
                int nbWarnings = 0;
                int nbErrors = 0;
                for (int i = 0; i < total.getLength(); ++i) {
                    Element error = (Element)total.item(i);
                    CheckstyleError checkstyleError = new CheckstyleError();
                    String severity = error.getAttribute("severity");
                    if (severity.equalsIgnoreCase("info")) {
                        ++nbInfos;
                    } else if (severity.equalsIgnoreCase("warning")) {
                        ++nbWarnings;
                    } else if (severity.equalsIgnoreCase("error")) {
                        ++nbErrors;
                    }
                    checkstyleError.setType(error.getAttribute("severity"));
                    checkstyleError.setNameClass(error.getAttribute("source"));
                    checkstyleError.setMessage(error.getAttribute("message"));
                    checkstyleReport.addError(checkstyleError);
                }
                checkstyleReport.setNbClasses(files.getLength());
                checkstyleReport.setNbErrors(nbErrors);
                checkstyleReport.setNbInfos(nbInfos);
                checkstyleReport.setNbTotal(total.getLength());
                checkstyleReport.setNbWarnings(nbWarnings);
            } else {
                checkstyleReport = null;
            }
        } else {
            checkstyleReport = null;
        }
        return checkstyleReport;
    }

    protected CpdReportBean getCpdReport(MavenProject project, Date generatedDate) {
        CpdReportBean cpdReport = new CpdReportBean(generatedDate);
        File cpdFile = new File(project.getBuild().getDirectory(), this.cpdDataFile);
        if (cpdFile.exists() && cpdFile.isFile()) {
            Document doc = this.getDocument(cpdFile);
            if (doc != null) {
                Element cpd = doc.getDocumentElement();
                NodeList duplications = cpd.getElementsByTagName("duplication");
                NodeList files = cpd.getElementsByTagName("file");
                Vector<String> filelist = new Vector<String>();
                for (int i = 0; i < files.getLength(); ++i) {
                    Element file = (Element)files.item(i);
                    if (filelist.contains(file.getAttribute("path"))) continue;
                    filelist.add(file.getAttribute("path"));
                }
                cpdReport.setNbClasses(filelist.size());
                cpdReport.setNbDuplicate(duplications.getLength());
            } else {
                cpdReport = null;
            }
        } else {
            cpdReport = null;
        }
        return cpdReport;
    }

    protected PmdReportBean getPmdReport(MavenProject project, Date generatedDate) {
        PmdReportBean pmdReport = new PmdReportBean(generatedDate);
        File pmdFile = new File(project.getBuild().getDirectory(), this.pmdDataFile);
        if (pmdFile.exists() && pmdFile.isFile()) {
            Document doc = this.getDocument(pmdFile);
            if (doc != null) {
                Element pmd = doc.getDocumentElement();
                NodeList files = pmd.getElementsByTagName("file");
                NodeList violations = pmd.getElementsByTagName("violation");
                pmdReport.setNbClasses(files.getLength());
                pmdReport.setNbViolations(violations.getLength());
            } else {
                pmdReport = null;
            }
        } else {
            pmdReport = null;
        }
        return pmdReport;
    }

    protected SurefireReportBean getSurefireReport(MavenProject project, Date generatedDate) {
        SurefireReportBean surefireReport = new SurefireReportBean(generatedDate);
        File surefireDirectory = this.getSurefireDirectory(project);
        if (surefireDirectory != null && surefireDirectory.exists() && surefireDirectory.isDirectory()) {
            File[] surefireDirectories = new File[]{surefireDirectory};
            SurefireReportParser report = new SurefireReportParser(surefireDirectories, Locale.getDefault());
            try {
                List testSuites = report.parseXMLReportFiles();
                Map summary = report.getSummary(testSuites);
                surefireReport.setNbTests(Integer.parseInt((String)summary.get("totalTests")));
                surefireReport.setNbErrors(Integer.parseInt((String)summary.get("totalErrors")));
                surefireReport.setNbFailures(Integer.parseInt((String)summary.get("totalFailures")));
                if (summary.get("totalSkipped") != null) {
                    surefireReport.setNbSkipped(Integer.parseInt((String)summary.get("totalSkipped")));
                } else {
                    surefireReport.setNbSkipped(0);
                }
                NumberFormat format = NumberFormat.getInstance(Locale.getDefault());
                String percent = (String)summary.get("totalPercentage");
                try {
                    surefireReport.setSucessRate(format.parse(percent).doubleValue());
                }
                catch (ParseException e) {
                    this.log.info((CharSequence)"SurefireReportBean setSucessRate Unexpected number format exception..", (Throwable)e);
                    surefireReport.setSucessRate(0.0);
                }
                String elapsed = (String)summary.get("totalElapsedTime");
                try {
                    surefireReport.setElapsedTime(format.parse(elapsed).doubleValue());
                }
                catch (ParseException e) {
                    this.log.info((CharSequence)"SurefireReportBean setElapsedTime Unexpected number format exception..", (Throwable)e);
                    surefireReport.setElapsedTime(0.0);
                }
            }
            catch (MavenReportException e) {
                this.log.error((CharSequence)"SurefireReportBean creation failed.", (Throwable)e);
                surefireReport = null;
            }
        } else {
            surefireReport = null;
        }
        return surefireReport;
    }

    protected CloverReportBean getCloverReport(MavenProject project, Date generatedDate) {
        CloverReportBean cloverReport;
        block7: {
            cloverReport = new CloverReportBean(generatedDate);
            File cloverReportFile = new File(project.getBuild().getDirectory(), this.cloverDataFile);
            if (cloverReportFile != null && cloverReportFile.exists() && cloverReportFile.isFile()) {
                try {
                    Document doc = this.getDocument(cloverReportFile);
                    if (doc != null) {
                        NodeList allMetrics = doc.getElementsByTagName("metrics");
                        Element metrics = null;
                        for (int i = 0; i < allMetrics.getLength(); ++i) {
                            Element candidate = (Element)allMetrics.item(i);
                            if (!candidate.getParentNode().getNodeName().equals("project")) continue;
                            metrics = candidate;
                            break;
                        }
                        if (metrics == null) {
                            return null;
                        }
                        cloverReport.setConditionals(Integer.parseInt(metrics.getAttribute("conditionals")));
                        cloverReport.setStatements(Integer.parseInt(metrics.getAttribute("statements")));
                        cloverReport.setMethods(Integer.parseInt(metrics.getAttribute("methods")));
                        cloverReport.setElements(Integer.parseInt(metrics.getAttribute("elements")));
                        cloverReport.setCoveredConditionals(Integer.parseInt(metrics.getAttribute("coveredconditionals")));
                        cloverReport.setCoveredStatements(Integer.parseInt(metrics.getAttribute("coveredstatements")));
                        cloverReport.setCoveredMethods(Integer.parseInt(metrics.getAttribute("coveredmethods")));
                        cloverReport.setCoveredElements(Integer.parseInt(metrics.getAttribute("coveredelements")));
                        break block7;
                    }
                    cloverReport = null;
                }
                catch (Exception e) {
                    this.log.error((CharSequence)"CloverReportBean creation failed.", (Throwable)e);
                    cloverReport = null;
                }
            } else {
                cloverReport = null;
            }
        }
        return cloverReport;
    }

    protected JDependReportBean getJDependReport(MavenProject project, Date generatedDate) {
        JDependReportBean jDependReport;
        block10: {
            this.log.debug((CharSequence)("JDependReportBean creation = " + project.getName() + "."));
            jDependReport = new JDependReportBean(generatedDate);
            File coberturaFile = new File(project.getBasedir(), this.coberturaDataFile);
            File jDependFile = new File(project.getBuild().getDirectory(), this.jDependDataFile);
            ProjectData projectData = null;
            if (coberturaFile.exists() && coberturaFile.isFile()) {
                projectData = CoverageDataFileHandler.loadCoverageData((File)coberturaFile);
            }
            if (jDependFile.exists() && jDependFile.isFile()) {
                try {
                    JDependXMLReportParser xmlParser = new JDependXMLReportParser(jDependFile);
                    List packages = xmlParser.getPackages();
                    if (packages != null && packages.size() > 0) {
                        Iterator iter = packages.iterator();
                        while (iter.hasNext()) {
                            CoverageData data;
                            JDPackage pack = (JDPackage)iter.next();
                            XRefPackageBean bean = new XRefPackageBean();
                            bean.setPackageName(pack.getPackageName());
                            int iCa = Integer.parseInt(pack.getStats().getCa());
                            bean.setAfferentCoupling(new Integer(iCa));
                            if (projectData != null && (data = projectData.getChild(pack.getPackageName())) != null) {
                                bean.setLineCoverRate(data.getLineCoverageRate());
                                bean.setBranchCoverRate(data.getBranchCoverageRate());
                            }
                            jDependReport.addPackage(bean);
                        }
                        break block10;
                    }
                    jDependReport = null;
                }
                catch (ParserConfigurationException e) {
                    this.log.error((CharSequence)"JDependReportBean creation failed.", (Throwable)e);
                    jDependReport = null;
                }
                catch (SAXException e) {
                    this.log.error((CharSequence)"JDependReportBean creation failed.", (Throwable)e);
                    jDependReport = null;
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"JDependReportBean creation failed.", (Throwable)e);
                    jDependReport = null;
                }
            } else {
                jDependReport = null;
            }
        }
        return jDependReport;
    }

    protected FindBugsReportBean getFindBugsReport(MavenProject project, Date generatedDate) {
        FindBugsReportBean findBugsReport = new FindBugsReportBean(generatedDate);
        File findBugsFile = new File(project.getBuild().getDirectory(), this.findBugsDataFile);
        if (findBugsFile.exists() && findBugsFile.isFile()) {
            Document doc = this.getDocument(findBugsFile);
            if (doc != null) {
                Element root = doc.getDocumentElement();
                NodeList files = root.getElementsByTagName("file");
                NodeList bugs = root.getElementsByTagName("BugInstance");
                NodeList missing = root.getElementsByTagName("MissingClass");
                findBugsReport.setNbClasses(files.getLength());
                findBugsReport.setNbErrors(0);
                findBugsReport.setNbBugs(bugs.getLength());
                findBugsReport.setNbMissingClasses(missing.getLength());
                for (int i = 0; i < bugs.getLength(); ++i) {
                    Element bugInstance = (Element)bugs.item(i);
                    String category = bugInstance.getAttribute("category");
                    findBugsReport.addCategory(category);
                    String priority = bugInstance.getAttribute("priority");
                    findBugsReport.addPriority(priority);
                }
            } else {
                findBugsReport = null;
            }
        } else {
            findBugsReport = null;
        }
        return findBugsReport;
    }

    protected TagListReportBean getTaglistReport(MavenProject project, Date generatedDate) {
        TagListReportBean taglistReport = new TagListReportBean(generatedDate);
        File taglistFile = new File(project.getBuild().getDirectory(), taglistDataFile);
        if (taglistFile.exists() && taglistFile.isFile()) {
            Document doc = this.getDocument(taglistFile);
            if (doc != null) {
                Element root = doc.getDocumentElement();
                NodeList tags = root.getElementsByTagName("tag");
                for (int i = 0; i < tags.getLength(); ++i) {
                    Element tag = (Element)tags.item(i);
                    String tagName = tag.getAttribute("name");
                    Integer tagCount = Integer.valueOf(tag.getAttribute("count"));
                    taglistReport.setTag(tagName, tagCount);
                }
                NodeList files = root.getElementsByTagName("file");
                HashMap<String, Integer> classFiles = new HashMap<String, Integer>();
                for (int i = 0; i < files.getLength(); ++i) {
                    Element file = (Element)files.item(i);
                    String className = file.getAttribute("name");
                    classFiles.put(className, new Integer(1));
                }
                taglistReport.setNbClasses(classFiles.size());
            } else {
                taglistReport = null;
            }
        } else {
            taglistReport = null;
        }
        return taglistReport;
    }

    private Document getDocument(File xmlFilename) {
        Document doc = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(xmlFilename);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            InputSource inputSource = new InputSource(inputStreamReader);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(inputSource);
        }
        catch (FileNotFoundException e) {
            this.log.error((CharSequence)"DashBoardUtils getDocument() FileNotFoundException : ", (Throwable)e);
            doc = null;
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((CharSequence)"DashBoardUtils getDocument() UnsupportedEncodingException : ", (Throwable)e);
            doc = null;
        }
        catch (ParserConfigurationException e) {
            this.log.error((CharSequence)"DashBoardUtils getDocument() ParserConfigurationException : ", (Throwable)e);
            doc = null;
        }
        catch (FactoryConfigurationError e) {
            this.log.error((CharSequence)"DashBoardUtils getDocument() FactoryConfigurationError : ", (Throwable)e);
            doc = null;
        }
        catch (SAXException e) {
            this.log.error((CharSequence)"DashBoardUtils getDocument() SAXException : ", (Throwable)e);
            doc = null;
        }
        catch (IOException e) {
            this.log.error((CharSequence)"DashBoardUtils getDocument() IOException : ", (Throwable)e);
            doc = null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DashBoardMavenProject readXMLDashBoardReport(MavenProject project, String dashboardDataFile) {
        DashBoardMavenProject mavenProject = null;
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            File fichier = new File(project.getBuild().getDirectory(), dashboardDataFile);
            FileInputStream fis = new FileInputStream(fichier);
            try {
                xstream.setMode(1001);
                xstream.alias("MavenProject", DashBoardMavenProject.class);
                xstream.alias("xrefpackage", XRefPackageBean.class);
                xstream.alias("checkstyleerror", CheckstyleError.class);
                xstream.useAttributeFor("id", Long.class);
                xstream.useAttributeFor("artifactId", String.class);
                xstream.useAttributeFor("groupId", String.class);
                xstream.useAttributeFor("version", String.class);
                xstream.useAttributeFor("projectName", String.class);
                xstream.useAttributeFor("generatedDate", Date.class);
                xstream.useAttributeFor("averageAfferentCoupling", String.class);
                xstream.useAttributeFor("nbPackages", String.class);
                xstream.useAttributeFor("sumAC", String.class);
                mavenProject = (DashBoardMavenProject)xstream.fromXML((InputStream)fis);
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("readXMLDashBoardReport() for project " + project.getName() + " failed :" + e.getMessage());
            mavenProject = null;
        }
        catch (IOException ioe) {
            System.out.println("readXMLDashBoardReport() for project " + project.getName() + " failed :" + ioe.getMessage());
            mavenProject = null;
        }
        return mavenProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXMLDashBoardReport(MavenProject project, DashBoardMavenProject mavenProject, String dashboardDataFile) {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            File dir = new File(project.getBuild().getDirectory());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File fichier = new File(dir, dashboardDataFile);
            FileOutputStream fos = new FileOutputStream(fichier);
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            try {
                output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                xstream.setMode(1001);
                xstream.alias("MavenProject", DashBoardMavenProject.class);
                xstream.alias("xrefpackage", XRefPackageBean.class);
                xstream.alias("checkstyleerror", CheckstyleError.class);
                xstream.useAttributeFor("id", Long.class);
                xstream.useAttributeFor("artifactId", String.class);
                xstream.useAttributeFor("groupId", String.class);
                xstream.useAttributeFor("version", String.class);
                xstream.useAttributeFor("projectName", String.class);
                xstream.useAttributeFor("generatedDate", Date.class);
                xstream.useAttributeFor("averageAfferentCoupling", String.class);
                xstream.useAttributeFor("nbPackages", String.class);
                xstream.useAttributeFor("sumAC", String.class);
                xstream.toXML((Object)mavenProject, (Writer)output);
            }
            finally {
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            this.log.error((CharSequence)"saveXMLDashBoardReport() failed.", (Throwable)e);
        }
        catch (IOException ioe) {
            this.log.error((CharSequence)"saveXMLDashBoardReport() failed.", (Throwable)ioe);
        }
    }

    private File getCoberturaDataFile(MavenProject project) {
        File coberturaFile = null;
        File brokenDatafile = new File(project.getBasedir(), this.coberturaDataFile);
        File dataFile = new File(project.getBuild().getDirectory(), "cobertura/" + this.coberturaDataFile);
        if (brokenDatafile != null && brokenDatafile.exists()) {
            try {
                FileUtils.copyFile((File)brokenDatafile, (File)dataFile);
                brokenDatafile.delete();
                coberturaFile = dataFile;
            }
            catch (IOException e) {
                coberturaFile = null;
            }
        }
        coberturaFile = dataFile != null && dataFile.exists() ? dataFile : null;
        return coberturaFile;
    }

    private File getSurefireDirectory(MavenProject project) {
        File surefireDir = null;
        String dirPath = this.getConfiguration(project, "maven-surefire-plugin", "org.apache.maven.plugins", "reportsDirectory", "${project.build.directory}/surefire-reports");
        if (dirPath != null && dirPath.length() > 0) {
            surefireDir = new File(dirPath);
        }
        return surefireDir;
    }

    private String getConfiguration(MavenProject project, String pluginArtifact, String pluginGroupId, String optionName, String defaultValue) {
        String result = null;
        String value = "";
        try {
            value = DashBoardUtils.getMavenPluginConfiguration(project, pluginArtifact, pluginGroupId, optionName, "");
            if (value != null && value.length() > 0) {
                if (value.indexOf("$") > -1) {
                    result = this.getInterpolatorValue(project, value);
                } else {
                    File dir = new File(value);
                    boolean isExists = dir.exists();
                    if (!isExists) {
                        File resultFile = FileUtils.resolveFile((File)project.getBasedir(), (String)value);
                        result = resultFile.getAbsolutePath();
                    } else {
                        result = value;
                    }
                }
            } else {
                result = this.getInterpolatorValue(project, defaultValue);
            }
        }
        catch (IOException e) {
            result = null;
            this.log.error((CharSequence)"DashBoardUtils getConfiguration() : ", (Throwable)e);
        }
        return result;
    }

    private String getInterpolatorValue(MavenProject project, String value) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)project));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)project.getProperties()));
        String result = interpolator.interpolate(value, "project");
        return result;
    }

    private static String getMavenPluginConfiguration(MavenProject project, String pluginArtifact, String pluginGroupId, String optionName, String defaultValue) throws IOException {
        Iterator it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom pluginConf;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getGroupId().equals(pluginGroupId) || !plugin.getArtifactId().equals(pluginArtifact) || (pluginConf = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
            StringBuffer sb = new StringBuffer();
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)new StringInputStream(pluginConf.toString()));
                XObject obj = XPathAPI.eval((Node)doc, (String)("//configuration//" + optionName));
                if (!StringUtils.isNotEmpty((String)obj.toString())) continue;
                StringTokenizer token = new StringTokenizer(obj.toString(), "\n ");
                while (token.hasMoreTokens()) {
                    sb.append(token.nextToken().trim());
                    if (!token.hasMoreElements()) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            catch (Exception e) {
                throw new IOException("Exception occured" + e.getMessage());
            }
        }
        return defaultValue;
    }
}

