/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.cobertura.configuration.ConfigCheck;
import org.codehaus.mojo.cobertura.configuration.ConfigInstrumentation;
import org.codehaus.mojo.cobertura.configuration.MaxHeapSizeUtil;
import org.codehaus.mojo.cobertura.tasks.AbstractTask;

public abstract class AbstractCoberturaMojo
extends AbstractMojo {
    protected MavenProject project;
    private String maxmem = "64m";
    protected File dataFile;
    protected ConfigCheck check;
    protected ConfigInstrumentation instrumentation;
    private boolean quiet;
    protected List pluginClasspathList;
    private boolean skip;
    private boolean forceMojoExecution;

    public void setTaskDefaults(AbstractTask task) {
        task.setLog(this.getLog());
        task.setPluginClasspathList(this.pluginClasspathList);
        if (MaxHeapSizeUtil.getInstance().envHasMavenMaxMemSetting()) {
            this.maxmem = MaxHeapSizeUtil.getInstance().getMavenMaxMemSetting();
        } else {
            task.setMaxmem(this.maxmem);
        }
        task.setQuiet(this.quiet);
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cobertura execution");
            return true;
        }
        if (!this.forceMojoExecution && this.project != null && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping cobertura mojo for project with packaging type 'pom'");
            return true;
        }
        return false;
    }
}

