/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:cobertura-maven-plugin:2.5.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Mojo's Maven plugin for Cobertura", 0);
        this.append(sb, "This is the Mojo's Maven plugin for Cobertura. Cobertura is a free Java tool that calculates the percentage of code accessed by tests. It can be used to identify which parts of your Java program are lacking test coverage.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "cobertura:check", 0);
            this.append(sb, "Check the Last Instrumentation Results.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "check", 2);
                this.append(sb, "The Check Configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cobertura.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem (Default: 64m)", 2);
                this.append(sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3);
                this.append(sb, "Expression: ${cobertura.maxmem}", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Only output coberura errors, avoid info messages.", 3);
                this.append(sb, "Expression: ${quiet}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${cobertura.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "cobertura:clean", 0);
            this.append(sb, "Clean up rogue files that cobertura maven plugin is tracking.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cobertura.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem (Default: 64m)", 2);
                this.append(sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3);
                this.append(sb, "Expression: ${cobertura.maxmem}", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Only output coberura errors, avoid info messages.", 3);
                this.append(sb, "Expression: ${quiet}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${cobertura.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "cobertura".equals(this.goal)) {
            this.append(sb, "cobertura:cobertura", 0);
            this.append(sb, "Instruments, Tests, and Generates a Cobertura Report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Generate aggregate reports in multi-module projects.", 3);
                this.append(sb, "Expression: ${cobertura.aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: UTF-8)", 2);
                this.append(sb, "The encoding for the java source code files.", 3);
                this.append(sb, "Expression: ${project.build.sourceEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "format", 2);
                this.append(sb, "The format of the report. (supports 'html' or 'xml'. defaults to 'html')", 3);
                this.append(sb, "Expression: ${cobertura.report.format}", 3);
                this.append(sb, "", 0);
                this.append(sb, "formats", 2);
                this.append(sb, "The format of the report. (can be 'html' and/or 'xml'. defaults to 'html')", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem", 2);
                this.append(sb, "Maximum memory to pass to JVM of Cobertura processes.", 3);
                this.append(sb, "Expression: ${cobertura.maxmem}", 3);
                this.append(sb, "", 0);
                this.append(sb, "omitGplFiles (Default: false)", 2);
                this.append(sb, "Whether to remove GPL licensed files from the generated report. This is required to distribute the report as part of a distribution, which is licensed under the ASL, or a similar license, which is incompatible with the GPL.", 3);
                this.append(sb, "Expression: ${cobertura.omitGplFiles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/cobertura)", 2);
                this.append(sb, "The output directory for the report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Only output cobertura errors, avoid info messages.", 3);
                this.append(sb, "Expression: ${quiet}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "dump-datafile".equals(this.goal)) {
            this.append(sb, "cobertura:dump-datafile", 0);
            this.append(sb, "Cobertura Datafile Dump Mojo", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cobertura.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem (Default: 64m)", 2);
                this.append(sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3);
                this.append(sb, "Expression: ${cobertura.maxmem}", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Only output coberura errors, avoid info messages.", 3);
                this.append(sb, "Expression: ${quiet}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${cobertura.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "cobertura:help", 0);
            this.append(sb, "Display help information on cobertura-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0cobertura:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "instrument".equals(this.goal)) {
            this.append(sb, "cobertura:instrument", 0);
            this.append(sb, "Instrument the compiled classes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: false)", 2);
                this.append(sb, "Specifies whether or not to attach the cobertura artifact to the project", 3);
                this.append(sb, "Expression: ${cobertura.attach}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier (Default: cobertura)", 2);
                this.append(sb, "Specifies the classifier to use for the attached ser artifact", 3);
                this.append(sb, "Expression: ${cobertura.classifier}", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cobertura.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "instrumentation", 2);
                this.append(sb, "The Instrumentation Configuration.", 3);
                this.append(sb, "Expression: ${instrumentation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem (Default: 64m)", 2);
                this.append(sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3);
                this.append(sb, "Expression: ${cobertura.maxmem}", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Only output coberura errors, avoid info messages.", 3);
                this.append(sb, "Expression: ${quiet}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${cobertura.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

