/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.cobertura.configuration.MaxHeapSizeUtil;
import org.codehaus.mojo.cobertura.tasks.CommandLineArguments;
import org.codehaus.mojo.cobertura.tasks.ReportTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaReportMojo
extends AbstractMavenReport {
    private String format;
    private String[] formats = new String[]{"html"};
    private String encoding;
    private String maxmem = "64m";
    private File dataFile;
    private List<Artifact> pluginClasspathList;
    private File outputDirectory;
    private boolean quiet;
    private boolean aggregate;
    private boolean omitGplFiles;
    private Renderer siteRenderer;
    private List<MavenProject> reactorProjects;
    private MavenProject project;
    private Map<MavenProject, List<MavenProject>> projectChildren;
    private String relDataFileName;
    private String relAggregateOutputDir;

    public CoberturaReportMojo() {
        if (MaxHeapSizeUtil.getInstance().envHasMavenMaxMemSetting()) {
            this.maxmem = MaxHeapSizeUtil.getInstance().getMavenMaxMemSetting();
        }
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.cobertura.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.cobertura.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    private void executeReportTask(ReportTask task, String format) throws MavenReportException {
        task.setOutputFormat(format);
        try {
            task.execute();
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error in Cobertura Report generation: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.canGenerateSimpleReport()) {
            this.executeReport(this.getDataFile(), this.outputDirectory, this.getCompileSourceRoots());
        }
        if (this.canGenerateAggregateReports()) {
            this.executeAggregateReport(locale);
        }
    }

    private void executeAggregateReport(Locale locale) throws MavenReportException {
        for (MavenProject proj : this.reactorProjects) {
            if (!this.isMultiModule(proj)) continue;
            this.executeAggregateReport(locale, proj);
        }
    }

    private void executeAggregateReport(Locale locale, MavenProject curProject) throws MavenReportException {
        List<MavenProject> children = this.getAllChildren(curProject);
        if (children.isEmpty()) {
            return;
        }
        List<File> serFiles = this.getOutputFiles(children);
        if (serFiles.isEmpty()) {
            this.getLog().info((CharSequence)("Not executing aggregate cobertura:report for " + curProject.getName() + " as no child cobertura data files could not be found"));
            return;
        }
        this.getLog().info((CharSequence)("Executing aggregate cobertura:report for " + curProject.getName()));
        ProjectData aggProjectData = new ProjectData();
        for (File serFile : serFiles) {
            ProjectData data = CoverageDataFileHandler.loadCoverageData((File)serFile);
            aggProjectData.merge((CoverageData)data);
        }
        File aggSerFile = new File(curProject.getBasedir(), this.relDataFileName);
        aggSerFile.getAbsoluteFile().getParentFile().mkdirs();
        this.getLog().info((CharSequence)("Saving aggregate cobertura information in " + aggSerFile.getAbsolutePath()));
        CoverageDataFileHandler.saveCoverageData((ProjectData)aggProjectData, (File)aggSerFile);
        ArrayList<String> aggCompileSourceRoots = new ArrayList<String>();
        for (MavenProject child : children) {
            aggCompileSourceRoots.addAll(child.getCompileSourceRoots());
        }
        File reportDir = new File(curProject.getBasedir(), this.relAggregateOutputDir);
        reportDir.mkdirs();
        this.executeReport(aggSerFile, reportDir, aggCompileSourceRoots);
    }

    private void executeReport(File curDataFile, File curOutputDirectory, List<String> curCompileSourceRoots) throws MavenReportException {
        ReportTask task = new ReportTask();
        task.setLog(this.getLog());
        task.setPluginClasspathList(this.pluginClasspathList);
        task.setQuiet(this.quiet);
        task.setMaxmem(this.maxmem);
        task.setDataFile(curDataFile);
        task.setOutputDirectory(curOutputDirectory);
        task.setCompileSourceRoots(curCompileSourceRoots);
        task.setSourceEncoding(this.encoding);
        CommandLineArguments cmdLineArgs = new CommandLineArguments();
        cmdLineArgs.setUseCommandsFile(true);
        task.setCmdLineArgs(cmdLineArgs);
        if (this.format != null) {
            this.formats = new String[]{this.format};
        }
        for (int i = 0; i < this.formats.length; ++i) {
            this.executeReportTask(task, this.formats[i]);
        }
        this.removeGplFiles();
    }

    private void removeGplFiles() throws MavenReportException {
        if (this.omitGplFiles) {
            String[] files = new String[]{"js/customsorttypes.js", "js/sortabletable.js", "js/stringbuilder.js"};
            for (int i = 0; i < files.length; ++i) {
                File f = new File(this.outputDirectory, files[i]);
                if (f.exists()) {
                    if (f.delete()) {
                        this.getLog().debug((CharSequence)("Removed GPL licensed file " + f.getPath()));
                        continue;
                    }
                    throw new MavenReportException("Unable to remove GPL licensed file " + f.getPath());
                }
                this.getLog().info((CharSequence)("GPL licensed file " + f.getPath() + " not found."));
            }
        }
    }

    public String getOutputName() {
        return "cobertura/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        if (this.canGenerateSimpleReport()) {
            return true;
        }
        this.getLog().info((CharSequence)("Not executing cobertura:report as the cobertura data file (" + this.getDataFile() + ") could not be found"));
        if (this.canGenerateAggregateReports()) {
            return true;
        }
        return this.aggregate && this.isMultiModule(this.project);
    }

    private boolean canGenerateSimpleReport() {
        return this.getDataFile().exists() && this.getDataFile().isFile();
    }

    private boolean canGenerateAggregateReports() {
        if (this.aggregate && this.isLastProject(this.project, this.reactorProjects)) {
            this.buildAggregateInfo();
            if (!this.getOutputFiles(this.reactorProjects).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private List<String> getCompileSourceRoots() {
        return this.project.getExecutionProject().getCompileSourceRoots();
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("cobertura") ? new File(reportOutputDirectory, "cobertura") : reportOutputDirectory;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cobertura-report", locale);
    }

    private boolean isLastProject(MavenProject project, List<MavenProject> mavenProjectList) {
        return project.equals((Object)mavenProjectList.get(mavenProjectList.size() - 1));
    }

    private boolean isMultiModule(MavenProject mavenProject) {
        return "pom".equals(mavenProject.getPackaging());
    }

    private void buildAggregateInfo() {
        if (this.projectChildren != null) {
            return;
        }
        this.projectChildren = new HashMap<MavenProject, List<MavenProject>>();
        for (MavenProject proj : this.reactorProjects) {
            List<MavenProject> depList = this.projectChildren.get(proj.getParent());
            if (depList == null) {
                depList = new ArrayList<MavenProject>();
                this.projectChildren.put(proj.getParent(), depList);
            }
            depList.add(proj);
        }
        this.relDataFileName = this.relativize(this.project.getBasedir(), this.getDataFile());
        if (this.relDataFileName == null) {
            this.getLog().warn((CharSequence)"Could not determine relative data file name, defaulting to 'cobertura/cobertura.ser'");
            this.relDataFileName = "cobertura/cobertura.ser";
        }
        this.relAggregateOutputDir = this.relativize(this.project.getBasedir(), this.outputDirectory);
        if (this.relAggregateOutputDir == null) {
            this.getLog().warn((CharSequence)"Could not determine relative output dir name, defaulting to 'cobertura'");
            this.relAggregateOutputDir = "cobertura";
        }
    }

    private List<MavenProject> getAllChildren(MavenProject parentProject) {
        List<MavenProject> children = this.projectChildren.get(parentProject);
        if (children == null) {
            return null;
        }
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject child : children) {
            if (this.isMultiModule(child)) {
                result.addAll(this.getAllChildren(child));
                continue;
            }
            result.add(child);
        }
        return result;
    }

    private List<File> getOutputFiles(List<MavenProject> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (MavenProject proj : projects) {
            File outputFile;
            if (this.isMultiModule(proj) || !(outputFile = new File(proj.getBasedir(), this.relDataFileName)).exists()) continue;
            files.add(outputFile);
        }
        return files;
    }

    private String relativize(File parentFile, File childFile) {
        try {
            URI parentURI = parentFile.getCanonicalFile().toURI().normalize();
            URI childURI = childFile.getCanonicalFile().toURI().normalize();
            URI relativeURI = parentURI.relativize(childURI);
            if (relativeURI.isAbsolute()) {
                return null;
            }
            String relativePath = relativeURI.getPath();
            if (File.separatorChar != '/') {
                relativePath = relativePath.replace('/', File.separatorChar);
            }
            return relativePath;
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed relativizing " + childFile + " to " + parentFile), (Throwable)e);
            return null;
        }
    }

    private File getDataFile() {
        return this.dataFile;
    }
}

