/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.MessageTranslator;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Difference {
    private static final MessageTranslator ARGS_EXTRACTOR = new MessageTranslator();
    private int differenceType;
    private String className;
    private String field;
    private String method;
    private String from;
    private String to;
    private String justification;

    /*
     * Enabled aggressive block sorting
     */
    public static Difference[] parseXml(Reader xml) throws XmlPullParserException, IOException {
        MXParser parser = new MXParser();
        parser.setInput(xml);
        ArrayList<Difference> diffs = new ArrayList<Difference>();
        int state = 0;
        Difference current = null;
        int event;
        block12: while ((event = parser.next()) != 1) {
            switch (event) {
                case 2: {
                    switch (state) {
                        case 0: {
                            state = 1;
                            break;
                        }
                        case 1: {
                            if ("difference".equals(parser.getName())) {
                                current = new Difference();
                                state = 2;
                                break;
                            }
                            continue block12;
                        }
                        case 2: {
                            String name = parser.getName();
                            String value = parser.nextText().trim();
                            if ("className".equals(name)) {
                                current.className = value;
                                break;
                            }
                            if ("differenceType".equals(name)) {
                                current.differenceType = Integer.parseInt(value);
                                break;
                            }
                            if ("field".equals(name)) {
                                current.field = value;
                                break;
                            }
                            if ("method".equals(name)) {
                                current.method = value;
                                break;
                            }
                            if ("from".equals(name)) {
                                current.from = value;
                                break;
                            }
                            if ("to".equals(name)) {
                                current.to = value;
                                break;
                            }
                            if ("justification".equals(name)) {
                                current.justification = value;
                            }
                            continue block12;
                        }
                    }
                    continue block12;
                }
                case 3: {
                    switch (state) {
                        case 1: 
                        case 2: {
                            if (!"difference".equals(parser.getName())) break;
                            diffs.add(current);
                            state = 1;
                        }
                    }
                    continue block12;
                }
            }
        }
        return diffs.toArray(new Difference[diffs.size()]);
    }

    public int getDifferenceType() {
        return this.differenceType;
    }

    public void setDifferenceType(int differenceType) {
        this.differenceType = differenceType;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getJustification() {
        return this.justification;
    }

    public void setJustification(String justification) {
        this.justification = justification;
    }

    public Result matches(ApiDifference apiDiff) {
        if (apiDiff.getMessage().getId() != this.differenceType) {
            return Result.notMatched();
        }
        String affectedClassPath = apiDiff.getAffectedClass().replace('.', '/');
        if (!SelectorUtils.matchPath((String)this.className, (String)affectedClassPath, (String)"/", (boolean)true)) {
            return Result.notMatched();
        }
        switch (this.differenceType) {
            case 1000: {
                return Result.matched();
            }
            case 1001: {
                return Result.matched();
            }
            case 2000: {
                return Result.matched();
            }
            case 2001: {
                return Result.matched();
            }
            case 3000: {
                return Result.matched();
            }
            case 3001: {
                return Result.matched();
            }
            case 3002: {
                return Result.matched();
            }
            case 3003: {
                return Result.matched();
            }
            case 3004: {
                return Result.matched();
            }
            case 3005: {
                return Result.matched();
            }
            case 4000: {
                return this.matches4000(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 4001: {
                return this.matches4001(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 5000: {
                return this.matches5000(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 5001: {
                return this.matches5001(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6000: {
                return this.matches6000(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6001: {
                return this.matches6001(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6002: {
                return this.matches6002(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6003: {
                return this.matches6003(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6004: {
                return this.matches6004(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6005: {
                return this.matches6005(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6006: {
                return this.matches6006(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6007: {
                return this.matches6007(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6008: {
                return this.matches6008(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6009: {
                return this.matches6009(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6010: {
                return this.matches6010(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 6011: {
                return this.matches6011(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7000: {
                return this.matches7000(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7001: {
                return this.matches7001(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7002: {
                return this.matches7002(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7003: {
                return this.matches7003(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7004: {
                return this.matches7004(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7005: {
                return Result.deferred(this.getDifferentiatorFor7005(apiDiff));
            }
            case 7006: {
                return this.matches7006(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7007: {
                return this.matches7007(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7008: {
                return this.matches7008(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7009: {
                return this.matches7009(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7010: {
                return this.matches7010(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7011: {
                return this.matches7011(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7012: {
                return this.matches7012(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7013: {
                return this.matches7013(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7014: {
                return this.matches7014(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 7015: {
                return this.matches7015(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 8000: {
                return Result.matched();
            }
            case 8001: {
                return Result.matched();
            }
            case 10000: {
                return this.matches10000(apiDiff) ? Result.matched() : Result.notMatched();
            }
            case 10001: {
                return this.matches10001(apiDiff) ? Result.matched() : Result.notMatched();
            }
        }
        return Result.notMatched();
    }

    public boolean resolveDefferedMatches(List<ApiDifference> defferedApiDifferences) {
        if (this.differenceType == 7005) {
            return this.matches7005(defferedApiDifferences);
        }
        return false;
    }

    public String toString() {
        return "Difference[differenceType=" + this.differenceType + ", className=" + this.className + ", field=" + this.field + ", method=" + this.method + ", from=" + this.from + ", to=" + this.to + "]";
    }

    private boolean matches4000(ApiDifference apiDiff) {
        this.throwIfMissing(false, false, false, true);
        String newIface = Difference.getArgs(apiDiff)[0];
        newIface = newIface.replace('.', '/');
        return SelectorUtils.matchPath((String)this.to, (String)newIface, (String)"/", (boolean)true);
    }

    private boolean matches4001(ApiDifference apiDiff) {
        this.throwIfMissing(false, false, false, true);
        String removedIface = Difference.getArgs(apiDiff)[0];
        removedIface = removedIface.replace('.', '/');
        return SelectorUtils.matchPath((String)this.to, (String)removedIface, (String)"/", (boolean)true);
    }

    private boolean matches5000(ApiDifference apiDiff) {
        this.throwIfMissing(false, false, false, true);
        String newSuperclass = Difference.getArgs(apiDiff)[0];
        newSuperclass = newSuperclass.replace('.', '/');
        return SelectorUtils.matchPath((String)this.to, (String)newSuperclass, (String)"/", (boolean)true);
    }

    private boolean matches5001(ApiDifference apiDiff) {
        this.throwIfMissing(false, false, false, true);
        String removedSuperclass = Difference.getArgs(apiDiff)[0];
        removedSuperclass = removedSuperclass.replace('.', '/');
        return SelectorUtils.matchPath((String)this.to, (String)removedSuperclass, (String)"/", (boolean)true);
    }

    private boolean matches6000(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6001(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6002(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6003(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6004(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, true, true);
        if (!SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField())) {
            return false;
        }
        String[] args = Difference.getArgs(apiDiff);
        String diffFrom = args[0];
        String diffTo = args[1];
        return SelectorUtils.matchPath((String)this.from, (String)diffFrom) && SelectorUtils.matchPath((String)this.to, (String)diffTo);
    }

    private boolean matches6005(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6006(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6007(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6008(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6009(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6010(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches6011(ApiDifference apiDiff) {
        this.throwIfMissing(true, false, false, false);
        return SelectorUtils.matchPath((String)this.field, (String)apiDiff.getAffectedField());
    }

    private boolean matches7000(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7001(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7002(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7003(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7004(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private Object getDifferentiatorFor7005(ApiDifference apiDiff) {
        return apiDiff.getAffectedClass() + apiDiff.getAffectedMethod();
    }

    private boolean matches7005(List<ApiDifference> apiDiffs) {
        this.throwIfMissing(false, true, false, true);
        ApiDifference firstDiff = apiDiffs.get(0);
        String methodSig = this.removeVisibilityFromMethodSignature(firstDiff);
        if (!SelectorUtils.matchPath((String)this.method, (String)methodSig)) {
            return false;
        }
        String newMethodSig = Difference.getNewMethodSignature(methodSig, apiDiffs);
        return SelectorUtils.matchPath((String)this.to, (String)newMethodSig);
    }

    public static String getNewMethodSignature(String methodSig, List<ApiDifference> apiDiffs) {
        String newMethodSig = methodSig;
        for (ApiDifference apiDiff : apiDiffs) {
            String[] args = Difference.getArgs(apiDiff);
            int idx = Integer.parseInt(args[0]) - 1;
            String diffNewType = args[1];
            newMethodSig = Difference.replaceNthArgumentType(newMethodSig, idx, diffNewType);
        }
        return newMethodSig;
    }

    private boolean matches7006(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, true);
        String methodSig = this.removeVisibilityFromMethodSignature(apiDiff);
        if (!SelectorUtils.matchPath((String)this.method, (String)methodSig)) {
            return false;
        }
        String newRetType = Difference.getArgs(apiDiff)[0];
        return SelectorUtils.matchPath((String)this.to, (String)newRetType);
    }

    private boolean matches7007(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7008(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7009(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7010(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7011(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7012(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7013(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7014(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches7015(ApiDifference apiDiff) {
        this.throwIfMissing(false, true, false, false);
        return SelectorUtils.matchPath((String)this.method, (String)this.removeVisibilityFromMethodSignature(apiDiff));
    }

    private boolean matches10000(ApiDifference apiDiff) {
        this.throwIfMissing(false, false, true, true);
        int fromVersion = 0;
        int toVersion = 0;
        try {
            fromVersion = Integer.parseInt(this.from);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse the \"from\" parameter as a number for " + this);
        }
        try {
            toVersion = Integer.parseInt(this.to);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse the \"to\" parameter as a number for " + this);
        }
        String[] args = Difference.getArgs(apiDiff);
        int reportedOld = Integer.parseInt(args[0]);
        int reportedNew = Integer.parseInt(args[1]);
        return fromVersion == reportedOld && toVersion == reportedNew;
    }

    private boolean matches10001(ApiDifference apiDiff) {
        this.throwIfMissing(false, false, true, true);
        int fromVersion = 0;
        int toVersion = 0;
        try {
            fromVersion = Integer.parseInt(this.from);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse the \"from\" parameter as a number for " + this);
        }
        try {
            toVersion = Integer.parseInt(this.to);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse the \"to\" parameter as a number for " + this);
        }
        String[] args = Difference.getArgs(apiDiff);
        int reportedOld = Integer.parseInt(args[0]);
        int reportedNew = Integer.parseInt(args[1]);
        return fromVersion == reportedOld && toVersion == reportedNew;
    }

    private static String[] getArgs(ApiDifference apiDiff) {
        String args = apiDiff.getReport(ARGS_EXTRACTOR);
        return args.split("&");
    }

    private void throwIfMissing(boolean field, boolean method, boolean from, boolean to) {
        boolean doThrow;
        boolean bl = doThrow = field && this.field == null || method && this.method == null || from && this.from == null || to && this.to == null;
        if (doThrow) {
            StringBuilder message = new StringBuilder("The following parameters are missing: ");
            if (field && this.field == null) {
                message.append("field, ");
            }
            if (method && this.method == null) {
                message.append("method, ");
            }
            if (from && this.from == null) {
                message.append("from, ");
            }
            if (to && this.to == null) {
                message.append("to, ");
            }
            message.replace(message.length() - 2, message.length(), "");
            message.append(" on ").append(this);
            throw new IllegalArgumentException(message.toString());
        }
    }

    private static String replaceNthArgumentType(String signature, int idx, String newType) {
        int nextCommaIdx;
        int openParIdx = signature.indexOf(40);
        int closeParIdx = signature.indexOf(41);
        if (openParIdx < 0 || closeParIdx < 0) {
            throw new IllegalArgumentException("Invalid method signature found in the API difference report: " + signature);
        }
        StringBuilder bld = new StringBuilder();
        bld.append(signature, 0, openParIdx).append('(');
        int commaIdx = openParIdx + 1;
        int paramIdx = 0;
        while ((nextCommaIdx = signature.indexOf(44, commaIdx)) >= 0) {
            String type = paramIdx == idx ? newType : signature.substring(commaIdx, nextCommaIdx);
            bld.append(type.trim());
            bld.append(", ");
            commaIdx = nextCommaIdx + 1;
            ++paramIdx;
        }
        if (paramIdx == idx) {
            bld.append(newType);
        } else {
            bld.append(signature, commaIdx + 1, closeParIdx);
        }
        bld.append(")");
        return bld.toString();
    }

    private String removeVisibilityFromMethodSignature(ApiDifference apiDiff) {
        String methodSig = apiDiff.getAffectedMethod();
        if (methodSig == null) {
            return null;
        }
        int spaceIdx = methodSig.indexOf(32);
        if (spaceIdx < 0) {
            return methodSig;
        }
        return methodSig.substring(spaceIdx + 1);
    }

    static {
        ARGS_EXTRACTOR.setResourceName(Difference.class.getName());
    }

    public static class Result {
        public static final int MATCHED = 0;
        public static final int NOT_MATCHED = 1;
        public static final int DEFERRED_MATCH = 2;
        private int code;
        private Object differentiator;

        public Result(int code, Object differentiator) {
            this.code = code;
            this.differentiator = differentiator;
        }

        public static Result notMatched() {
            return new Result(1, null);
        }

        public static Result matched() {
            return new Result(0, null);
        }

        public static Result deferred(Object differentiator) {
            return new Result(2, differentiator);
        }

        public int getCode() {
            return this.code;
        }

        public Object getDifferentiator() {
            return this.differentiator;
        }
    }
}

