/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.data;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TestCaseIdentifierHelper {
    private static TestCaseIdentifierHelper INSTANCE = new TestCaseIdentifierHelper();
    private PackageHolder base = new PackageHolder(null, null);
    private Map<String, PackageHolder> testCases = new HashMap<String, PackageHolder>();

    public static TestCaseIdentifierHelper instance() {
        return INSTANCE;
    }

    public String getIdentifier(String classname, String name) {
        PackageHolder packageHolder = this.testCases.get(classname);
        if (packageHolder == null) {
            packageHolder = this.base.addTestCase(new StringTokenizer(classname, "."));
            this.testCases.put(classname, packageHolder);
        }
        String result = packageHolder.getId() + "#" + name;
        return result;
    }

    private static class PackageHolder {
        private String name;
        private PackageHolder parent;
        private Map<String, PackageHolder> children = new HashMap<String, PackageHolder>();

        PackageHolder(String name, PackageHolder parent) {
            this.name = name;
            this.parent = parent;
        }

        public String getId() {
            if (this.name == null) {
                return null;
            }
            String parentId = this.parent.getId();
            if (parentId == null) {
                return this.name;
            }
            return parentId + "." + this.name;
        }

        public PackageHolder addTestCase(StringTokenizer st) {
            if (!st.hasMoreTokens()) {
                return this;
            }
            String _package = st.nextToken();
            if (this.children.containsKey(_package)) {
                return this.children.get(_package).addTestCase(st);
            }
            PackageHolder packageHolder = new PackageHolder(_package, this);
            this.children.put(_package, packageHolder);
            return packageHolder.addTestCase(st);
        }
    }
}

