/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.responsetime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.stat.StatUtils;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSample;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class ResponsetimeSamples
implements Serializable {
    private static final long serialVersionUID = 4056724466498233661L;
    protected List samples = new ArrayList();
    private int succeeded;
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    public void add(ResponsetimeSample sample, String sampleName) {
        this.samples.add(sample);
        if (sample.isSuccess()) {
            ++this.succeeded;
        }
    }

    public int size() {
        return this.samples.size();
    }

    public double getSuccessrate() {
        return 100.0 * (double)this.getSucceeded() / (double)this.samples.size();
    }

    public int getFailed() {
        return this.samples.size() - this.getSucceeded();
    }

    public int getSucceeded() {
        return this.succeeded;
    }

    public double getAverage(int responsetimedivider) {
        return StatUtils.mean((double[])this.extractResponsetimes(responsetimedivider));
    }

    public double getMin(int responsetimedivider) {
        return StatUtils.min((double[])this.extractResponsetimes(responsetimedivider));
    }

    public double getMax(int responsetimedivider) {
        return StatUtils.max((double[])this.extractResponsetimes(responsetimedivider));
    }

    public double getPercentile95(int responsetimedivider) {
        return StatUtils.percentile((double[])this.extractResponsetimes(responsetimedivider), (double)95.0);
    }

    public long getFirstTimestamp() {
        return ((ResponsetimeSample)this.samples.get(0)).getTimestamp();
    }

    public double[] extractResponsetimes(int responsetimedivider) {
        double[] responsetimes = new double[this.samples.size()];
        int i = 0;
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            ResponsetimeSample sample = (ResponsetimeSample)it.next();
            responsetimes[i++] = sample.getResponsetime() / responsetimedivider;
        }
        return responsetimes;
    }

    public final void appendResponsetimes(TimeSeries series, int responsetimeDivider) {
        long delta = this.getFirstTimestamp();
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            ResponsetimeSample sample = (ResponsetimeSample)it.next();
            Millisecond timestamp = Utils.createMS(sample.getTimestamp() - delta);
            double responseTime = sample.getResponsetime() / responsetimeDivider;
            series.addOrUpdate((RegularTimePeriod)timestamp, responseTime);
        }
    }

    public final void appendThreadCounts(TimeSeries series, long threadCountDuration) {
        if (this.samples.size() > 0) {
            long firstSerial = this.getFirstTimestamp();
            HashMap<String, ResponsetimeSample> activeThreads = new HashMap<String, ResponsetimeSample>();
            Iterator it = this.samples.iterator();
            while (it.hasNext()) {
                ResponsetimeSample sample = (ResponsetimeSample)it.next();
                int threadCount = activeThreads.size();
                Iterator it2 = activeThreads.keySet().iterator();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    if (sample.getTimestamp() <= ((ResponsetimeSample)activeThreads.get(key)).getTimestamp() + threadCountDuration) continue;
                    it2.remove();
                }
                activeThreads.put(sample.getThreadId(), sample);
                if (threadCount == activeThreads.size()) continue;
                series.addOrUpdate((RegularTimePeriod)Utils.createMS(sample.getTimestamp() - firstSerial), (double)threadCount);
                series.addOrUpdate((RegularTimePeriod)Utils.createMS(sample.getTimestamp() - firstSerial + 1L), (double)activeThreads.size());
            }
            ResponsetimeSample sample = (ResponsetimeSample)this.samples.get(this.samples.size() - 1);
            series.addOrUpdate((RegularTimePeriod)Utils.createMS(sample.getTimestamp() - firstSerial + 1L), (double)activeThreads.size());
        }
    }

    public final TimeSeries createMovingThroughput(String name, final int responsetimedivider) {
        long firstAllowedTimestamp;
        TimeSeries series = new TimeSeries((Comparable)((Object)name), class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = ResponsetimeSamples.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        if (this.samples.isEmpty()) {
            return series;
        }
        Collections.sort(this.samples, new Comparator(){

            public int compare(Object arg1, Object arg2) {
                ResponsetimeSample sample1 = (ResponsetimeSample)arg1;
                ResponsetimeSample sample2 = (ResponsetimeSample)arg2;
                long endtime1 = sample1.getTimestamp() + (long)sample1.getResponsetime() / (long)responsetimedivider;
                long endtime2 = sample2.getTimestamp() + (long)sample2.getResponsetime() / (long)responsetimedivider;
                return (int)(endtime1 - endtime2);
            }
        });
        int periodLength = 1000;
        long rampUpTime = 0L;
        int measurements = 0;
        long periodStart = firstAllowedTimestamp = this.getFirstTimestamp() + rampUpTime;
        long periodEnd = periodStart + (long)periodLength;
        for (int i = 0; i < this.samples.size(); ++i) {
            ResponsetimeSample sample = (ResponsetimeSample)this.samples.get(i);
            long sampleEndTime = sample.getTimestamp() + (long)(sample.getResponsetime() / responsetimedivider);
            if (sampleEndTime < periodStart) continue;
            if (sampleEndTime <= periodEnd) {
                ++measurements;
                continue;
            }
            if (measurements > 0) {
                series.addOrUpdate((RegularTimePeriod)Utils.createMS(periodEnd - firstAllowedTimestamp), (double)(measurements * responsetimedivider));
            } else {
                series.addOrUpdate((RegularTimePeriod)Utils.createMS(periodEnd - firstAllowedTimestamp), null);
            }
            measurements = 1;
            periodStart = periodEnd;
            periodEnd = periodStart + (long)periodLength;
        }
        return series;
    }

    public double getMaxAverageThroughput(int averageduration, int responsetimedivider) {
        TimeSeries series = this.createMovingThroughput("", responsetimedivider);
        TimeSeries averageseries = MovingAverage.createMovingAverage((TimeSeries)series, (String)"", (int)averageduration, (int)0);
        double max = 0.0;
        Iterator it = averageseries.getItems().iterator();
        while (it.hasNext()) {
            TimeSeriesDataItem item = (TimeSeriesDataItem)it.next();
            if (item.getValue() == null) continue;
            max = Math.max(max, item.getValue().doubleValue());
        }
        return max;
    }

    public long getTotalTime() {
        ResponsetimeSample first = (ResponsetimeSample)this.samples.get(0);
        ResponsetimeSample last = (ResponsetimeSample)this.samples.get(this.samples.size() - 1);
        return last.getTimestamp() + (long)last.getResponsetime() - first.getTimestamp();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

