/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.chart.ChartSource;
import org.codehaus.mojo.chronos.chart.GraphGenerator;
import org.codehaus.mojo.chronos.report.ReportSink;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;

public class ReportGenerator {
    private static final String IMG_EXT = ".png";
    private NumberFormat formatter = new DecimalFormat("#.#");
    private ReportConfig config;
    private ResourceBundle bundle;
    private ReportSink reportSink;
    private Sink sink;
    private GraphGenerator graphs;

    public ReportGenerator(ResourceBundle bundle, ReportConfig config, GraphGenerator graphs) {
        this.bundle = bundle;
        this.config = config;
        this.graphs = graphs;
    }

    public void doGenerateReport(Sink sink, ResponsetimeSamples samples) {
        this.reportSink = new ReportSink(this.bundle, sink);
        this.sink = sink;
        sink.head();
        sink.text(this.bundle.getString("chronos.description"));
        sink.head_();
        sink.body();
        this.constructReportHeaderSection(samples);
        if (this.config.isShowsummary()) {
            this.constructReportSummarySection(samples);
        }
        if (this.config.isShowdetails() && samples instanceof GroupedResponsetimeSamples) {
            this.constructIndividualTestsSection((GroupedResponsetimeSamples)samples);
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void constructReportHeaderSection(ResponsetimeSamples samples) {
        String title = this.config.getTitle();
        String description = this.config.getDescription();
        String anchor = "Report" + this.config.getId();
        this.reportSink.constructHeaderSection(title, description, anchor);
    }

    private void constructReportSummarySection(ResponsetimeSamples samples) {
        String text = this.bundle.getString("chronos.label.summary");
        String anchor = "Summary" + this.config.getId();
        this.reportSink.title2(text, anchor);
        this.constructReportHotLinks();
        if (this.config.isShowinfotable() && samples instanceof GroupedResponsetimeSamples) {
            this.sink.table();
            this.sink.tableRow();
            this.reportSink.th("chronos.label.tests");
            if (this.config.isShowtimeinfo()) {
                this.reportSink.th("chronos.label.percentile95");
                this.reportSink.th("chronos.label.averagetime");
            }
            this.reportSink.th("chronos.label.iterations");
            this.reportSink.th("chronos.label.successrate");
            this.sink.tableRow_();
            GroupedResponsetimeSamples groupedSamples = (GroupedResponsetimeSamples)samples;
            Iterator it = groupedSamples.getSampleGroups().iterator();
            while (it.hasNext()) {
                ResponsetimeSampleGroup sampleGroup = (ResponsetimeSampleGroup)it.next();
                this.sink.tableRow();
                this.reportSink.sinkCellLink(sampleGroup.getName(), "#a" + sampleGroup.getIndex() + this.config.getId());
                if (this.config.isShowtimeinfo()) {
                    this.reportSink.sinkCell(this.formatter.format(sampleGroup.getPercentile95(this.config.getResponsetimedivider())));
                    this.reportSink.sinkCell(this.formatter.format(sampleGroup.getAverage(this.config.getResponsetimedivider())));
                }
                this.reportSink.sinkCell("" + sampleGroup.size());
                this.reportSink.sinkCell(this.formatter.format(sampleGroup.getSuccessrate()) + " %");
                this.sink.tableRow_();
            }
            this.sink.table_();
            this.reportSink.sinkLineBreak();
        }
        if (!this.config.isShowsummarycharts()) {
            return;
        }
        Iterator iterator = this.graphs.getSummaryChartSources().iterator();
        while (iterator.hasNext()) {
            ChartSource chartSource = (ChartSource)iterator.next();
            if (!chartSource.isEnabled(this.bundle, this.config)) continue;
            this.reportSink.graphics(chartSource.getFileName(this.bundle, this.config) + IMG_EXT);
        }
    }

    private void constructIndividualTestsSection(GroupedResponsetimeSamples samples) {
        this.reportSink.title2(this.bundle.getString("chronos.label.testcases"), "Test_Cases" + this.config.getId());
        this.constructReportHotLinks();
        Iterator it = samples.getSampleGroups().iterator();
        while (it.hasNext()) {
            ResponsetimeSampleGroup sampleGroup = (ResponsetimeSampleGroup)it.next();
            this.reportSink.title3(sampleGroup.getName(), sampleGroup.getIndex() + this.config.getId());
            if (this.config.isShowinfotable()) {
                this.sink.table();
                ArrayList<String> headerLabels = new ArrayList<String>();
                if (this.config.isShowtimeinfo()) {
                    headerLabels.add("chronos.label.mintime");
                    headerLabels.add("chronos.label.averagetime");
                    headerLabels.add("chronos.label.percentile95");
                    headerLabels.add("chronos.label.maxtime");
                }
                headerLabels.add("chronos.label.iterations");
                headerLabels.add("chronos.label.failures");
                headerLabels.add("chronos.label.successrate");
                ArrayList<String> dataLine = new ArrayList<String>();
                if (this.config.isShowtimeinfo()) {
                    dataLine.add(this.formatter.format(sampleGroup.getMin(this.config.getResponsetimedivider())));
                    dataLine.add(this.formatter.format(sampleGroup.getAverage(this.config.getResponsetimedivider())));
                    dataLine.add(this.formatter.format(sampleGroup.getPercentile95(this.config.getResponsetimedivider())));
                    dataLine.add(this.formatter.format(sampleGroup.getMax(this.config.getResponsetimedivider())));
                }
                dataLine.add("" + sampleGroup.size() * this.config.getResponsetimedivider());
                dataLine.add(this.formatter.format(sampleGroup.getFailed()));
                dataLine.add(this.formatter.format(sampleGroup.getSuccessrate()) + " %");
                ArrayList<ArrayList<String>> dataLines = new ArrayList<ArrayList<String>>();
                dataLines.add(dataLine);
                this.reportSink.table(headerLabels, dataLines);
            }
            Iterator iterator = this.graphs.getDetailsChartSources(sampleGroup.getName()).iterator();
            while (iterator.hasNext()) {
                ChartSource source = (ChartSource)iterator.next();
                if (!source.isEnabled(this.bundle, this.config)) continue;
                this.reportSink.graphics(source.getFileName(this.bundle, this.config) + IMG_EXT);
            }
        }
        this.reportSink.sinkLineBreak();
    }

    private void constructReportHotLinks() {
        this.sink.section3();
        if (this.config.isShowsummary()) {
            this.reportSink.sinkLink(this.bundle.getString("chronos.label.summary"), "Summary" + this.config.getId());
        }
        if (this.config.isShowdetails()) {
            this.reportSink.sinkLink(this.bundle.getString("chronos.label.testcases"), "Test_Cases" + this.config.getId());
        }
        this.sink.section3_();
    }
}

