/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.util.ResourceBundle;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.chronos.history.HistoricSamples;
import org.codehaus.mojo.chronos.report.ReportSink;

public class HistoryReportGenerator {
    private static final String IMG_EXT = ".png";
    private String dataId;
    private ResourceBundle bundle;
    private ReportSink reportSink;
    private String title;
    private String description;
    private Sink sink;

    public HistoryReportGenerator(String dataId, ResourceBundle bundle, String title, String description) {
        this.dataId = dataId;
        this.bundle = bundle;
        this.title = title;
        this.description = description;
    }

    public void doGenerateReport(Sink sink, HistoricSamples samples, boolean showgc) {
        this.reportSink = new ReportSink(this.bundle, sink);
        this.sink = sink;
        sink.head();
        sink.text(this.bundle.getString("chronos.description"));
        sink.head_();
        sink.body();
        String anchor = "Report" + this.dataId;
        this.reportSink.constructHeaderSection(this.title, this.description, anchor);
        String text = this.bundle.getString("chronos.label.summary");
        String anchor1 = "Summary" + this.dataId;
        this.reportSink.title2(text, anchor1);
        this.constructReportHotLinks();
        this.reportSink.graphics("history-response-summary-" + this.dataId + IMG_EXT);
        this.reportSink.graphics("history-throughput-" + this.dataId + IMG_EXT);
        if (showgc) {
            this.reportSink.graphics("history-gc-" + this.dataId + IMG_EXT);
        }
        this.reportSink.title2(this.bundle.getString("chronos.label.testcases"), "Test_Cases" + this.dataId);
        this.constructReportHotLinks();
        String[] groupNames = samples.getGroupNames();
        for (int i = 0; i < groupNames.length; ++i) {
            this.reportSink.title3(groupNames[i], i + this.dataId);
            this.reportSink.graphics("history-response-" + i + "-" + this.dataId + IMG_EXT);
        }
        this.reportSink.sinkLineBreak();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void constructReportHotLinks() {
        this.sink.section3();
        this.reportSink.sinkLink(this.bundle.getString("chronos.label.summary"), "Summary" + this.dataId);
        this.reportSink.sinkLink(this.bundle.getString("chronos.label.testcases"), "Test_Cases" + this.dataId);
        this.sink.section3_();
    }
}

