/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavaCommand {
    private Commandline commandLine;
    private Log log;

    public JavaCommand(String workingDir, Log log) {
        this.log = log;
        this.commandLine = new Commandline();
        this.commandLine.setExecutable("java");
        this.commandLine.setWorkingDirectory(workingDir);
    }

    void addSystemProperty(String name, String value) {
        this.addArgument("-D" + name + "=" + value);
    }

    void addJvmOption(String name, String value) {
        this.addArgument("-X" + name + "=" + value);
    }

    void addExtraJvmOption(String name, String value) {
        this.addArgument("-XX" + name + "=" + value);
    }

    void addArgument(String arg) {
        this.commandLine.createArgument().setValue(arg);
    }

    int execute() throws CommandLineException {
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                JavaCommand.this.log.info((CharSequence)line);
            }
        };
        return CommandLineUtils.executeCommandLine((Commandline)this.commandLine, (StreamConsumer)consumer, (StreamConsumer)consumer);
    }

    public String toString() {
        return this.commandLine.toString();
    }
}

