/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.gc.GCLogParser;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.codehaus.mojo.chronos.jmeter.JMeterLogParser;
import org.codehaus.mojo.chronos.jmeter.JMeterMojo;
import org.codehaus.mojo.chronos.jmeter.JavaCommand;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.xml.sax.SAXException;

public class JMeterTestMojo
extends JMeterMojo {
    protected MavenProject project;
    private File input;
    private String dataid;
    private boolean loggc;
    private File gclogfile;
    private String bootstrapper;

    public void execute() throws MojoExecutionException {
        if (!this.input.exists()) {
            throw new MojoExecutionException("Invalid argument 'input', file " + this.input.getPath() + " does notexist.");
        }
        if (this.getJtlFile().exists() && this.input.lastModified() > this.getJtlFile().lastModified()) {
            this.getLog().info((CharSequence)"clearing old testlog");
            this.getJtlFile().delete();
        }
        if (!this.getJtlFile().exists()) {
            block10: {
                if (this.bootstrapper != null) {
                    this.getLog().info((CharSequence)("Launching bootstrapper " + this.bootstrapper));
                    JavaCommand bootstrapCmd = new JavaCommand(this.project.getBasedir().getAbsolutePath(), this.getLog());
                    bootstrapCmd.addArgument("-cp");
                    StringBuffer classPath = new StringBuffer();
                    Iterator it = this.getDependencyUtil().getDependencies(this.project).iterator();
                    while (it.hasNext()) {
                        Artifact artifact = (Artifact)it.next();
                        classPath.append(artifact.getFile());
                        if (!it.hasNext()) continue;
                        classPath.append(File.pathSeparatorChar);
                    }
                    bootstrapCmd.addArgument(classPath.toString());
                    bootstrapCmd.addArgument(this.bootstrapper);
                    try {
                        int result = bootstrapCmd.execute();
                        if (result != 0) {
                            throw new MojoExecutionException("Result of " + bootstrapCmd + " execution is: '" + result + "'.");
                        }
                        break block10;
                    }
                    catch (CommandLineException e) {
                        throw new MojoExecutionException("Could not create bootstrapper", (Exception)((Object)e));
                    }
                }
                this.getLog().info((CharSequence)"No bootstrapper class found");
            }
            JavaCommand java = this.getJavaLauncher();
            java.addArgument("-jar");
            String jmeterJar = this.getJmeterJar().getAbsolutePath();
            java.addArgument(jmeterJar);
            java.addArgument("-n");
            java.addArgument("-t");
            java.addArgument(this.input.getAbsolutePath());
            java.addArgument("-l");
            java.addArgument(this.getJtlFile().getAbsolutePath());
            this.getLog().info((CharSequence)("Excuting test " + this.input.getPath()));
            this.executeJmeter(java);
        } else {
            this.getLog().info((CharSequence)("jtl file " + this.getJtlFile().getAbsolutePath() + " up-to-date, skipping..."));
        }
        if (this.loggc && this.getGcLogFile().exists()) {
            this.parseGCLog();
        }
        this.parseJmeterLog();
    }

    public void setInput(File input) {
        this.input = input;
    }

    public void setDataid(String dataid) {
        this.dataid = dataid;
    }

    public void setLoggc(boolean loggc) {
        this.loggc = loggc;
    }

    public void setGclogfile(File gclogfile) {
        this.gclogfile = gclogfile;
    }

    private void parseGCLog() throws MojoExecutionException {
        try {
            GCSamples samples = new GCLogParser().parseGCLog(this.getGcLogFile());
            Utils.writeObject(samples, Utils.getGcSamplesSer(this.getProject().getBasedir(), this.dataid));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to parse garbage collection log", (Exception)e);
        }
    }

    private void parseJmeterLog() throws MojoExecutionException {
        File perfSamplesSer = Utils.getPerformanceSamplesSer(this.getProject().getBasedir(), this.dataid);
        try {
            GroupedResponsetimeSamples samples = new JMeterLogParser().parseJMeterLog(this.getJtlFile());
            Utils.writeObject(samples, perfSamplesSer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not parse jmeter log", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Could not parse jmeter log", (Exception)e);
        }
    }

    private File getJtlFile() {
        if (this.input.getName().endsWith(".jtl")) {
            return this.input;
        }
        File chronosDir = Utils.getChronosDir(this.getProject().getBasedir());
        return new File(chronosDir, "jmeterlog-" + this.dataid + ".jtl");
    }

    protected final File getGcLogFile() {
        if (!this.loggc) {
            return null;
        }
        if (this.gclogfile != null) {
            return this.gclogfile;
        }
        File chronosDir = Utils.getChronosDir(this.getProject().getBasedir());
        return new File(chronosDir, "gclog-" + this.dataid + ".txt");
    }

    protected final MavenProject getProject() {
        return this.project;
    }
}

