/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.util.Hashtable;
import java.util.Properties;
import org.codehaus.mojo.chronos.jmeter.Jtl20Sample;
import org.codehaus.mojo.chronos.jmeter.Jtl21Sample;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMeterSAXFileHandler
extends DefaultHandler {
    private final GroupedResponsetimeSamples samples = new GroupedResponsetimeSamples();
    private Properties sampleAttributes;
    private boolean inProperty = false;
    private boolean insideSample = false;
    private StringBuffer testMethodNameSB = new StringBuffer();
    private Properties parentSampleAttributes;
    int count = 0;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("sampleResult".equals(qName)) {
            Properties props = new Properties();
            for (int i = 0; i < attributes.getLength(); ++i) {
                ((Hashtable)props).put(attributes.getQName(i), attributes.getValue(i));
            }
            this.sampleAttributes = props;
            this.insideSample = true;
        } else if ("property".equals(qName)) {
            this.inProperty = true;
        } else if ("httpSample".equals(qName) || "sample".equals(qName)) {
            if (this.insideSample) {
                this.parentSampleAttributes = this.sampleAttributes;
            }
            Properties props = new Properties();
            for (int i = 0; i < attributes.getLength(); ++i) {
                ((Hashtable)props).put(attributes.getQName(i), attributes.getValue(i));
            }
            this.sampleAttributes = props;
            this.insideSample = true;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.insideSample && this.inProperty) {
            this.testMethodNameSB.append(new String(ch, start, length));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("property".equals(qName)) {
            this.inProperty = false;
        } else if ("sampleResult".equals(qName)) {
            Jtl20Sample sample = new Jtl20Sample(this.sampleAttributes);
            String sampleName = Jtl20Sample.getSampleName(this.sampleAttributes, this.testMethodNameSB.toString());
            this.samples.add(sample, sampleName);
            this.testMethodNameSB.setLength(0);
            this.insideSample = false;
            this.sampleAttributes = null;
        } else if ("httpSample".equals(qName) || "sample".equals(qName)) {
            if (!this.insideSample) {
                this.sampleAttributes = this.parentSampleAttributes;
            }
            String sampleName = Jtl21Sample.getSampleName(this.sampleAttributes);
            Jtl21Sample sample = new Jtl21Sample(this.sampleAttributes);
            this.samples.add(sample, sampleName);
            this.testMethodNameSB.setLength(0);
            this.sampleAttributes = null;
            this.insideSample = false;
        }
    }

    public GroupedResponsetimeSamples getJMeterSamples() {
        return this.samples;
    }
}

