/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.jmeter.DependencyUtil;
import org.codehaus.mojo.chronos.jmeter.JavaCommand;
import org.codehaus.plexus.util.cli.CommandLineException;

public abstract class JMeterMojo
extends AbstractMojo {
    private File jmeterhome;
    private String heap = "256m";
    private String newsize = "128m";
    private String survivorratio;
    private String targetsurvivorratio;
    private String maxtenuringthreshold = "2";
    private String maxliveobjectevacuationratio;
    private String rmigcinterval = "600000";
    private String permsize = "64m";
    private Properties sysproperties = new Properties();
    private List options;

    protected final void executeJmeter(JavaCommand java) throws MojoExecutionException {
        DependencyUtil deps = this.getDependencyUtil();
        List copied = null;
        try {
            copied = deps.copyDependencies(this.getProject());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Execution failed", (Exception)e);
        }
        try {
            int result = java.execute();
            if (result != 0) {
                throw new MojoExecutionException("Result of " + java + " execution is: '" + result + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Execution failed", (Exception)((Object)e));
        }
        finally {
            if (copied != null) {
                deps.cleanUpDependencies(copied);
            }
        }
    }

    protected final DependencyUtil getDependencyUtil() {
        return new DependencyUtil(this.jmeterhome, this.getLog());
    }

    protected final JavaCommand getJavaLauncher() throws MojoExecutionException {
        if (this.jmeterhome == null) {
            throw new MojoExecutionException("Missing jmeterhome. You must eithe define a property jmeter.home or set the jmeterhome explicitly in your plugin execution");
        }
        JavaCommand java = new JavaCommand(this.getProject().getBasedir().getAbsolutePath(), this.getLog());
        java.addSystemProperty("user.dir", this.jmeterhome + "/bin");
        java.addArgument("-server");
        java.addArgument("-Xms" + this.heap);
        java.addArgument("-Xmx" + this.heap);
        java.addArgument("-XX:NewSize=" + this.newsize);
        java.addArgument("-XX:MaxNewSize=" + this.newsize);
        if (this.survivorratio != null) {
            java.addArgument("-XX:SurvivorRatio=" + this.survivorratio);
        }
        if (this.targetsurvivorratio != null) {
            java.addArgument("-XX:TargetSurvivorRatio=" + this.targetsurvivorratio);
        }
        java.addArgument("-XX:MaxTenuringThreshold=" + this.maxtenuringthreshold);
        if (this.maxliveobjectevacuationratio != null) {
            java.addArgument("-XXMaxLiveObjectEvacuationRatio=" + this.maxliveobjectevacuationratio);
        }
        java.addArgument("-XX:PermSize=" + this.permsize);
        java.addArgument("-XX:MaxPermSize=" + this.permsize);
        File gclog = this.getGcLogFile();
        if (gclog != null) {
            java.addArgument("-verbose:gc");
            java.addArgument("-Xloggc:" + gclog.getAbsolutePath());
        }
        if (!((Hashtable)this.sysproperties).containsKey("sun.rmi.dgc.client.gcInterval")) {
            this.sysproperties.setProperty("sun.rmi.dgc.client.gcInterval", this.rmigcinterval);
        }
        if (!((Hashtable)this.sysproperties).containsKey("sun.rmi.dgc.server.gcInterval")) {
            this.sysproperties.setProperty("sun.rmi.dgc.server.gcInterval", this.rmigcinterval);
        }
        Enumeration<?> sysPropNames = this.sysproperties.propertyNames();
        while (sysPropNames.hasMoreElements()) {
            String name = (String)sysPropNames.nextElement();
            String value = this.sysproperties.getProperty(name);
            java.addSystemProperty(name, value);
        }
        if (this.options != null) {
            Iterator it = this.options.iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                java.addArgument(option);
            }
        }
        return java;
    }

    protected final File getJmeterJar() {
        return new File(new File(this.jmeterhome, "bin"), "ApacheJMeter.jar");
    }

    protected abstract File getGcLogFile();

    protected abstract MavenProject getProject();
}

