/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.mojo.chronos.jmeter.JMeterSAXFileHandler;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMeterLogParser {
    private final SAXParser saxParser;

    public JMeterLogParser() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            this.saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static GroupedResponsetimeSamples parseJMeterLog(String jtlFilePath) throws Exception {
        File file = new File(jtlFilePath);
        return new JMeterLogParser().parseJMeterLog(file);
    }

    public GroupedResponsetimeSamples parseJMeterLog(File file) throws SAXException, IOException {
        JMeterSAXFileHandler saxHandler = new JMeterSAXFileHandler();
        this.saxParser.parse(file, (DefaultHandler)saxHandler);
        return saxHandler.getJMeterSamples();
    }
}

