/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jfree.io.IOUtils;

public class DependencyUtil {
    private File jmeterhome;
    private Log log;

    public DependencyUtil(File jmeterHome, Log log) {
        this.jmeterhome = jmeterHome;
        this.log = log;
    }

    public List getDependencies(MavenProject project) {
        ArrayList<File> result = new ArrayList<File>();
        Iterator it = project.getAttachedArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            File attachedArtifactFile = artifact.getFile();
            result.add(attachedArtifactFile);
        }
        File artifactFile = project.getArtifact().getFile();
        if (artifactFile == null) {
            this.log.warn((CharSequence)"Artifact not found. Note that if Your JMeter test contains JUnittestcases, You can only invoke this goal through the default lifecycle.");
        } else {
            result.add(artifactFile);
        }
        Set dependencyArtifacts = project.getArtifacts();
        if (dependencyArtifacts != null) {
            Iterator deps = dependencyArtifacts.iterator();
            while (deps.hasNext()) {
                Artifact dependency = (Artifact)deps.next();
                result.add(dependency.getFile());
            }
        }
        return result;
    }

    List copyDependencies(MavenProject project) throws IOException {
        final ArrayList copied = new ArrayList();
        Iterator it = this.getDependencies(project).iterator();
        while (it.hasNext()) {
            File artifactFile = (File)it.next();
            this.copyFileToDir(artifactFile, copied);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DependencyUtil.this.cleanUpDependencies(copied);
            }
        });
        return copied;
    }

    void cleanUpDependencies(List copied) {
        Iterator iterator = copied.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            file.delete();
        }
    }

    void copyFileToDir(File file, List copied) throws IOException {
        File lib = new File(this.jmeterhome, "lib");
        File junitdir = new File(lib, "junit");
        File target = new File(junitdir, file.getName());
        int i = 0;
        while (target.exists()) {
            target = new File(junitdir, String.valueOf(i) + "-" + file.getName());
            ++i;
        }
        target.createNewFile();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(target));
        IOUtils.getInstance().copyStreams((InputStream)input, (OutputStream)output);
        ((OutputStream)output).close();
        ((InputStream)input).close();
        this.log.debug((CharSequence)("Dependency copied to jmeter distribution at: " + target));
        copied.add(target);
    }
}

