/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.history;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.codehaus.mojo.chronos.history.HistoricSample;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;

public class SaveHistoryMojo
extends AbstractMojo {
    private MavenProject project;
    private File historydir;
    private String dataid;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File dataDirectory;
        if (!this.historydir.exists()) {
            this.historydir.mkdir();
        }
        if (!(dataDirectory = new File(this.historydir, this.dataid)).exists()) {
            dataDirectory.mkdir();
        }
        GroupedResponsetimeSamples responseSamples = this.getResponsetimeSamples();
        GCSamples gcSamples = this.getGcSamples();
        long firstTimestamp = responseSamples.getFirstTimestamp();
        String fileName = "history-" + firstTimestamp + ".ser";
        File historyFile = new File(dataDirectory, fileName);
        if (historyFile.exists()) {
            historyFile.delete();
        }
        HistoricSample history = new HistoricSample(responseSamples, gcSamples);
        try {
            Utils.writeObject(history, historyFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write historydata " + historyFile.getAbsolutePath());
        }
    }

    public void setDataid(String dataid) {
        this.dataid = dataid;
    }

    public void setHistorydir(File historydir) {
        this.historydir = historydir;
    }

    private GCSamples getGcSamples() throws MojoExecutionException {
        try {
            return Utils.readGCSamples(this.project.getBasedir(), this.dataid);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid);
        }
    }

    private GroupedResponsetimeSamples getResponsetimeSamples() throws MojoExecutionException {
        File responsetimeSamples = Utils.getPerformanceSamplesSer(this.project.getBasedir(), this.dataid);
        if (!responsetimeSamples.exists()) {
            throw new MojoExecutionException("File " + responsetimeSamples.getAbsolutePath() + " not found");
        }
        try {
            return (GroupedResponsetimeSamples)Utils.readObject(responsetimeSamples);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to read responsetimesamples " + responsetimeSamples.getAbsolutePath(), (Exception)e);
        }
    }
}

