/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.history.HistoricSample;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class HistoricSamples {
    private List groupNames = new ArrayList();
    private List samples = new ArrayList();

    public void load(File dataDirectory) throws IOException {
        Object[] historyFiles = dataDirectory.listFiles();
        Arrays.sort(historyFiles);
        for (int i = 0; i < historyFiles.length; ++i) {
            HistoricSample sample = (HistoricSample)Utils.readObject((File)historyFiles[i]);
            this.addHistoricSample(sample);
        }
    }

    void addHistoricSample(HistoricSample sample) {
        this.samples.add(sample);
        Iterator it = sample.getGroupNames().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (this.groupNames.contains(name)) continue;
            this.groupNames.add(name);
        }
    }

    public String[] getGroupNames() {
        return this.groupNames.toArray(new String[this.groupNames.size()]);
    }

    public TimeSeries getAverageTime(String name) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetimeAverage();
            }

            public boolean accept(HistoricSample sample) {
                return true;
            }
        });
    }

    public TimeSeries getAverageTime(String name, final String groupName) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetimeAverage(groupName);
            }

            public boolean accept(HistoricSample sample) {
                return sample.getGroupNames().contains(groupName);
            }
        });
    }

    public TimeSeries getpercentile95(String name) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetime95Percentile();
            }

            public boolean accept(HistoricSample sample) {
                return true;
            }
        });
    }

    public TimeSeries getPercentile95(String name, final String groupName) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetimePercentiles(groupName);
            }

            public boolean accept(HistoricSample sample) {
                return sample.getGroupNames().contains(groupName);
            }
        });
    }

    public TimeSeries getThroughput(String name) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getMaxAverageThroughput();
            }

            public boolean accept(HistoricSample sample) {
                return true;
            }
        });
    }

    public TimeSeries getGcRatio(String name) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getGcRatio();
            }

            public boolean accept(HistoricSample sample) {
                return true;
            }
        });
    }

    public TimeSeries getKbCollectedPrSecond(String name) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getCollectedPrSecond();
            }

            public boolean accept(HistoricSample sample) {
                return true;
            }
        });
    }

    private TimeSeries visitAll(String name, HistoricSampleExtractor visitor) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            HistoricSample sample = (HistoricSample)it.next();
            if (!visitor.accept(sample)) continue;
            Millisecond timestamp = new Millisecond(new Date(sample.getTimestamp()));
            double value = visitor.extract(sample);
            series.addOrUpdate((RegularTimePeriod)timestamp, value);
        }
        return series;
    }

    static interface HistoricSampleExtractor {
        public double extract(HistoricSample var1);

        public boolean accept(HistoricSample var1);
    }
}

