/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.history;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSampleGroup;

public class HistoricSample
implements Serializable {
    private static final long serialVersionUID = 8492792243093456318L;
    private long timestamp;
    private double gcRatio = -1.0;
    private double collectedPrSecond = -1.0;
    private double responsetimeAverage = -1.0;
    private double responsetime95Percentile = -1.0;
    private HashMap individualPercentiles;
    private HashMap individualAverages;
    private double maxAverageThroughput = -1.0;

    public HistoricSample(GroupedResponsetimeSamples responseSamples, GCSamples gcSamples) {
        this.timestamp = responseSamples.getFirstTimestamp();
        this.responsetimeAverage = responseSamples.getAverage(1);
        this.responsetime95Percentile = responseSamples.getPercentile95(1);
        this.individualAverages = new HashMap();
        this.individualPercentiles = new HashMap();
        Iterator it = responseSamples.getSampleGroups().iterator();
        while (it.hasNext()) {
            ResponsetimeSampleGroup group = (ResponsetimeSampleGroup)it.next();
            this.individualAverages.put(group.getName(), new Double(group.getAverage(1)));
            this.individualPercentiles.put(group.getName(), new Double(group.getPercentile95(1)));
        }
        if (gcSamples != null) {
            this.gcRatio = gcSamples.getGarbageCollectionRatio(responseSamples.getTotalTime());
            this.collectedPrSecond = gcSamples.getCollectedKBPerSecond(responseSamples.getTotalTime());
        }
        int averageDuration = Math.max(20000, (int)this.responsetime95Percentile);
        this.maxAverageThroughput = responseSamples.getMaxAverageThroughput(averageDuration, 1);
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final double getGcRatio() {
        return this.gcRatio;
    }

    public final double getCollectedPrSecond() {
        return this.collectedPrSecond;
    }

    public final double getResponsetimeAverage() {
        return this.responsetimeAverage;
    }

    public final double getResponsetime95Percentile() {
        return this.responsetime95Percentile;
    }

    public final Set getGroupNames() {
        return this.individualAverages.keySet();
    }

    public final double getResponsetimeAverage(String groupName) {
        return (Double)this.individualAverages.get(groupName);
    }

    public final double getResponsetimePercentiles(String groupName) {
        return (Double)this.individualPercentiles.get(groupName);
    }

    public final double getMaxAverageThroughput() {
        return this.maxAverageThroughput;
    }
}

